package com.aniways.quick.action;

import android.content.Context;
import android.util.AttributeSet;
import android.support.v7.widget.GridLayout;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.ui.AniwaysUiUtil;

import java.util.List;

/**
 * Created by moran on 1/15/2015.
 */
public class AniwaysGridView extends GridLayout {
    private static final String TAG = "AniwaysGridView";
    protected List<View> collection;
    private int containerWidth;
    private AniwaysAction<SelectedGridItemInfo> onItemSelectedCallback;
    private int columns;
    private int rows;
    protected GridItemDimenstions gridItemDimenstions;

    public AniwaysGridView(Context context) {
        super(context);
    }

    public AniwaysGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AniwaysGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void initialize(int containerWidth, AniwaysAction<SelectedGridItemInfo> onItemSelectedCallback){
        this.containerWidth = containerWidth;
        this.onItemSelectedCallback = onItemSelectedCallback;

        if (collection == null || collection.isEmpty()){
            Log.i(TAG, "trying to add action items to track with null or empty list");
            return;
        }

        if (gridItemDimenstions == null){
            Log.i(TAG, "trying to add action items to track without grid dimensions");
            return;
        }

        addItemsToGrid();
    }

    private void addItemsToGrid() {
        boolean isLastItemInRow = false;
        boolean isLastRow = false;

        int total = collection.size();
        int maxNumItemsInColumn = calcColumnsNumber(gridItemDimenstions.itemWidth + gridItemDimenstions.leftRightMargin, gridItemDimenstions.leftRightMargin);
        columns = Math.min(total,maxNumItemsInColumn);
        rows = calcRowNumber(total, columns);

        if (columns <= 0){ //Could not calculate columns - close the popup and return.
            return;
        }

        setColumnCount(columns);
        setRowCount(rows);

        for (int i = 0, c = 0, r = 0; i< total; i++, c++){
            View gridItem = null;

            gridItem = collection.get(i);

            if (gridItem == null){
                --c;
                continue;
            }

            if (c == columns - 1){
                isLastItemInRow = true;
            }

            if(c == columns)
            {
                c = 0;
                r++;
            }

            if (r == rows - 1){
                isLastRow = true;
            }


            addItemToGrid(c, r, i, total, gridItem, isLastRow, isLastItemInRow);

            isLastItemInRow = false;
            isLastRow = false;
        }
    }

    private void addItemToGrid(final int c, final int r, final int pos, final int totalNumberOfItems, final View gridItem, boolean isLastRow, boolean isLastItemInRow) {
        GridLayout.LayoutParams containerLp = getItemInGridLayoutParams(c, r,  isLastRow, isLastItemInRow);
        gridItem.setLayoutParams(containerLp);

        gridItem.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    if (onItemSelectedCallback != null) {
                        onItemSelectedCallback.call(new SelectedGridItemInfo(columns, c, r, rows, gridItem, pos, totalNumberOfItems));
                    }
                }
                catch (Throwable ex){
                    Log.e(true, TAG, "Caught Exception in on click", ex);
                }
            }
        });

        addView(gridItem);
    }

    private GridLayout.LayoutParams getItemInGridLayoutParams(int column, int row, boolean isLastRow, boolean isLastItemInRow) {
        GridLayout.LayoutParams containerLp = new GridLayout.LayoutParams();

        containerLp.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        containerLp.width = ViewGroup.LayoutParams.WRAP_CONTENT;

        containerLp.leftMargin = gridItemDimenstions.leftRightMargin;
        containerLp.topMargin = gridItemDimenstions.topBottomMargin;

        if (isLastItemInRow){
            containerLp.rightMargin = gridItemDimenstions.leftRightMargin;
        }

        if (isLastRow){
            containerLp.bottomMargin = gridItemDimenstions.topBottomMargin;
        }

        containerLp.setGravity(Gravity.CENTER);
        containerLp.columnSpec = GridLayout.spec(column);
        containerLp.rowSpec = GridLayout.spec(row);
        return containerLp;
    }

    private int calcRowNumber(int total, int columns) {
        if(columns == 0)
            return 0;

        int row = (total/columns);
        row+= (total % columns == 0) ? 0: 1;
        return row;
    }

    private int calcColumnsNumber(int singleIconWidth, int margin) {
        if (containerWidth == 0){ //assume that view should take the screen width
            containerWidth = AniwaysUiUtil.getScreenDisplayMatrix().widthPixels;
        }

        int columnNumber = (containerWidth - margin) / (singleIconWidth);

        return columnNumber; //Normalize - edged margins are not count when calculating column numbers.
    }

    protected void setGridItemDimension(int gridRowHeight, int gridItemMargin, int iconHeight) {
        int iconMaxHeight = Math.min((gridRowHeight - (2*gridItemMargin)),iconHeight);
        int iconMargin = (gridRowHeight - iconMaxHeight) / 2;

        //Assuming the grid item is square
        gridItemDimenstions = new GridItemDimenstions(iconMaxHeight,iconMaxHeight,iconMargin,iconMargin);
    }
}

