package com.aniways.quick.action;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;

import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.data.AniwaysAnimatedAssetInfo;
import com.aniways.data.AniwaysPharseContentModelBuilder;
import com.aniways.data.AniwaysPhraseToContentModel;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.Phrase;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.ui.AniwaysUiUtil;
import com.aniways.volley.toolbox.IResponseListener;
import com.aniways.volley.toolbox.ImageLoader;
import com.aniways.volley.toolbox.NetworkImageView;
import com.aniways.volley.toolbox.Volley;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Shai on 22/01/2015.
 */
public abstract class AniwaysContextualPopupGridView extends AniwaysGridView implements IAniwaysPopupView {
    private static final String TAG = "AniwaysContextualPopupGridView";
    protected ContextualPopupCreationContext popupCreationContext;
    protected boolean selected = false;
    protected HashMap<View, IAniwaysAssetInfo> nonFullyInitializedImageContainers = new HashMap<>();
    protected boolean moreRevealed;

    public AniwaysContextualPopupGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public AniwaysContextualPopupGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AniwaysContextualPopupGridView(Context context) {
        super(context);
    }

    @Override
    public void initialize() {
        initialize(0);
    }

    public void initialize(int containerWidth) {
        setGridDimentions();
        createGridWithPlaceHoldersForImages();
        super.initialize(containerWidth, getItemSelectedAction());
        AniwaysPharseContentModelBuilder modelBuilder = getDataExctractor();
        modelBuilder.extract(popupCreationContext.phrase, new AniwaysAction<AniwaysPhraseToContentModel>() {
            @Override
            public void call(AniwaysPhraseToContentModel model) {
                Log.i(TAG, "Received model. Is null: " + (model == null));
                if (model == null) {
                    removeAllViews();
                    return;
                }

                bindModel(model);
            }
        });
    }

    private void createGridWithPlaceHoldersForImages() {
        int maxGridItemsNumber = getMaxGridItemsNumber(popupCreationContext.phrase);
        collection = new ArrayList<>(maxGridItemsNumber);

        for (int i=0; i< maxGridItemsNumber; i++){
            collection.add(createItemView());
        }
    }

    private View createItemView() {

        LayoutInflater inflater =  LayoutInflater.from(getContext());

        final View iconContainer = inflater.inflate(R.layout.aniways_contextual_suggestions_popup_emoticon_item, null);

        final NetworkImageView img 	= (NetworkImageView) iconContainer.findViewById(R.id.aniways_action_item_icon);

        ViewGroup.LayoutParams lp =img.getLayoutParams();

        lp.width = gridItemDimenstions.itemWidth;
        lp.height = gridItemDimenstions.itemHeight;
        // Just to re-enforce it again, as it doesn't always stick..
        img.setMinimumWidth(gridItemDimenstions.itemWidth);
        img.setMinimumHeight(gridItemDimenstions.itemHeight);
        img.setScaleType(getImageScaleType());
        img.setLayoutParams(lp);
        img.setDefaultImageResId(R.color.aniways_Gray);
        img.setErrorImageResId(R.color.aniways_Gray);
        img.setImageUrl(null, Volley.getImageLoader());

        return iconContainer;
    }

    @Override
    public void onDetachedFromWindow(){
    }

    @Override
    public void notifyNotSelected() {
        selected = false;
        moreRevealed = false;
        for(View v : collection){
            NetworkImageView img = (NetworkImageView) v.findViewById(R.id.aniways_action_item_icon);
            img.stopAnimation();
        }
    }

    @Override
    public void notifySelected() {
        selected = true;
        moreRevealed = false;
        int index = 0;
        for(View v : collection){
            NetworkImageView img = (NetworkImageView) v.findViewById(R.id.aniways_action_item_icon);
            if(index < getColumnCount()) {
                // This is 1st row
                img.startAnimation();
            }
            index++;
        }
    }

    @Override
    public void notifyRevealMore() {
        moreRevealed = true;
        for (Map.Entry<View,IAniwaysAssetInfo> entry : nonFullyInitializedImageContainers.entrySet()){
            View imageContainer = entry.getKey();
            IAniwaysAssetInfo assetInfo = entry.getValue();
            setImageUrl(imageContainer, assetInfo, false);
        }
        nonFullyInitializedImageContainers.clear();
        int index = 0;
        for(View v : collection){
            NetworkImageView img = (NetworkImageView) v.findViewById(R.id.aniways_action_item_icon);
            if(index >= getColumnCount()) {
                // This is not 1st row
                img.startAnimation();
            }
            index++;
        }
    }

    @Override
    public void notifyRevealLess() {
        moreRevealed = false;
        int index = 0;
        for(View v : collection){
            NetworkImageView img = (NetworkImageView) v.findViewById(R.id.aniways_action_item_icon);
            if(index >= getColumnCount()) {
                // This is not 1st row
                img.stopAnimation();
            }
            index++;
        }
    }

    protected void registerImageResponseListener(final NetworkImageView img, final ImageView lockImage, final View imageContainer, final IAniwaysAssetInfo assetInfo, final boolean isFirstRow) {
        // TODO: Merge with the other response listener on this class..
        img.registerResponseListener(new IResponseListener() {
            @Override
            public void onError() {
                removeProgressbar(imageContainer);
                Log.e(true, TAG, "onError invoked while trying to download image or animated gif using volley ");

                Handler h = new Handler(Looper.getMainLooper());
                h.postDelayed(new NonThrowingRunnable(TAG, "addActionItem.onError", "") {

                    @Override
                    public void innerRun() {
                        // Put a toast asking to check internet connection and then close the popup
                        String toastString = "Please make sure you are connected to the Internet";
                        try {
                            toastString = getContext().getResources().getString(R.string.aniways_check_internet_connection);
                        } catch (Throwable ex) {
                            Log.w(true, TAG, "Caught Exception while getting make sure connected to intenet toast string", ex);
                        }
                        Toast toast = Toast.makeText(getContext(), toastString, Toast.LENGTH_LONG);
                        toast.setGravity(Gravity.CENTER, 0, 0);
                        toast.show();
                    }

                }, AniwaysPrivateConfig.getInstance().noInternetPopupCloseDelay);
            }

            @Override
            public void onSuccess() {
                removeProgressbar(imageContainer);
                setLockedIconIndicationIfNecessary(img,lockImage,assetInfo);
                if(selected && (moreRevealed || isFirstRow)){
                    img.startAnimation();
                }
                else{
                    img.stopAnimation();
                }
            }
        });
    }

    @SuppressLint("NewApi")
    private void setLockedIconIndicationIfNecessary(NetworkImageView img, ImageView lockImage, IAniwaysAssetInfo assetInfo) {
        if (assetInfo == null)
            return;

        IconData icon = assetInfo.getIconData();

        if (icon == null)
            return;

        if (AniwaysStoreManager.isIconLocked(icon)){
            lockImage.setVisibility(View.VISIBLE);
            if(Utils.isAndroidVersionAtLeast(11)){
                img.setAlpha(AniwaysPrivateConfig.getInstance().lockedIconAlpha);
            }
            else{
                img.setAlpha((int) (AniwaysPrivateConfig.getInstance().lockedIconAlpha*255));
            }
        }
        else{
            lockImage.setVisibility(View.GONE);
        }
    }


    protected void removeProgressbar(View imageContainer) {
        try{
            ProgressBar spinner = (ProgressBar)imageContainer.findViewById(R.id.aniways_progress_bar_id);
            if(spinner != null) {
                spinner.setVisibility(View.GONE);
            }
        }
        catch(Throwable t){
            Log.e(true, TAG, "Exception in IResponseListener onSuccess", t);
        }
    }

    protected void addProgressBar(final View container) {
        View relativeLayout = container.findViewById(R.id.relative_container);
        int progressBarStyle = AniwaysPrivateConfig.getInstance().contextualGridRowHeight >= AniwaysUiUtil.convertDipsToPixels(76)? android.R.attr.progressBarStyleLarge : android.R.attr.progressBarStyleSmall;
        ProgressBar pb = new ProgressBar(getContext(), null, progressBarStyle);
        pb.setId(R.id.aniways_progress_bar_id);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        params.addRule(RelativeLayout.CENTER_IN_PARENT, RelativeLayout.TRUE);
        pb.setLayoutParams(params );
        ((ViewGroup) relativeLayout).addView(pb);
    }

    public void setPopupCreationContext(ContextualPopupCreationContext context)
    {
        this.popupCreationContext = context;
    }

    private void bindModel(AniwaysPhraseToContentModel model) {
        int maxGridItemsNumber = getMaxGridItemsNumber(popupCreationContext.phrase);
        List<IAniwaysAssetInfo> assetInfoList = model.getAnimatedAssetInfos();
        int index = 0;
        final int numColumns = super.getColumnCount();

        for(IAniwaysAssetInfo assetInfo : assetInfoList){
            if (index == maxGridItemsNumber){
                break;
            }

            final int finalIndex = index;

            View imageContainer = collection.get(index);
            //TODO: See how to make something strongly typed instead ofthe tag..
            imageContainer.setTag(R.id.aniways_asset_info_tag, assetInfo);

            if(index < numColumns) {
                setImageUrl(imageContainer, assetInfo, true);
            }
            else {
                // This is not the first row, so we set url later..
                nonFullyInitializedImageContainers.put(imageContainer, assetInfo);
            }

            index++;
        }
    }

    private void setImageUrl(View imageContainer, final IAniwaysAssetInfo assetInfo, boolean isFirstRow) {
        final String url = assetInfo.getLowQualityUrl();
        Log.i(TAG,"setting image url: " + url);
        addProgressBar(imageContainer);
        final NetworkImageView imageView = (NetworkImageView) imageContainer.findViewById(R.id.aniways_action_item_icon);
        final ImageView lock = (ImageView) imageContainer.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
        registerImageResponseListener(imageView, lock, imageContainer, assetInfo, isFirstRow);
        imageView.setDefaultImageResId(R.color.aniways_Gray);
        imageView.setErrorImageResId(R.color.aniways_Gray);
        //TODO: this is done in the post because for some reason when the image is in the mem cache it will
        //  only show thw spinner (not even the default background
        post(new Runnable() {
            @Override
            public void run() {
                imageView.setImageUrl(url, Volley.getImageLoader());
            }
        });

    }

    private AniwaysAction<SelectedGridItemInfo> getItemSelectedAction(){
        return new AniwaysAction<SelectedGridItemInfo>() {
            @Override
            public void call(SelectedGridItemInfo selectedGridItemInfo) {
                IAniwaysAssetInfo assetInfo = (IAniwaysAssetInfo)selectedGridItemInfo.getGridItem().getTag(R.id.aniways_asset_info_tag);
                if(assetInfo == null){
                    Log.w(true,TAG,"Selected item with no asset info. Probably because the info has not yet been loaded to the model, so doing nothing");
                    return;
                }
                EventAggregator.getInstance().notify(new ContextualItemSelectedByUserEvent(
                        popupCreationContext,
                        selectedGridItemInfo,
                        assetInfo));
            }
        };
    }

    protected abstract void setGridDimentions();
    //TODO: We cannot always know how much content we have in advance just based on the phrase
    protected abstract int getMaxGridItemsNumber(Phrase phrase);
    protected abstract ImageView.ScaleType getImageScaleType();
    protected abstract AniwaysPharseContentModelBuilder getDataExctractor();
}
