package com.aniways.quick.action;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

import com.aniways.AniwaysEditText;
import com.aniways.AssetType;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.data.AniwaysPharseContentModelBuilder;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Phrase;
import com.aniways.volley.toolbox.NetworkImageView;
import com.aniways.volley.toolbox.Volley;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by moran on 1/14/2015.
 */
public class AniwaysContextualIconsGridView extends AniwaysContextualPopupGridView {
    public AniwaysContextualIconsGridView(Context context) {
        super(context);
    }

    public AniwaysContextualIconsGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AniwaysContextualIconsGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void setGridDimentions(){
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        setGridItemDimension(config.contextualGridRowHeight, config.contextualGridEmoticonItemMinMargin, config.iconInSuggestionPopupHeight);
    }

    @Override
    protected int getMaxGridItemsNumber(Phrase phrase) {
        return Math.min(phrase.icons.icons.length, AniwaysPrivateConfig.getInstance().maxNumberOfIconsInSuggestionPopup);
    }

    @Override
    protected ImageView.ScaleType getImageScaleType() {
        return ImageView.ScaleType.FIT_CENTER;
    }

    @Override
    protected AniwaysPharseContentModelBuilder getDataExctractor() {
        return AniwaysPharseContentModelBuilder.getInstance(AssetType.Emoticons);
    }
}
