package com.aniways.emoticons.button;

import java.util.ArrayList;
import java.util.List;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;

import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.volley.toolbox.IResponseListener;
import com.aniways.volley.toolbox.NetworkImageView;
import com.aniways.volley.toolbox.Volley;

import pl.droidsonroids.gif.GifDrawable;

public class EmoticonsPagerAdapterWithTable extends EmoticonsOnDemandPagerAdapterBase {

	private final class OnDemandResponseListener implements IResponseListener {
		private final InstantiatedViewHolder holder;
		private final IconData icon;
		private NetworkImageView image;
		private final ImageView lock;

		private OnDemandResponseListener(InstantiatedViewHolder holder,
				IconData icon, NetworkImageView image, ImageView lock) {
			this.holder = holder;
			this.icon = icon;
			this.image = image;
			this.lock = lock;
		}

		@Override
		public void onSuccess() {
			try{
				
			if(EmoticonsPagerAdapterWithTable.this.isVisible(holder.position)){
				image.startAnimation();
                startFadeInAnimation(image);
				holder.images.add(image);
				mLockedIconHelper.setIconAndLockVisibility(image, lock, icon);
			}else {
				if(AniwaysPrivateConfig.getInstance().isLowMemoryDevice()){
					if(image != null) {
                        image.recycle(true, true, false);
                        image.unregisterPreviousListeners();
                        image = null;
                    }
                    else{
                        Log.e(true, TAG, "image is null");
                    }
				}else{
					holder.images.add(image);
					mLockedIconHelper.setIconAndLockVisibility(image, lock, icon);
				}
			}
			}
			catch(Throwable t){
				Log.e(true, TAG, "Exception in OnDemandResponseListener onSuccess", t);
			}
		}

		@SuppressWarnings("deprecation")
		@SuppressLint("NewApi")
		private void startFadeInAnimation(final NetworkImageView image) {
			if(Utils.isAndroidVersionAtLeast(11)){
		      image.setAlpha(1.0f);
			}
			else{
			  image.setAlpha(255);
			}
			AlphaAnimation fadeInAnimation = new AlphaAnimation(0f, 1.0f);
			fadeInAnimation.setDuration(1200);
			fadeInAnimation.setStartOffset(0);
			fadeInAnimation.setInterpolator(new AccelerateInterpolator());					

			// Start Animations
			image.startAnimation(fadeInAnimation);
		}

		@Override
		public void onError() {Log.e(false, TAG, "OnDemandResponseListener onError called");}
	}

    public static final int MAX_ITEMS_PER_PAGE = 2 * 4;
    public static final int MAX_ITEMS_PER_PAGE_SMALL_ICONS = 3 * 6;
    public static final int MAX_ITEMS_PER_PAGE_SMALLER_ICONS = 5 * 8;

	private String TAG = "AniwaysEmoticonsPagerAdapterWithTable";
	// TODO: make configurable
	private int NO_OF_ROWS = 0;
	private int NO_OF_CELLS_IN_ROW = 0;
	private int NO_OF_EMOTICONS_PER_PAGE = NO_OF_ROWS * NO_OF_CELLS_IN_ROW;

	private List<IconData> mEmoticons;
	private AniwaysLockedIconHelper mLockedIconHelper;
	private String mFamilyName;
	private String mCategoryName;
	private boolean mIsRecentsTab;
	private int mNumberOfGeniousIcons;

	@SuppressLint("UseSparseArrays")
	public EmoticonsPagerAdapterWithTable(List<IconData> emoticons, AniwaysLockedIconHelper lockedIconHelper, int assetCode, String categoryName, int categoryPage, String familyName, int familyPage, boolean isRecentsTab, int numberOfGeniousIcons, EmoticonsOnDemandPagerAdapterBase parent) {
		super("AniwaysEmoticonsPagerAdapterWithTable" + "-" + assetCode + "-" + categoryPage + "-" + familyPage, AdapterType.Table, assetCode, categoryPage, familyPage, parent, familyPage);
        TAG += "-" + assetCode + "-" + categoryPage + "-" + familyPage;
		this.mEmoticons = emoticons;
		this.mLockedIconHelper = lockedIconHelper;
		this.mFamilyName = familyName;
		this.mCategoryName = categoryName;
		this.mIsRecentsTab = isRecentsTab;
		this.mNumberOfGeniousIcons = numberOfGeniousIcons;

        LayoutInflater inflater = (LayoutInflater) lockedIconHelper.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        int layout = R.layout.aniways_emoticons_button_popup_emoticons_table;
        if(assetCode == AssetType.Emoji.getAssetCode() && config.useDefaultEmojiLookInIconsOnDemendPopup){
            layout = R.layout.aniways_emoticons_button_popup_emoticons_table_smaller_icons;
        }
        else if(config.useSmallerIconsInIconsOnDemendPopup){
            layout = R.layout.aniways_emoticons_button_popup_emoticons_table_small_icons;
        }
        TableLayout table = (TableLayout) inflater.inflate(layout, null);

        NO_OF_ROWS = table.getChildCount();
        NO_OF_CELLS_IN_ROW = ((TableRow) table.getChildAt(0)).getChildCount();
        NO_OF_EMOTICONS_PER_PAGE = NO_OF_ROWS * NO_OF_CELLS_IN_ROW;
	}

    public static int getMaxItemsPerPage(int assetCode){
        int retMaxItems = MAX_ITEMS_PER_PAGE;

        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        if(assetCode == AssetType.Emoji.getAssetCode() && config.useDefaultEmojiLookInIconsOnDemendPopup) {
            retMaxItems = MAX_ITEMS_PER_PAGE_SMALL_ICONS;
        }
        else if(config.useSmallerIconsInIconsOnDemendPopup) {
            retMaxItems = MAX_ITEMS_PER_PAGE_SMALLER_ICONS;
        }

        return retMaxItems;
    }

	@Override
	public int getCount() {
		try{
			return mEmoticons == null ? 0 : (mAssetCode != AssetType.Emoji.getAssetCode()) ? 1 : (int) Math.ceil((double) mEmoticons.size() / (double) NO_OF_EMOTICONS_PER_PAGE);
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in getCount", ex);
			return 0;
		}
	}

	@Override
	protected View instantiateItem(View collection) {
		try{
			LayoutInflater inflater = (LayoutInflater) collection.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			
			AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
			int layout = R.layout.aniways_emoticons_button_popup_emoticons_table;
			if(mAssetCode == AssetType.Emoji.getAssetCode() && config.useDefaultEmojiLookInIconsOnDemendPopup){
				layout = R.layout.aniways_emoticons_button_popup_emoticons_table_smaller_icons;
			}
            else if(config.useSmallerIconsInIconsOnDemendPopup){
                layout = R.layout.aniways_emoticons_button_popup_emoticons_table_small_icons;
            }
			return inflater.inflate(layout, null);
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in instatiateItem", ex);
			return null;
		}
	}

	@Override
	protected void onHolderCreated(InstantiatedViewHolder holder){
		if(AniwaysPrivateConfig.getInstance().isLowMemoryDevice()){
			clearLockImagesFromAllCells(holder);
		}

		super.onHolderCreated(holder);
	}

	@Override
	protected void instantiateItemInternal(InstantiatedViewHolder holder) {
		if(holder.instantiated && !holder.iconsCleared){
			for(NetworkImageView iv : holder.images){
                if (iv.getDrawable() instanceof GifDrawable){
                    ((GifDrawable) iv.getDrawable()).start();
                }
            }
            return;
		}

		TableLayout table = (TableLayout) holder.view;

		int initialPosition = holder.position * NO_OF_EMOTICONS_PER_PAGE;
		ArrayList<IconData> emoticonsInAPage = new ArrayList<>();

		if(mEmoticons != null){
			for (int i = initialPosition; i < (initialPosition + NO_OF_EMOTICONS_PER_PAGE) && i < mEmoticons.size(); i++) {
				emoticonsInAPage.add(mEmoticons.get(i));
			}
		}

		// Add more empty emoticons, so the grid will think the page is full and not put
		// itself in the middle of the page and make it look weird
		for (int i = emoticonsInAPage.size(); i < NO_OF_EMOTICONS_PER_PAGE; i++){
			emoticonsInAPage.add(null);
		}

		holder.images = new ArrayList<>();

		for( int i = 0 ; i < NO_OF_ROWS; i++ ){
			TableRow row = (TableRow) table.getChildAt(i);
			for( int j = 0 ; j < NO_OF_CELLS_IN_ROW; j++ ){
				int position = (i * NO_OF_CELLS_IN_ROW) + j;
				setupCell(emoticonsInAPage.get(position), row.getChildAt(j), holder, position, emoticonsInAPage.get(0));
			}
		}

		holder.instantiated = true;
		holder.iconsCleared = false;
	}

	@Override
	protected void recycleBitmapsInPosition(InstantiatedViewHolder holder) {

		for(NetworkImageView imageView : holder.images){
			if(imageView == null){
				continue;
			}

            imageView.recycle(true,true, false);
            imageView.unregisterPreviousListeners();
            Log.v(TAG, "recycled image");
		}

		holder.images.clear();
		// This is needed as this page might be drawn in the animation
		clearLockImagesFromAllCells(holder);
	}

    @Override
	protected void regenerateItem(InstantiatedViewHolder holder) {
		if(holder == null){
			Log.e(true, TAG, "Trying to regenerate a null holder");
			return;
		}
		instantiateItemInternal(holder);
	}

	private void setupCell(final IconData icon, View cell, final InstantiatedViewHolder holder, final int position, IconData firstIconInTable){

		final ImageView lock = (ImageView) cell.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
		final NetworkImageView image = (NetworkImageView) cell.findViewById(R.id.aniways_ebp_emoticons_item_emoticon);

		final String path = icon == null ? null : icon.getFileName();
		if(path == null){
			lock.setVisibility(View.GONE);

			// Put the first image in the table (must exist, otherwise there will be no table)
			// in the cell. Set the view to be invisible, so it will take up space in the calculations, like the other pictures
			// (the size can change in config, so not good to take image from resources), but will not be seen
			final String pathOfFirstIconInTable = firstIconInTable == null ? null : firstIconInTable.getFileName();
			if(pathOfFirstIconInTable == null){
				Log.e(true, TAG, "First icon in table's path is null: " + (firstIconInTable == null ? null : firstIconInTable.id));
				image.setImageDrawable(null);
				holder.images.add(null);
				image.setVisibility(View.INVISIBLE);
				return;
			}
            image.unregisterPreviousListeners();
			image.registerResponseListener(new IResponseListener() {
				
				@Override
				public void onSuccess() {
					try{
						holder.images.add(image);
						image.setVisibility(View.INVISIBLE);
					} catch(Throwable t){
						Log.e(true, TAG, "Exception in IResponseListener onSuccess", t);
					}
				}
				
				@Override
				public void onError() {}
			});
			
			AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
			image.setImageUrl(config.getIconUrl(firstIconInTable, false, false), firstIconInTable, Volley.getImageLoader(), config.getMaxWidthForCache(firstIconInTable), config.getMaxHeightForCache(firstIconInTable), false);
			return;
		}

        image.unregisterPreviousListeners();
		image.registerResponseListener(new OnDemandResponseListener(holder, icon, image, lock));
		AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
		image.setImageUrl(config.getIconUrl(icon, false, false), icon, Volley.getImageLoader(), config.getMaxWidthForCache(icon), config.getMaxHeightForCache(icon), false);

		cell.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				try{
					int iconNumber = (NO_OF_EMOTICONS_PER_PAGE * holder.position) + position;
					boolean isGeniousIcon = mIsRecentsTab && iconNumber < mNumberOfGeniousIcons;

					int row = (position /  NO_OF_CELLS_IN_ROW) + 1;
					int column = (position %  NO_OF_CELLS_IN_ROW) + 1;

					mLockedIconHelper.onIconClicked(
							image,
							lock,
							icon,
							new EmoticonsButtonIconClickContext(icon, mIsRecentsTab, isGeniousIcon, mCategoryName, mCategoryPage, mFamilyName, mFamilyPage, holder.position, position + 1, NO_OF_EMOTICONS_PER_PAGE, row, column, NO_OF_ROWS, NO_OF_CELLS_IN_ROW));

					Log.i(TAG, "Clicked on table item in position: " + position);

				}
				catch(Throwable ex){
					Log.e(true, TAG, "Caught excedption in onItemClick. Pos is: " + position, ex);
				}
			}
		});
	}

	private void clearLockImagesFromAllCells(InstantiatedViewHolder holder) {
		if(holder.iconsCleared){
			return;
		}

        TableLayout table = (TableLayout) holder.view;

		for( int i = 0 ; i < NO_OF_ROWS; i++ ){
			TableRow row = (TableRow) table.getChildAt(i);
			for( int j = 0 ; j < NO_OF_CELLS_IN_ROW; j++ ){
				View cell = row.getChildAt(j);
				ImageView lock = (ImageView) cell.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
				lock.setVisibility(View.GONE);
			}
		}

		holder.iconsCleared = true;
	}
}