package com.aniways.emoticons.button;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map.Entry;

import com.aniways.AssetType;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.volley.toolbox.NetworkImageView;

import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.support.v4.view.PagerAdapter;
import android.view.View;

abstract class EmoticonsOnDemandPagerAdapterBase extends PagerAdapter {

	private HashMap<Integer, InstantiatedViewHolder> viewHolders;
	private String mName;
	protected int mAssetCode;
	protected int mCategoryPage;
	protected int mFamilyPage;
	private AdapterType mAdapterType;
	private int mPrimaryPosition = -1;
	private EmoticonsOnDemandPagerAdapterBase mParent;
	private int mPositionInParent;

	enum AdapterType{
		Asset,
		Category,
		Family,
		Table
	}

	EmoticonsOnDemandPagerAdapterBase(String name, AdapterType type, int assetCode, int categoryPage, int familyPage, EmoticonsOnDemandPagerAdapterBase parent, int positionInParent){
		mName = name;
		mAdapterType = type;
		mAssetCode = assetCode;
		mCategoryPage = categoryPage;
		mFamilyPage = familyPage;
		mParent = parent;
		mPositionInParent = positionInParent;
	}

	@Override
	public Object instantiateItem(View collection, int position) {
		try{
			Log.i(mName, "Instatiating item to be in position: " + position);
			View view = instantiateItem(collection);

			((AniwaysDirectionalViewPager) collection).addView(view);

			InstantiatedViewHolder holder = new InstantiatedViewHolder(position, view);
			onHolderCreated(holder);

			return holder;
		}
		catch(Throwable ex){
			Log.e(true, mName, "Caught Exception in instantiateItem", ex);
			return null;
		}
	}

	@Override
	public void setPrimaryItem(View container, int position, Object object) {
		try{
			Log.i(mName, "Setting primary item to be in position: " + position);

			this.mPrimaryPosition = position;

			// Ignore this if we are not inside an adapter which is the primary one itself
			if(mParent != null && !mParent.isChildVisible(mAssetCode, mFamilyPage, mCategoryPage)){
				Log.i(mName, "ignored..");
				return;
			}

			// Recycle the images in the other positions
			if(AniwaysPrivateConfig.getInstance().isLowMemoryDevice()){
				// It is safe to do it here cause in these conditions there is no cache
				recycleImagesInOtherPositions(position);
			}

			// Regenerate the primary item if already instantiated, and instantiate if not instantiated
			InstantiatedViewHolder holder = (InstantiatedViewHolder) object;
			if(holder == null){
				return;
			}
			if(!holder.instantiated){
				// Instantiate this item if it is not instantiated
				instantiateItemInternal(holder);
				finishInstantiateItemInternal(holder);
				holder.instantiated = true;
			}
			else{
				// It was already instantiated, so just need to regenerate
				regeneratePrimaryItem();
			}
		}
		catch(Throwable ex){
			Log.e(true, mName, "Caught Exception in setPrimaryItem", ex);
		}
	}

	@Override
	public void destroyItem(View collection, int position, Object object) {
		try{
			Log.i(mName, "destroying item number: " + position);

			// Remove the view from the view pager
			InstantiatedViewHolder holder = (InstantiatedViewHolder) object;
			if(holder == null){
				Log.e(true, mName, "destroying a null holder: " + object + " in position: " + position);
				return;
			}
			((AniwaysDirectionalViewPager)collection).removeView(holder.view);
			viewHolders.remove(position);

			if(AniwaysPrivateConfig.getInstance().isLowMemoryDevice()){
				// Recycle all bitmaps used in this view
				// (its OK to do this here, since the bitmaps are not cached in lower android versions or in low mem devices)

				if(holder.instantiated){
					recycleBitmapsInPosition(holder);
				}
			}
		}
		catch(Throwable ex){
			Log.e(true, mName, "Caught Exception in destroyItem", ex);
		}
	}

	@Override
	public boolean isViewFromObject(View view, Object object) {
		try{
			if(object == null){
				return false;
			}
			return view == ((InstantiatedViewHolder) object).view;
		}
		catch(Throwable ex){
			Log.e(true, mName, "Caught Exception in setPrimaryItem", ex);
			return false;
		}
	}

	void recycleAllBitmaps(){
		if(viewHolders == null){
			return;
		}

		for (Entry<Integer, InstantiatedViewHolder> entry : viewHolders.entrySet()){
			if(entry.getValue().instantiated){
				recycleBitmapsInPosition(entry.getValue());
			}
		}
	}

	/**
	 * The holder in this position needs to be instantiated!!
	 */
	protected void recycleBitmapsInPosition(InstantiatedViewHolder holder) {
		((EmoticonsOnDemandPagerAdapterBase) holder.pager.getAdapter()).recycleAllBitmaps();
	}

	protected void regenerateItem(InstantiatedViewHolder holder) {
		if(holder == null){
			Log.e(true, mName, "Trying to regenerate a null holder");
			return;
		}
		EmoticonsOnDemandPagerAdapterBase primaryChild = holder.adapter;
		if(primaryChild == null){
			Log.e(true, mName, "primary child is null");
		}

		primaryChild.regeneratePrimaryItem();
	}

	protected void onHolderCreated(InstantiatedViewHolder holder){ 
		if(!AniwaysPrivateConfig.getInstance().isLowMemoryDevice()){
			instantiateItemInternal(holder);
			finishInstantiateItemInternal(holder);
			holder.instantiated = true;
		}
	}

	protected abstract View instantiateItem(View collection);
	protected abstract void instantiateItemInternal(InstantiatedViewHolder holder);

	private void recycleImagesInOtherPositions(int position) {
		if(viewHolders == null){
			return;
		}

		for (Entry<Integer, InstantiatedViewHolder> entry : viewHolders.entrySet()){
			if(entry.getKey() != position && entry.getValue().instantiated){
				recycleBitmapsInPosition(entry.getValue());
			}
		}
	}

	private void regeneratePrimaryItem() {
		// There is no primary position set yet
		if(mPrimaryPosition < 0){
			return;
		}

		// Regenerate the holder in the primary position
		if(viewHolders == null){
			// this can happen when the 'recents' tab is not yet populated
			return;
		}
		regenerateItem(viewHolders.get(mPrimaryPosition));

	}

	@SuppressLint("UseSparseArrays")
	private void finishInstantiateItemInternal(InstantiatedViewHolder holder){
		if(viewHolders == null){
			viewHolders = new HashMap<>();
		}
		if(holder.pager != null){
			holder.adapter = (EmoticonsOnDemandPagerAdapterBase) holder.pager.getAdapter();
		}
		viewHolders.put(holder.position, holder);
	}

	private boolean isChildVisible(int assetCode, int familyNumber, int categoryNumber){

		switch(mAdapterType){
			case Asset: {
				return assetCode == mPrimaryPosition;
			}
		case Category: {
			if (categoryNumber == mPrimaryPosition){
				return mParent.isChildVisible(assetCode, familyNumber, categoryNumber);
			}
			return false;
		}
		case Family: {
			if(familyNumber == mPrimaryPosition){
				return mParent.isChildVisible(assetCode, familyNumber, categoryNumber);
			}
			return false;
		}
		default: {
            Log.e(true, mName, "Unknown adapter type: " + mAdapterType);
			return false;
		}
		}

	}

	class InstantiatedViewHolder{
		EmoticonsOnDemandPagerAdapterBase adapter;
		AniwaysDirectionalViewPager pager;
		View view;
		boolean instantiated = false;
		boolean iconsCleared;
		int position;
		ArrayList<NetworkImageView> images;

		public InstantiatedViewHolder(int pos, View v) {
			this.position = pos;
			this.view = v;
		}
	}
	
	public boolean isVisible(int position){
		
		if(mPrimaryPosition != position){
			return false;
		}
		if(mParent == null){
			return true;
		}
		return mParent.isVisible(mPositionInParent);
	}

}
