package com.aniways.emoticons.button;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker.LastPagesLocation;
import com.aniways.viewpagerindicator.CirclePageIndicator;
import android.content.Context;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.support.v4.view.AniwaysDirectionalViewPager.OnPageChangeListener;
import android.view.LayoutInflater;
import android.view.View;


public class EmoticonFamiliesPagerAdapter extends EmoticonsOnDemandPagerAdapterBase {
	private String TAG = "AniwaysEmoticonFamiliesPagerAdapter";

	private HashMap<String, List<IconData>> mFamiliesToIcons;
	private String[] mIconFamilies;
	private AniwaysLockedIconHelper mLockedIconHelper;
	private String mCategoryName;
	private LastPagesLocation mLastPagesLocation;
	private boolean mIsRecentsTab;
	private int mNumberOfGeniousIcons;

	public EmoticonFamiliesPagerAdapter(HashMap<String, List<IconData>> familiesToIcons, int assetCode, String categoryName, int categoryPage, AniwaysLockedIconHelper lockedIconHelper, boolean isRecentsTab, int numberOfGeniousIcons, LastPagesLocation lastPagesLocation, EmoticonsOnDemandPagerAdapterBase parent) {
		super("AniwaysEmoticonFamiliesPagerAdapter" + "-" + assetCode + "-" + categoryPage, AdapterType.Family, assetCode, categoryPage, 0, parent, categoryPage);
		try{
            TAG += "-" + assetCode + "-" + categoryPage;
			this.mCategoryName = categoryName;
			this.mIsRecentsTab = isRecentsTab;
			this.mNumberOfGeniousIcons = numberOfGeniousIcons;
			this.mLockedIconHelper = lockedIconHelper;
			this.mLastPagesLocation = lastPagesLocation;

			this.mFamiliesToIcons = familiesToIcons;
			if (familiesToIcons.keySet().isEmpty() && !categoryName.equalsIgnoreCase(EmoticonCategoriesPagerAdapter.RECENT)){
				Log.e(true, TAG, "No Icon families in category: " + categoryName);
				this.mIconFamilies = null;
			}
			else{
				// This is already ordered
				this.mIconFamilies = new String[familiesToIcons.keySet().size()];
				familiesToIcons.keySet().toArray(this.mIconFamilies);
			}
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in constructor", ex);
		}

	}

	@Override
	public CharSequence getPageTitle(int position) {
		try{
			if(mIconFamilies == null){
				return "EMPTY";
			}

			// TODO: why need the modulu?
			return mIconFamilies[position % mIconFamilies.length].toUpperCase(Locale.getDefault());
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in getPageTitle", ex);
			return "EMPTY";
		}
	}

	@Override
	public int getCount() {
		return (mIconFamilies == null ? 0 : mIconFamilies.length);
	}

	@Override
	protected View instantiateItem(View collection) {
		try{
	
			LayoutInflater inflater = (LayoutInflater) collection.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			return inflater.inflate(R.layout.aniways_emoticons_button_popup_icons_pager, null);
		}
		catch(Throwable ex){
			Log.e(true, TAG, "Caught Exception in instantiateItem", ex);
			return null;
		}
	}

	@Override
	protected void instantiateItemInternal(InstantiatedViewHolder holder) {
		View layout = holder.view;
		
		final String iconFamily = (mIconFamilies == null ? "EMPTY" : mIconFamilies[holder.position]);
		List<IconData> emoticons = null;
		if(mIconFamilies != null){
			emoticons = this.mFamiliesToIcons.get(iconFamily);
		}
		
		AniwaysDirectionalViewPager pager = (AniwaysDirectionalViewPager) layout.findViewById(R.id.aniways_ebp_icons_pager);
		pager.setOffscreenPageLimit(1); //TODO: 1 is the minimum. 1. Make this value configurable. See if can somehow change this minimum
		holder.pager = pager;
		
		EmoticonsPagerAdapterWithTable adapter = new EmoticonsPagerAdapterWithTable(emoticons, mLockedIconHelper, mAssetCode, mCategoryName, mCategoryPage, iconFamily, holder.position, mIsRecentsTab, mNumberOfGeniousIcons, this);
		pager.setAdapter(adapter);

		CirclePageIndicator indicator = (CirclePageIndicator)layout.findViewById(R.id.aniways_ebp_icons_pager_indicator);
		indicator.setViewPager(pager);

		// Hide the tables indicator when there's only one table.
		if (adapter.getCount() == 1){
			indicator.setVisibility(View.GONE);
		}

		OnPageChangeListener pageChangeListener = new OnPageChangeListener(){

			@Override
			public void onPageScrollStateChanged(int arg0) {
				// TODO Auto-generated method stub
			}

			@Override
			public void onPageScrolled(int arg0, float arg1, int arg2) {
				// TODO Auto-generated method stub
			}

			@Override
			public void onPageSelected(int pageNumber) {
				try{
                    Log.i(TAG, "Selected table num: " + pageNumber);
					mLastPagesLocation.setTableNumber(pageNumber);
				}
				catch(Throwable ex){
					Log.e(true, TAG, "Caught Exception in onPageSelected", ex);
				}
			}

		};
		
		indicator.setOnPageChangeListener(pageChangeListener);
		
		if(mLastPagesLocation.getSelectedAssetType().getAssetCode() == mAssetCode && mLastPagesLocation.getCategoryPage() == mCategoryPage && mLastPagesLocation.getFamilyPage() == holder.position){
			indicator.setCurrentItem(mLastPagesLocation.getTableNumber());
		}
		
		holder.instantiated = true;
		
	}
}