/**
 * 
 */
package com.aniways.data;

import java.util.Locale;

import com.aniways.IconData;
import com.aniways.Log;


/**
 * @author Shai
 * Represents a Phrase in which the part to replace is not the same as the phrase itself
 */
public class PhraseWithPartToReplace extends Phrase{
	private static final String TAG = "AniwaysPhraseWithPartToReplace";
	private static final long serialVersionUID = 1L;
	
	private int startOfPartToReplace;
	private int lengthOfPartToReplace;
	
	public PhraseWithPartToReplace(Chars chars, int start, int length, int startOfPartToReplace, int lengthOfPartToReplace, IconData[] icons){
		super(chars, start, length, icons);
		if(startOfPartToReplace < 0 || lengthOfPartToReplace < 1 || startOfPartToReplace + lengthOfPartToReplace > length){
			Log.e(true, TAG, "Illegal params for part to replace. start: " + start + ". length: " + length + ". startOfPartToReplace: " + startOfPartToReplace + ". lengthOfPartToReplace: " + lengthOfPartToReplace);
		}
		this.startOfPartToReplace = startOfPartToReplace;
		this.lengthOfPartToReplace = lengthOfPartToReplace;
	}
	
	public PhraseWithPartToReplace(String name, String partToReplace, IconData icon){
		super(name, icon);
		startOfPartToReplace = name.toLowerCase(Locale.US).indexOf(partToReplace.toLowerCase(Locale.US));
		lengthOfPartToReplace = partToReplace.length();
		if(startOfPartToReplace < 0 || lengthOfPartToReplace < 1 || startOfPartToReplace + lengthOfPartToReplace > length){
			Log.e(true, TAG, "Illegal params for part to replace from strings. name: " + name + ". partToReplace:  " +  partToReplace + ". start: " + start + ". length: " + length + ". startOfPartToReplace: " + startOfPartToReplace + ". lengthOfPartToReplace: " + lengthOfPartToReplace);
		}
	}

	@Override
	public String getPartToReplace() {
		return getName().substring(startOfPartToReplace, startOfPartToReplace + lengthOfPartToReplace);
	}
	
	@Override
	public int getIndexOfPartToReplaceInPhrase(){
		return startOfPartToReplace;
	}
	
	@Override
	public int getLengthOfPartToReplace() {
		return lengthOfPartToReplace;
	}
	
	@Override
	public int getEndOfPartToReplace() {
		return startOfPartToReplace + lengthOfPartToReplace;
	}

	// Checks whether the part to replace is equal to the name.
	public boolean isFullReplacement() {
		return false;
	}
}
