/**
 * 
 */
package com.aniways.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;

import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.Log;


/**
 * @author Shai
 * Represents a Phrase in which the part to replace is the same as the phrase itself
 */
public class Phrase implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    private static final String TAG = "AniwaysPhrase";

    int start;
	int length;
	
	private Chars chars;
	private int hash;
	public EmoticonsDataForPhrase icons;
    public AnimatedGifsDataForPhrase animatedGifs;
	
	public Phrase(Chars chars, int start, int length, IconData[] icons){
		this.chars = chars;
		this.start = start;
		this.length = length;
		this.icons = new EmoticonsDataForPhrase(icons);
	}
	
	public Phrase(String name, IconData icon){
		this.chars = new Chars(name.toLowerCase(Locale.US));
		this.start = 0;
		this.length = name.length();
		this.icons = new EmoticonsDataForPhrase(new IconData[] { icon });
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return new String(chars.chars, start, length);
	}

	/**
	 * @return the partToReplace
	 */
	public String getPartToReplace() {
		return getName();
	}
	
	public int getIndexOfPartToReplaceInPhrase(){
		return 0;
	}
	
	@Override
	public boolean equals(Object o){
		if(!(o instanceof Phrase)){
			return false;
		}
		
		// TODO: see if there is a better cast here for performance
		return equals((Phrase) o);
	}
	
	public boolean equals(Phrase o){
		return this.chars == o.chars && this.start == o.start && this.length == o.length;
	}
	
	public boolean equals(CharSequence o){
		if(length != o.length()){
			return false;
		}
		if(this.hashCode() != o.hashCode()){
			return false;
		}
		int end = start + length;
		for (int i = start; i < end; i++){
			if (chars.chars[i] != o.charAt(i - start)){
				return false;
			}
		}
		return true;
		
	}
	
	@Override
	public int hashCode(){
		if(this.hash == 0){
			this.hash = this.getName().hashCode();
		}
		return this.hash;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Phrase [Name()=" + getName() + ", PartToReplace()=" + getPartToReplace() + "]";
	}
	
	public String getPhraseSubphraseString(){
		return getPhraseSubphraseString(this.getName(), this.getPartToReplace());
	}
	
	public static String getPhraseSubphraseString(String phraseName, String partToReplace){
		String result = String.format("%s - %s", 
				phraseName,
				phraseName.equalsIgnoreCase(partToReplace) ? "(null)" : partToReplace);
		return result;
	}

	// Checks whether the part to replace is equal to the name.
	public boolean isFullReplacement() {
		return true;
	}

	public int getLengthOfPartToReplace() {
		return length;
	}
	
	public int getEndOfPartToReplace() {
		return length;
	}

    public int getLength(){
        return length;
    }

    public int getMarginBetweenEndOfPartToRplaceToPhraseEnd(){
        return getLength() - getEndOfPartToReplace();
    }

    public DataForAssetTypeInPhrase getDataForAssetType(AssetType assetType){
        if(assetType == AssetType.Emoticons){
            return this.icons;
        }
        else if(assetType == AssetType.AnimatedGif){
            return this.animatedGifs;
        }
        Log.e(true, TAG, "Requested to get PhraseData for nonexisting asset type: " + assetType);
        return null;
    }


}
