package com.aniways.data;

import com.aniways.IconData;
import com.aniways.service.utils.AniwaysAction;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Shai on 22/01/2015.
 */
public class EmoticonsDataForPhrase extends DataForAssetTypeInPhrase {
    public IconData[] icons;

    public EmoticonsDataForPhrase(IconData[] icons){
        this.icons = icons;
    }

    @Override
    public Phrase getReferencePhrase(JsonParser parser, Phrase phrase) {
        return phrase;
    }

    @Override
    public boolean isEmpty() {
        return icons == null || icons.length == 0;
    }

    @Override
    public int buildAssetInfos(AniwaysAction<List<IAniwaysAssetInfo>> callback, Phrase phrase) {
        // If there are no content providers, return null
        if(this.isEmpty()){
            callback.call(null);
            return -1;
        }

        final int requestId = getNewRequestId();
        List<IAniwaysAssetInfo> infos = new ArrayList<IAniwaysAssetInfo>();
        for(IconData icon : this.icons){
            infos.add(new AniwaysEmoticonAssetInfo(icon));
        }
        callback.call(infos);
        return requestId;
    }

}
