package com.aniways.data;

import java.util.Arrays;
import java.util.Iterator;

public abstract class CustomHashSet<T> implements Iterable<T> {
    private static final float LOAD_FACTOR = 1.5f;// TODO: put load factor in config
    
    protected T NULL = null;
    protected T[] keys;
    protected int size;
    private int capacity;

    public CustomHashSet(int numberOfItems) {
    	
    	capacity = (int) (numberOfItems * LOAD_FACTOR);
    	
    	if(capacity < 1){
        	capacity = 1;
        }
    	
    	generateKeys(capacity);
    	
        Arrays.fill(keys, NULL);
    }
    
    protected abstract void generateKeys(int capacity);

    public T put(T key) {
        if (key == NULL) throw new IllegalArgumentException("key cannot be " + NULL);
        if (size == keys.length) throw new IllegalStateException("map is full");

        int index = indexFor(key);
        while (keys[index] != NULL) {
            index = successor(index);
        }
        keys[index] = key;
        ++size;
        return key;
    }

	public T get(T key) {
        if (key == NULL) throw new IllegalArgumentException("key cannot be " + NULL);

        int index = indexFor(key);

        T candidate = keys[index]; 
        while (candidate != NULL) {
            if (candidate.hashCode() == key.hashCode() && candidate.equals(key)) {
                return candidate;
            }
            index = successor(index);
            candidate = keys[index];
        }

        return NULL;
    }

    private int indexFor(T key) {
        return Math.abs((key.hashCode() % keys.length));
    }

    protected int successor(int index) {
        index++;
        return index >= keys.length ? index - keys.length : index;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> it = new Iterator<T>() {

            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return currentIndex < capacity;
            }

            @Override
            public T next() {
            	while(keys[currentIndex] == null){
            		currentIndex++;
            	}
                return keys[currentIndex++];
            }

            @Override
            public void remove() {
                // TODO Auto-generated method stub
            }
        };
        return it;
    }
}