/**
 * 
 */
package com.aniways.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.AnalyticsReporter.StoreEventAction;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.billing.AniwaysCreditsStoreActivity;
import com.aniways.data.AniwaysConfiguration.Verbosity;
import com.aniways.service.utils.AniwaysServiceUtils;

/**
 * @author Shai
 *
 */
public class AniwaysStoreManager {
	private static final String TAG = "AniwaysStoreManager";
	private static final String KEY_STORE_CREDITS = "com.aniways.KEY_STORE_CREDITS";
	private static final String KEY_UNLOCKED_ICONS = "com.aniways.UNLOCKED_ICONS";
	private static final HashSet<String> EMPTY_UNLOCKED_ICONS = new  HashSet<String>();
	private static final String IDS_DIVIDER = ";;";
	private static HashSet<String> sUnlockedIds;
	private static Context sContext = null;
	private static HashMap<String,String> sOldPathsToIds = null;

	static void forceInit(Context applicationContext) {
		if(sContext != null){
			Log.e(true, TAG, "Calling init of AniwaysStoreManager more than once");
		}

		sContext = applicationContext;

		sOldPathsToIds = new HashMap<String,String>();
		sOldPathsToIds.put("usa_eagle.png", "494");
		sOldPathsToIds.put("bye_flag.png", "145");
		sOldPathsToIds.put("time_pocketwatch.png", "612");
		sOldPathsToIds.put("shy_rambo_turtle.png",  "391");
		sOldPathsToIds.put("sad_rambo_turtle.png", "365");
		sOldPathsToIds.put("in_love_rambo_turtle.png", "183");
		sOldPathsToIds.put("burned_peacok.png", "74");
		sOldPathsToIds.put("cool_peacok.png", "164");
		sOldPathsToIds.put("depressed_peacok.png", "148");
		sOldPathsToIds.put("in_love_peacok.png", "357");
		sOldPathsToIds.put("socks_chirstmas.png", "622");
		sOldPathsToIds.put("bells.png", "33");
		sOldPathsToIds.put("lollipop_chirstmas.png", "300");
		sOldPathsToIds.put("rose.png", "563");
		sOldPathsToIds.put("penguin.png", "377");
		sOldPathsToIds.put("panda.png", "328");
		sOldPathsToIds.put("beer_bottle.png", "184");
		sOldPathsToIds.put("guitar_electric.png", "204");
		sOldPathsToIds.put("guitar_classic.png", "180");


		populateUnlockedIds();
	}

	public static boolean isStoreEnabled(){
		return AniwaysPrivateConfig.getInstance().creditsStoreEnabled;
	}

	/**
	 * The icon is locked if the store is enabled, it is defined as locked in the mapping file, and it was not unlocked by the store before.
	 * @param icon
	 * @param parser
	 * @return
	 */
	public static boolean isIconLocked(IconData icon){
		//TODO: this is awkward - a combination of OO and not - cant use the icon.isLocked cause it just sees if its locked in the json
		// The icon is locked if the store is enabled, it is defined as locked in the mapping file, and it was not unlocked by the store before.
		if(icon == null){
			return false;
		}
		return isStoreEnabled() && icon.isLocked && !isIconUnlocked(icon);
	}

	public static void addUserCreditsAvailable(int amount){
		int currentAmount = getUserCreditsLeft();
		int newAmount = currentAmount + amount;

		Log.i(TAG, "Adding more credits. Current amount: " + currentAmount + ". Addition: " + amount + ". New total: " + newAmount);

		writeNewValueToUserCredits(newAmount);
	}

	/**
	 * @param newAmount
	 */
	private static void writeNewValueToUserCredits(int newAmount) {
		// open the shared preferences
		SharedPreferences prefs = sContext.getSharedPreferences(AniwaysServiceUtils.SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
		Editor edit = prefs.edit();
		// write the new value
		edit.putInt(KEY_STORE_CREDITS, newAmount);
		edit.commit();
	}

	public static boolean canUserBuyIcon(IconData icon){
		// TODO: add support for different pricing for different icons
		if(getUserCreditsLeft() >= AniwaysPrivateConfig.getInstance().getIconPriceInCredits(icon)){
			return true;
		}
		else{
			return false;
		}
	}

	@SuppressLint("NewApi")
	public static void unlockIconAndDecreaseCredits(String sourceScreen, IconData icon){
		String id = Integer.toString(icon.id);
		boolean added = sUnlockedIds.add(id);
		int iconPrice = AniwaysPrivateConfig.getInstance().getIconPriceInCredits(icon);

		if(!added){
			Log.e(true, TAG, "Unlocking icon id which is already unlocked:" + id);
		}
		else{
			Log.i(TAG, "Unlocked icon id: " + id);
			// Add phrase data to the event
			GoogleAnalyticsReporter.reportEvent(Verbosity.Info, AniwaysCreditsStoreActivity.CREDITS_PURCHASE_CATEGORY, "Unlocked Icon", id, 0);
			AnalyticsReporter.reportStoreEvent(
					StoreEventAction.unlockIcon, 
					null, 
					getUserCreditsLeft(), 
					getUserCreditsLeft() - iconPrice, 
					iconPrice, 
					false, id, sourceScreen, null, null,null);
		}

		// open the shared preferences
		SharedPreferences prefs = sContext.getSharedPreferences(AniwaysServiceUtils.SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
		Editor edit = prefs.edit();
		// write the new value
		if(Utils.isAndroidVersionAtLeast(11)){
			edit.putStringSet(KEY_UNLOCKED_ICONS, sUnlockedIds);
		}
		else{
			String unlockedIdsString = convertSetToIdsString(sUnlockedIds);
			edit.putString(KEY_UNLOCKED_ICONS, unlockedIdsString);
		}
		edit.commit();

		// Decrease credits
		decreaseUserCreditsAvailable(iconPrice);
	}

	private static void decreaseUserCreditsAvailable(int amount){
		int currentAmount = getUserCreditsLeft();
		int newAmount = currentAmount - amount;

		Log.i(TAG, "Decreasing credits. Current amount: " + currentAmount + ". Decrease: " + amount);

		writeNewValueToUserCredits(newAmount);
	}

	/**
	 * Was the icon unlocked by the store.
	 * Note: An icon that is not locked in the mapping file, and therefore is not locked, but was not unlocked by the store would return false!
	 * @param path
	 * @return
	 */
	public static boolean isIconUnlocked(IconData icon) {
		return sUnlockedIds.contains(Integer.toString(icon.id));
	}

	public static int getUserCreditsLeft(){
		// open the shared preferences
		SharedPreferences prefs = sContext.getSharedPreferences(AniwaysServiceUtils.SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());

		if(!prefs.contains(KEY_STORE_CREDITS)){
			Log.i(TAG, "Shared perfs do not contain a value for remaining credits, setting it to the configured initial value of: " + AniwaysPrivateConfig.getInstance().creditsStoreInitialCredits);
			writeNewValueToUserCredits(AniwaysPrivateConfig.getInstance().creditsStoreInitialCredits);
		}

		// return the values that stored there, in case that no value get the configured initial credits
		int result = prefs.getInt(KEY_STORE_CREDITS, AniwaysPrivateConfig.getInstance().creditsStoreInitialCredits);

		return result;
	}

	@SuppressLint("NewApi")
	private static void populateUnlockedIds() {
		// open the shared preferences
		SharedPreferences prefs = sContext.getSharedPreferences(AniwaysServiceUtils.SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());

		if(!prefs.contains(KEY_UNLOCKED_ICONS)){
			Log.i(TAG, "Shared perfs do not contain a value for unlocked icons, so no locked icon will be unlocked");
		}

		Set<String> result = null;
		if(Utils.isAndroidVersionAtLeast(11)){
			try{
				result = prefs.getStringSet(KEY_UNLOCKED_ICONS, EMPTY_UNLOCKED_ICONS);
			}
			catch(ClassCastException ex){
				// If we are here then the user has upgraded from an Android version < 11 and so there is already a value here which is not a set.
				// So convert it to a set
				Log.i(TAG, "Unlocked icons key doesn't contain a set, so user probably upgraded android version. Converting to a set");
				String resultString = prefs.getString(KEY_UNLOCKED_ICONS, "");
				result = convertIdsStringToSet(resultString);
				// Putting the set in the shared perfs
				Editor edit = prefs.edit();
				edit.putStringSet(KEY_UNLOCKED_ICONS, result);
				edit.commit();
			}
		}
		else{
			String resultString = prefs.getString(KEY_UNLOCKED_ICONS, "");
			result = convertIdsStringToSet(resultString);
		}

		sUnlockedIds = new HashSet<String>();

		// backwards compatibility with Zumbl - convert old names to new ids and add
		// TODO: remove this conversion and put back this line: sUnlockedIds.addAll(result);
		for (String path : result){
			String newName = sOldPathsToIds.get(path);
			if(newName == null){
				sUnlockedIds.add(path);
			}
			else{
				sUnlockedIds.add(newName);
			}
		}
	}

	private static Set<String> convertIdsStringToSet(String idsString) {
		String[] ids = idsString.split(IDS_DIVIDER);
		HashSet<String> result = new HashSet<String>();
		if(ids != null && ids.length > 0){
			result.addAll(Arrays.asList(ids));
		}
		else{
			Log.w(false, TAG, "No ids to extract from ids string:" + idsString);
		}
		return result;
	}

	private static String convertSetToIdsString(HashSet<String> ids) {
		StringBuilder sb = new StringBuilder("");
		if(ids != null && !ids.isEmpty()){
			for(String id : ids){
				sb.append(id);
				sb.append(IDS_DIVIDER);
			}
		}
		else{
			Log.w(false, TAG, "No ids to convert to string:" + ids);
		}
		return sb.toString();
	}
}
