/**
 *
 */
package com.aniways.data;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.app.AlarmManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import android.view.WindowManager;

import com.aniways.Aniways;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.VersionComparisonResult;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration.Verbosity;
import com.aniways.service.utils.AniwaysServiceUtils;
import com.aniways.ui.AniwaysUiUtil;

/**
 * @author Shai
 * The class gets config fisrt from its defaults, then from the app generated config and then from the server (for A-B testing)
 * Because of the way that the jSon from the server is serialized into an instance of this class (without calling the setters) then
 * we need to go over all getters in reflection and call the relevant setters. This is true only for setters that do not take more
 * than one arg (which need to be manually called later) and for setters that perform other actions, such as initializing components
 * because of a change in config. These setters need to be called in the setNewInstance() method, after setting the new instance,
 * because the code that they trigger might read other config values.
 */
public class AniwaysPrivateConfig {
    public int animatedGifsRequestSize = 10;
    public String animatedGifsRating = "g"; //Valid values for Giphy are: (y,g, pg, pg-13 or r). (there is some content even more mature than 'r', we get it if this param is absent
    public long phoneRegTimeout = 30000;
    public boolean printAnalyticsToLogs = false;
    public boolean addDefaultPhraseToAnimatedGif = true;
    public boolean performLiveBlur = false;
    public String animatedGifsSearchTermPrefix = "search:";
    public String giphyLowQualityImageObjectName = "fixed_height_downsampled";
    // TODO: This is actually medium quality - "fixed_height" is high quality
    public String giphyHighQualityImageObjectName = "fixed_height_small";
    //TODO: This is actually low quality - "fixed_height_still" is high quality
    public String giphyHighQualityStillImageObjectName = "fixed_height_small_still";
    // In MB
    private int minDiskCacheSize = 5;
    //TODO: There are also original and original_still
    //TODO: when adding reference to these new sizes then need to also change code in GiphyIconData to know to resolve the correct url for displaying an image in the EditText


    public enum IconEncodingMethod {
		Invisible,
		ViralLink;
	}

	public enum IconLocation {
		EditText,
		TextView,
		SuggestionPopup;
	}

	public enum SuggestionMode {
		Manual,
		AutoDisplaySuggestions,
		AutoReplacePhrases;
	}

	public enum AnalyticsCloud{
		Amazon,
		Aniways,
		Azure;
	}

	// Constants
	public static final String SUGGESTION_POPUP_NAME = "Suggestion popup";
	public static final String TEXT_VIEW_OR_EDIT_TEXT_NAME = "Text view or edit text";

	private static final String DEFAULT_APP_ID = "Placeholder";
	private static final String DEFAULT_GOOGLE_ANALYTICS_ID = "UA-46026454-3";
	private static final String DEFAULT_PUBLIC_KEY = "!!MUST REPLACE THIS with your app's public key";

	private static final String TAG = "AniwaysPrivateConfig";
	private static final String KEY_PARSED_CONFIG_VERSION = "com.aniways.PARSED_CONFIG_VERSION";

	//
	// Different configs
	//

	// Encode-decode
	public IconEncodingMethod iconEncodingMethod = IconEncodingMethod.Invisible;
	public boolean useOnlyConfiguredEncodingMethodForDecoding = false;
	public boolean encodeEmojisWithEmojiUnicode = false;
	public boolean encodeIconsWithEmojiReplacementWithEmojiUnicode = false;
	// Invisible
	// The first 3 are the ones that can be changed in config,
	// the others are calculated by 'calculateEncodingParams()'
	public int decoderChunkSize = 6;
	private String delimiter = "200C";
	private String decoderCodepointsString = "200C-200D-feff";
	public String delimiterString;
	public int decoderRadix;
	public String[] decoderCodepointStrings;
	// URL
	public  String upgradeMessage = "\n\nTo view emoticons in this message, please upgrade to the latest version: ";
	public static final String ICON_ID = "id";
	public static final String PHRASE_NAME = "pn";
	public static final String START_INDEX = "si";
	public static final String LENGTH = "l";
	public static final String MESSAGE_LENGTH = "ml";
	public static final String VERSION = "v";
	// Viral Link
	public  String viralMessage = "\n\nTo view icons in this message, please install Telegram with Aniways: ";
	public  String viralUrl = "http://www.aniways.com/anygram/dl2 ";
	public  int viralLinkImageId = 31;
    public int animatedGifImageId = 14;

	// Icon sizes config values
	// All measurements in dips
	// On wall
	public int iconInTextViewSize = 30;
	// In text editor
	public int iconInEditTextSize = 30;
	// In popup
	public int iconInSuggestionPopupSize = 60;

	// Icons on demand button
	public int maxIconsInRecentsTab = 32;
	public boolean useSmallerIconsInIconsOnDemendPopup = false;

	// Tutorials
	public boolean useEditTextTutorial = true;
	public boolean useTextViewTutorial = false;
	// Maximum amount of times to show tutorial
	public int maxTimesToShowTutorial = 3;
	// How many words need to be highlighted without the user choosing them b4 tutorial is showed again (as long as its not shown more than sTimesShowTutorial)
	public int numberOfWordsRequiredToShowTutorialAgain = 7;

	// Word highlight color
	public int wordHighlightColor = Color.GREEN;

	// Credits Store
	public float lockedIconAlpha = 0.4f;
	public int defalutLockedIconPrice = 10;
	public boolean creditsStoreEnabled = true;
	public int creditsStoreInitialCredits = 100;
	public String creditsSku100 = "aniways_100_credits";
	public String creditsSku250 = "aniways_250_credits";
	public String creditsSku500 = "aniways_500_credits";
	public String creditsSku1000 = "aniways_1000_credits";
	public String creditsSku2000 = "aniways_2000_credits";
	public String creditsSku3000 = "aniways_3000_credits";
	public String appPublicKeyForCreditsStore = DEFAULT_PUBLIC_KEY;

	// Icon caching
	public boolean tryUsingExternalStorageForIconCaching = false;

	// App id
	public  String appId = DEFAULT_APP_ID;

	// Analytics reporter
	// in milliseconds
	public boolean doNotSendMessagesInAnalytics = false;
	public boolean doNotSendMessageIdInAnalytics = false;
	public int statisticalEventsInterval = 30 * 1000;
	// Google Analytics
	public String googleAnalyticsId = DEFAULT_GOOGLE_ANALYTICS_ID;
	public Verbosity googleAnalyticsEventsVerbosity = Verbosity.Info;
	public Verbosity gaTimingEventsVerbosity = Verbosity.Statistical;
	public Verbosity gaScreenEventsVerbosity = Verbosity.Info;
	public boolean sendErrorsToGoogleAnalytics = true;
	public boolean gaDebug = false;
	// In seconds
	public int gaDispatchPeriod = 10;
	// Aniways Analytics
	public Verbosity analyticsEventsVerbosity = Verbosity.Info;
	public Verbosity timingEventsVerbosity = Verbosity.Off;
	public Verbosity screenEventsVerbosity = Verbosity.Info;
	public boolean sendErrorsToAniwaysServer = false;
	// ErrorHandler
	public Verbosity errorHandlingVerbosity = Verbosity.Warning;

	// Analytics service
	// Flush when number of events reaches this number
	public int analyticsMaxEventsBeforeFlush = 200;
	// The maximal flush size
	public int analyticsMaxFlushSize = 1000;
	// Flush every X milliseconds
	public int analyticsFlushInterval = (int) TimeUnit.SECONDS.toMillis(15*60);
	// Flush no more than every X milliseconds, if on restricted data usage
	public long analyticsFlushIntervalRestricted = 1000 * 60 * 60 * 24; //24 hours
	// max number of events to queue in the DB
	public int analyticsMaxEventsInDb = 10000;
	public int emptyAnalyticsFlushIntervalsBeforeKillingService = 0;
	// 20 minutes in milliseconds
	public long flushTimeout = 20 * 60 * 1000;
	// Common to all analytics clouds
	public int numberOfAnalyticsPartitions = 10;
	public int analyticsPartitionsStringLength = 5;
	public boolean compressAnalytics = true;
	public AnalyticsCloud analyticsCloud = AnalyticsCloud.Azure;
	// Azure
	public String azureAnalyticsEndpint = "https://aniways.blob.core.windows.net/aniways-analytics";
	public String azureAnalyticsStorageAccountName = "aniways";
	public String azureAnalyticsKey = "c17/s+EvRMmBSrgpvwTkmOAeYji25YrgAGI9+npsEKvxy3fmG1Sj5gUkHm/tFkzSr/hi8TbT1pBSdyH4eavMwA==";
	// Error Handling
	public String errorHandlingAPIKey = "b0012251b703bc5985b47b8f796d8062";
	public String errorHandlingEndpoint = "https://notify.bugsnag.com";
	// Amazon S3
	public String s3StorageClass = "REDUCED_REDUNDANCY";
	public String analyticsS3Address = "https://s3-eu-west-1.amazonaws.com/aniways-analytics";
	public String s3Acl = "bucket-owner-full-control";
	// Aniways
	public String baseAnalyticsUrl = "http://api.aniways.com/v2/events/android";

	// This flag is used in the Edit text to force it not to take the entire screen when in horizontal mode
	public boolean isImeFlagNoExtractUiForced = true;

	// When to open the suggestion popup (when user clicks on word, automatically, or automatically replace the word without opening the popup)
	public SuggestionMode suggestionMode = SuggestionMode.AutoDisplaySuggestions;
    public String leaveAutoPopupOpenCharacters = "?!.,";

    // Holds the number of taps that the user needs to tap on a marker in order for us to consider them educated enough, so no tutorial is needed.
    public static int smartUseMarkerTapCount = 3;

	//Time in milliseconds before closing the popup
	public long popupDismissDelay = 3000;

	// Maximum number of icons in the suggestion popup
	public int maxNumberOfIconsInSuggestionPopup = 10;

	// Performance
	public int maxWordsInPhrase = 3;

	// Backend Sync
	public long shortIntervalBetweenBackendSyncMillis = 1000 * 10;
	public long longIntervalBetweenBackendSyncMillis = shortIntervalBetweenBackendSyncMillis * 60;
	// Interval for asking for sync from the server in milliseconds
	public long backendSyncRequestInterval = 1000 * 60 * 5;

	// Logs
	public Verbosity logsVerbosity = Verbosity.Verbose;
	private static Verbosity sLogsVerbosity = Verbosity.Verbose;

	// auto-replace
	private String[] autoReplaceEmoticonShortcutsInTextView = new String[]{ ":)", "^_^", "3)", ":D", ":clap:", ":(", "/_\\", ">.<", "x_x", "D:", ";)", ":P", ":/", ":x", ";o", ":-*", "<3", "</3", "*_*", "6_9", "z_z", ":666:", ":poop:", ":'(", "o_O" };
	private String[] autoReplaceIgnoreWords = new String[] { "http://", "http:/", "https://", "https:/" };
	//TODO: this is used both for autoreplace when sending, and also for marking phrases in EditText. Need to
	//		split to autoreplace and to marking in EditText
	public HashSet<String> autoreplaceIgnorePhrases = new HashSet<String>();
	public Pattern autoreplacePattern = Pattern.compile("");

	// TODO: change to an array with families ordered by priority
	public String autoReplaceEmoticonsInTextViewDefaultIconsFamily = "Oldschool";
	public boolean autoReplaceKeyPhrasesInTextView = false;
	public boolean autoReplaceKeyPhrasesOnEncode = false;

	// Config version
	public String version = AniwaysPhraseReplacementData.EMPTY_PARSER_VERSION;
	public String versionName = "Default";

	// Sync service
	// Aniways base api url
	public String baseApiUrl = "http://api.aniways.com/v2/";
	//public String baseApiUrl = "http://apitest.aniways.com/";
	//Time interval between alarms that schedule polling of the Aniways Server
	public long syncAlarmScheduleInterval = AlarmManager.INTERVAL_HALF_DAY;
	public long syncAlarmScheduleIntervalRestricted = AlarmManager.INTERVAL_DAY; // The interval when the data usage should be restricted
	public long minTimeBetweenSyncs = 1000 * 60 * 60 * 24; //24 hours
	public long timeFromLastMessageBeforeStopSyncing = 1000 * 60 * 60 * 24 * 3; // 3 days

	// Icon sizes
	public int iconInTextViewHeight = 30;
	public int iconInTextViewWidth = 30;
	public int iconInEditTextHeight = 30;
	public int iconInEditTextWidth = 30;
	public int smallIconTextHeight = 20;
	public int smallIconTextWidth = 20;
	public int bigIconHeight = 120;
	public int bigIconWidth = 120;
	public int bannerHeight = 320;
	public int bannerWidth = 320;
	public int iconInSuggestionPopupHeight = 40;
	public int iconInSuggestionPopupWidth = 40;
    public int animatedGifInSuggestionPopupHeight = 60;
    public int animatedGifInSuggestionPopupWidth = 60;
    public int contextualGridRowHeight = 70;
    public int contextualCardHeightThreshold = 5;
    public int contextualGridAnimatedItemMinMargin = 4;
    public int contextualGridEmoticonItemMinMargin = 4;
    public boolean makeStandaloneIconsBigger = true;
	private Integer maxIconSize = 80;
	private int maxBigIconSize = 160;
	private int maxBannerSize = 320;
	// The maximum downsample to perform on an icon if its size needs to be reduced
	// Downsampling saves memory, but it also deteriorates image quality,
	// so above a certain threshold it is best to leave the bitmap big and use
	// the GPU to scale when displaying
	public int maxInSampleSize = 2;

	// Blur effect
	public boolean useBlurEffect = true;
	public float blurBitmapScaleFactor = 0.25f;
	public int minBlurAndroidVersion = 15;

	//Data usage
	public boolean restrictDataUsage = false;
	public boolean forceUpdate = false;

	// Memory
	// The values here are in MB
	// Devices with heap size equal to or below this threshold will be considered as low memory devices, and the experience in those devices will be different
	public HashMap<Float, Integer> lowMemoryThreshold = new HashMap<Float,Integer>(); // the default values are set in the ctor : 0.75:16, 1:16, 1.5:24, 2:32, 3:32, 4:32, 5:64, 6:64, 7:64, 8:64, 9:64, 10:64
	// Devices with heap size equal to or below this threshold will be considered as extremely low memory devices, and Aniways will be disabled on them in order not to take up resources (they will just remove the upgrade message from incoming messages)
	public HashMap<Float, Integer> disableAniwaysExperianceMemoryThreshold = new HashMap<Float,Integer>(); // the default values are set in the ctor : 0.75:12, 1:12, 1.5:16, 2:24, 3:24, 4:24, 5:32, 6:32, 7:32, 8:32, 9:32, 10:32

	//Disk cache size in bytes
	public int diskCacheSize = getDiskCacheSize();

	// User config
	public boolean contextualIconSuggestionsEnabled = true;
	public boolean contextualAnimationsSuggestionsEnabled = true;
	public boolean contextualMusicSuggestionsEnabled = true;
	public boolean contextualLocationBasedSuggestionsEnabled = true;
	public boolean contextualContentSuggestionsEnabled = true;
	public boolean contextualSuggestionsEnabled = true;

	// Privates
	// Calculated values
	private boolean isLowMemoryDevice;
	private boolean isExtremeLowMemoryDevice;
	private static boolean sIsInitialized;
	private static volatile int sInstanceNumber = 0;
	private int mInstanceNumber = 0;
	// Members
	private static AniwaysPrivateConfig sInstance;
	private static Context sContext;
	public boolean sendHeartbeatEvent = true;

	// If true, emojis will be the size of small icon size
	private boolean useSmallEmoji = false;
	public Pattern decoderCodepointsPattern = Pattern.compile("");

	/**
	 * Init Aniways with a context and an App Id (received from Aniways)
	 */
	synchronized static void forceInit(Context context){
		if(context == null){
			throw new IllegalArgumentException("Context cannot be null");
		}

		if(sIsInitialized){
			Log.e(true, TAG, "Initializing Aniways private config after it has already been initialized");
		}

		sContext = context;

		// Although it is a waste, we first create a config without a-b test defs, just in case, and then right after
		// create a new config with those defs..
		AniwaysPrivateConfig cfg = AniwaysPrivateConfig.createNewInstance(null);
		AniwaysPrivateConfig.setNewInstance(cfg);
		// First, get the defaults, then put app config on top of that, then put the last received server config on top of that
		AniwaysBackendSyncChecker.parseConfingAndKeywordsIfNecessary(sContext, true, false);

		sIsInitialized = true;
	}

	private int getDiskCacheSize() {
		Resources r = sContext.getResources();
		DisplayMetrics displayMetrics = r.getDisplayMetrics();
		float density = displayMetrics.density;
		// TODO Auto-generated method stub
		return (int) (this.minDiskCacheSize * 1024 * 1024 * Math.pow(density, 2));
	}

	public static AniwaysPrivateConfig getInstance(){
		if(sInstance == null){
			Log.w(true, TAG, "Getting a null instance");
		}
		return sInstance;
	}

	/**
	 * First get defaults, then put the xml config, then put the a-b testing config
	 * @return
	 */
	public static synchronized AniwaysPrivateConfig createNewInstance(InputStream abTestConfigStream)
	{
		// Get the defaults
		AniwaysPrivateConfig config = new AniwaysPrivateConfig(sInstanceNumber);
		sInstanceNumber++;

		// Add the xml config
		config.parseXmlConfiguration();

		// Add the A-B testing config
		config.parseServerConfiguration(abTestConfigStream);

		// Add the user config
		config.parseUserConfig();

		// Convert icon dimention to pixels
		config.convertIconDimentionsToPixels();

		config.updateAssetsUrl();

		// Calculate the encoding params
		config.calculateEncodingParams();

		// calculate if device is low memory or extremely low memory
		config.calculateIsExtremeLowMemoryDevice();
		config.calculateIsLowMemoryDevice();

		// Calculate the phrases and ignore phrases for auto replace (and also for marking in editText)
		config.autoreplaceIgnorePhrases = new HashSet<String>();
		if(config.autoReplaceIgnoreWords != null && config.autoReplaceIgnoreWords.length > 0){
			config.autoreplaceIgnorePhrases.addAll(Arrays.asList(config.autoReplaceIgnoreWords));
		}
		if(config.autoReplaceEmoticonShortcutsInTextView != null && config.autoReplaceEmoticonShortcutsInTextView.length > 0){
			List<String> phrases = new ArrayList<String>();
			phrases.addAll(Arrays.asList(config.autoReplaceEmoticonShortcutsInTextView));
			// We also add the ignore phrases so they are also detected. Then, when a phrase is detected, it is first checked
			// if it is in the ignore list before marking it. Since the regex finds the longest match, then if a phrase for
			// auto replacement is inside an ignore phrase, the ignore phrase is detected and ignored and the phrase for auto replacement
			// doesn't
			if(config.autoReplaceIgnoreWords != null && config.autoReplaceIgnoreWords.length > 0){
				phrases.addAll(config.autoreplaceIgnorePhrases);
			}
			StringBuilder sb = new StringBuilder();
			for(String p : phrases){
				sb.append(Pattern.quote(p));
				sb.append("|");
			}
			sb.deleteCharAt(sb.length() -1);

			//TODO: Maybe need String pattern = "\\b(" + sb.toString() + ")\\b"; in order to detect only words..

			config.autoreplacePattern = Pattern.compile(sb.toString(), Pattern.CASE_INSENSITIVE);
		}

		// Calculate the pattern to remove all the encoding unicodes
		if(config.decoderCodepointStrings != null && config.decoderCodepointStrings.length > 0){
			StringBuilder sb = new StringBuilder();
			for(String s : config.decoderCodepointStrings){
				sb.append(Pattern.quote(s));
				sb.append("|");
			}
			sb.deleteCharAt(sb.length() -1);

			config.decoderCodepointsPattern  = Pattern.compile(sb.toString(), Pattern.CASE_INSENSITIVE);
		}

		return config;
	}

	private int[] availableSizesOnServer = {60, 80, 120, 160, 240};
	private int[] availableBigIconSizesOnServer = {60, 80, 120, 160, 240};
	private int[] availableBannerSizesOnServer = {240, 320, 480, 640, 960, 1280};
	private String mAssetsUrlPrefix = "http://aniways.blob.core.windows.net/aniways-assets/";
	private String assetsUrl = mAssetsUrlPrefix + "160";
	private String emojiUrl = mAssetsUrlPrefix + "60";
	private String bigIconsUrl = mAssetsUrlPrefix + "320";
	private String bannerUrl = mAssetsUrlPrefix + "640";
	public boolean usePreInstalledIcons = true;
	public boolean usePreInstalledEmojis = true;
	public boolean usePreInstalledBigIcons = true;
	public boolean usePreInstalledBanners = true;
	private Integer preInstalledIconSize = 120;
	private Integer preInstalledEmojiSize = 60;
	private Integer preInstalledBigIconSize = 120;
	private Integer preInstalledBannerSize = 640;

	private int acceptableSizeDifference = 120;
	private int acceptableEmojiSizeDifference = 60;
	private int acceptableBigIconSizeDifference = 120;
	private int acceptableBannerSizeDifference = 120;
	protected boolean disableCreditStoreIcon = false;
	public boolean removePoweredByAniways = false;
	public boolean closeTutorialOnClickAnywhere = false;
	public boolean makeNonAniwaysIconsSmart = true;
	public boolean appIsCallingOnSendingMessage = false;
	public int pulsateAnimationFrom = 90;
	public int pulsateAnimationTo = 105;
	public long pulsateAnimationDuration = 500;
	public int pulsateAnimationRepeatCount = -1;//-1 is Infinite
	public boolean debugPerformance = false;
	public boolean useDefaultEmojiLookInIconsOnDemendPopup = true;
	public long noInternetPopupCloseDelay = 7000;
	public boolean noInternetPopupClose = false;
	public boolean animateInImageView = true;
	// TODO: Thse might be better of being attributes on the wrapper view..
	public int bannerPaddingLeft = 0;
	public int bannerPaddingTop = 20;
	public int bannerPaddingRight = 0;
	public int bannerPaddingBottom = 0;

	private void updateAssetsUrl() {

		int serverResolution = getClosestValue(availableSizesOnServer, maxIconSize);
		int serverResolutionForEmojis = getClosestValue(availableSizesOnServer, (useSmallEmoji ? smallIconTextWidth : maxIconSize));
		int serverResolutionForBigIcons = getClosestValue(availableBigIconSizesOnServer, maxBigIconSize);
		int serverResolutionForBanners = getClosestValue(availableBannerSizesOnServer, maxBannerSize);

		usePreInstalledIcons = maxIconSize - acceptableSizeDifference <= preInstalledIconSize;
		usePreInstalledEmojis = (useSmallEmoji ? smallIconTextWidth - acceptableEmojiSizeDifference <= preInstalledEmojiSize : usePreInstalledIcons);
		usePreInstalledBigIcons = maxBigIconSize - acceptableBigIconSizeDifference <= preInstalledBigIconSize;
		usePreInstalledBanners = maxBannerSize - acceptableBannerSizeDifference <= preInstalledBannerSize;

		assetsUrl = mAssetsUrlPrefix + serverResolution;
		emojiUrl = mAssetsUrlPrefix + serverResolutionForEmojis;
		bigIconsUrl = mAssetsUrlPrefix + serverResolutionForBigIcons;
		bannerUrl = mAssetsUrlPrefix + serverResolutionForBanners;
	}

	private static int getClosestValue(int[] availableSizes, int size) {
		int idx = 0;
		while(availableSizes[idx] < size){
			idx++;
			if(idx == availableSizes.length){
				return availableSizes[idx -1];
			}
		}
		return availableSizes[idx];
	}

	private void parseUserConfig() {
		Aniways.Configuration.setPrivateConfigProperties(sContext, this);
	}

	AniwaysPrivateConfig(int instanceNumner){
		this.mInstanceNumber = instanceNumner;

		// Devices with heap size equal to or below this threshold will be considered as low memory devices, and the experience in those devices will be different
		lowMemoryThreshold.put(0.75f, 16);
		lowMemoryThreshold.put(1f, 16);
		lowMemoryThreshold.put(1.5f, 24);
		lowMemoryThreshold.put(2f, 32);
		lowMemoryThreshold.put(3f, 32);
		lowMemoryThreshold.put(4f, 32);
		lowMemoryThreshold.put(5f, 64);
		lowMemoryThreshold.put(6f, 64);
		lowMemoryThreshold.put(7f, 64);
		lowMemoryThreshold.put(8f, 64);
		lowMemoryThreshold.put(9f, 64);
		lowMemoryThreshold.put(10f, 64);

		disableAniwaysExperianceMemoryThreshold.put(0.75f, 12);
		disableAniwaysExperianceMemoryThreshold.put(1f, 12);
		disableAniwaysExperianceMemoryThreshold.put(1.5f, 16);
		disableAniwaysExperianceMemoryThreshold.put(2f, 24);
		disableAniwaysExperianceMemoryThreshold.put(3f, 24);
		disableAniwaysExperianceMemoryThreshold.put(4f, 24);
		disableAniwaysExperianceMemoryThreshold.put(5f, 32);
		disableAniwaysExperianceMemoryThreshold.put(6f, 32);
		disableAniwaysExperianceMemoryThreshold.put(7f, 32);
		disableAniwaysExperianceMemoryThreshold.put(8f, 32);
		disableAniwaysExperianceMemoryThreshold.put(9f, 32);
		disableAniwaysExperianceMemoryThreshold.put(10f, 32);
	}

	public static void setNewInstance(AniwaysPrivateConfig newConfig){
		if(sInstance != null && newConfig.mInstanceNumber < sInstance.mInstanceNumber){
			Log.w(false, TAG, "Received config with lower instance number: " + newConfig.mInstanceNumber + ". Current number: " + sInstance.mInstanceNumber + ". So, not setting it");
			return;
		}

		sInstance = newConfig;

		// Set the static verbosity (this is accessed by the logs, which are inited before the config is).
		sLogsVerbosity = newConfig.logsVerbosity;

		// Call config listeners if we are after the init phase
		if(!AniwaysStatics.isInitializing()){
			GoogleAnalyticsReporter.onConfigChange(newConfig, sContext);
		}

		setParsedConfigVersion(sContext, newConfig.version);

		String oldConfigVersion = getParsedConfigVersion(sContext);

		Log.i(TAG, "Setting new config to version: " + newConfig.version + " Old config version: " + oldConfigVersion + "");

		VersionComparisonResult comparisonResult = null;
		try{
			comparisonResult = Utils.compareVersionStrings(newConfig.version, oldConfigVersion);
		}
		catch(IllegalArgumentException e){
			Log.e(true, TAG, "Error parsing config version: " + oldConfigVersion, e);
		}

		if (comparisonResult != null){
			if(comparisonResult.result == 1){
				if(AnalyticsReporter.isInitialized()){
					Log.i(TAG, "Updated Config Version from: " + oldConfigVersion + ", to: " + newConfig.version);
					GoogleAnalyticsReporter.reportEvent(Verbosity.Info, "Statistics", "Updated Config Version", "from: " + oldConfigVersion + ", to: " + newConfig.version, 0);
					AnalyticsReporter.reportUpdatedConfigVersion(oldConfigVersion, newConfig.version);
				}
			}
			else if (comparisonResult.result == 0){
				Log.i(TAG, "Setting new config to version which has already been parsed when the app was running at a previous time: " + newConfig.version );
			}
			else{
				Log.e(true, TAG, "Setting config for lower version than was parsed before. Old version: " + oldConfigVersion + " . New version:" + newConfig.version);
			}
		}
	}

	/**
	 * Parse the config XML
	 */
	private void parseXmlConfiguration() {

		// Get the mandatory config values from the aniways xml.
		Pair<Boolean,String> appId = getResourceString("aniways_appId", true, sContext);

		// Get the non mandatory config values from the aniways xml..
		Pair<Boolean,String> upgradeUrl = getResourceString("aniways_upgradeUrl", false, sContext);
		Pair<Boolean,String> upgradeMessage = getResourceString("aniways_upgradeMessage", false, sContext);
		Pair<Boolean,String> iconEncodingMethod = getResourceString("aniways_iconEncodingMethod", false, sContext);
		Pair<Boolean,Boolean> useOnlyConfiguredEncodingMethodForDecoding = getResourceBoolean("aniways_useOnlyConfiguredEncodingMethodForDecoding", false, sContext);
		Pair<Boolean,String> logsVerbosity = getResourceString("aniways_logsVerbosity", false, sContext);
		Pair<Boolean,Boolean> tryUsingExternalStorageForIconCaching = getResourceBoolean("aniways_try_using_external_storage_for_icon_caching", false, sContext);
		Pair<Boolean,Integer> smallIconSize = getResourceInt("aniways_smallIconSize", false, sContext);
		Pair<Boolean,Integer> bigIconSize = getResourceInt("aniways_bigIconSize", false, sContext);
		Pair<Boolean,Integer> bannerSize = getResourceInt("aniways_bannerSize", false, sContext);
		Pair<Boolean,Boolean> makeStandaloneIconsBigger = getResourceBoolean("aniways_makeStandaloneIconsBigger", false, sContext);
		Pair<Boolean,Integer> iconInEditTextSize = getResourceInt("aniways_iconInEditTextSize", false, sContext);
		Pair<Boolean,Integer> iconInTextViewSize = getResourceInt("aniways_iconInTextViewSize", false, sContext);
		Pair<Boolean,Integer> iconInSuggestionPopupSize = getResourceInt("aniways_iconInSuggestionPopupSize", false, sContext);
        Pair<Boolean,Integer> animatedGifInSuggestionPopupSize = getResourceInt("aniways_animatedGifInSuggestionPopupSize", false, sContext);
		Pair<Boolean,Boolean> useSmallerIconsInIconsOnDemendPopup = getResourceBoolean("aniways_useSmallerIconsInIconsOnDemendPopup", false, sContext);
		Pair<Boolean,Integer> numberOfWordsRequiredToShowTutorialAgain = getResourceInt("aniways_numberOfWordsRequiredToShowTutorialAgain", false, sContext);
		Pair<Boolean,Integer> maxTimesToShowTutorial = getResourceInt("aniways_maxTimesToShowTutorial", false, sContext);
		Pair<Boolean,Boolean> useEditTextTutorial = getResourceBoolean("aniways_useEditTextTutorial", false, sContext);
		Pair<Boolean,Boolean> disableCreditStoreBalanceButton = getResourceBoolean("aniways_disableCreditStoreBalanceButton", false, sContext);
		Pair<Boolean,Boolean> useTextViewTutorial = getResourceBoolean("aniways_useTextViewTutorial", false, sContext);
		Pair<Boolean,Integer> wordHighlightColor = getResourceInt("aniways_wordHighlightColor", false, sContext);
		Pair<Boolean,Boolean> creditsStoreEnabled = getResourceBoolean("aniways_enable_credits_store", false, sContext);
		Pair<Boolean,String> appPublicKeyForCreditsStore = getResourceString("aniways_app_public_key_for_credits_store", false, sContext);
		Pair<Boolean,Integer> creditsStoreInitialCredits = getResourceInt("aniways_store_initial_credits", false, sContext);
		Pair<Boolean,String> creditsSku100 = getResourceString("aniways_100_credits_sku", false, sContext);
		Pair<Boolean,String> creditsSku250 = getResourceString("aniways_250_credits_sku", false, sContext);
		Pair<Boolean,String> creditsSku500 = getResourceString("aniways_500_credits_sku", false, sContext);
		Pair<Boolean,String> creditsSku1000 = getResourceString("aniways_1000_credits_sku", false, sContext);
		Pair<Boolean,String> creditsSku2000 = getResourceString("aniways_2000_credits_sku", false, sContext);
		Pair<Boolean,String> creditsSku3000 = getResourceString("aniways_3000_credits_sku", false, sContext);
		Pair<Boolean,Boolean> removePoweredByAniways = getResourceBoolean("aniways_removePoweredByAniways", false, sContext);
		Pair<Boolean,Boolean> autoReplaceKeyPhrasesInTextView = getResourceBoolean("aniways_autoReplaceKeyPhrasesInTextView", false, sContext);
		Pair<Boolean,Boolean> autoreplaceKeyPhrasesOnEncode = getResourceBoolean("aniways_autoReplaceKeyPhrasesOnEncode", false, sContext);
		Pair<Boolean,Boolean> debugPerformance = getResourceBoolean("aniways_debugPerformance", false, sContext);


		// Set the mandatory values
		this.appId = appId.second;

		// Set the non-mandatory values
		if(upgradeUrl.first){
			setUpgradeUrlInternal(upgradeUrl.second);
		}
		if(upgradeMessage.first){
			setUpgradeMessageInternal(upgradeMessage.second);
		}
		if(logsVerbosity.first){
			setLogsVerbosityInternal(logsVerbosity.second);
		}
		if(iconEncodingMethod.first){
			setIconEncodingMethodInternal(iconEncodingMethod.second);
		}
		if(useOnlyConfiguredEncodingMethodForDecoding.first){
			this.useOnlyConfiguredEncodingMethodForDecoding = useOnlyConfiguredEncodingMethodForDecoding.second;
		}
		if(tryUsingExternalStorageForIconCaching.first){
			this.tryUsingExternalStorageForIconCaching = tryUsingExternalStorageForIconCaching.second;
		}
		// Init the icon sizes properties.
		// Must be done b4 the private init because it uses these values..

		if(smallIconSize.first){
			setSmallIconSizeInternal(smallIconSize.second);
		}
		if(bigIconSize.first){
			setBigIconSizeInternal(bigIconSize.second);
		}
		if(bannerSize.first){
			setBannerSizeInternal(bannerSize.second);
		}
		if(makeStandaloneIconsBigger.first){
			this.makeStandaloneIconsBigger= makeStandaloneIconsBigger.second;
		}
		if(iconInEditTextSize.first){
			setIconInEditTextSizeInternal(iconInEditTextSize.second);
		}
		if(iconInSuggestionPopupSize.first){
			setIconInSuggestionPopupSizeInternal(iconInSuggestionPopupSize.second);
		}
        if(animatedGifInSuggestionPopupSize.first){
            setAnimatedGifInSuggestionPopupSizeInternal(animatedGifInSuggestionPopupSize.second);
        }
		if(iconInTextViewSize.first){
			setIconInTextViewSizeInternal(iconInTextViewSize.second);
		}
		if(useSmallerIconsInIconsOnDemendPopup.first){
			this.useSmallerIconsInIconsOnDemendPopup = useSmallerIconsInIconsOnDemendPopup.second;
		}
		if(numberOfWordsRequiredToShowTutorialAgain.first){
			setNumberOfWordsRequiredToShowTutorialAgainInternal(numberOfWordsRequiredToShowTutorialAgain.second);
		}
		if(maxTimesToShowTutorial.first){
			setMaxTimesToShowTutorialInternal(maxTimesToShowTutorial.second);
		}
		if(useEditTextTutorial.first){
			setUseEditTextTutorialInternal(useEditTextTutorial.second);
		}
		if(disableCreditStoreBalanceButton.first){
			setDisableCreditStoreBalanceButton(disableCreditStoreBalanceButton.second);
		}
		if(useTextViewTutorial.first){
			setUseTextViewTutorialInternal(useTextViewTutorial.second);
		}
		if(wordHighlightColor.first){
			this.wordHighlightColor = wordHighlightColor.second;
		}
		// Set the store values
		if(creditsStoreEnabled.first){
			this.creditsStoreEnabled = creditsStoreEnabled.second;
		}
		if(appPublicKeyForCreditsStore.first){
			setAppPublicKeyForCreditsStoreInternal(appPublicKeyForCreditsStore.second);
		}
		if(creditsStoreInitialCredits.first){
			setCreditsStoreInitialCreditsInternal(creditsStoreInitialCredits.second);
		}
		if(creditsSku100.first){
			setCreditsSkuInternal(100, creditsSku100.second);
		}
		if(creditsSku250.first){
			setCreditsSkuInternal(250, creditsSku250.second);
		}
		if(creditsSku500.first){
			setCreditsSkuInternal(500, creditsSku500.second);
		}
		if(creditsSku1000.first){
			setCreditsSkuInternal(1000, creditsSku1000.second);
		}
		if(creditsSku2000.first){
			setCreditsSkuInternal(2000, creditsSku2000.second);
		}
		if(creditsSku3000.first){
			setCreditsSkuInternal(3000, creditsSku3000.second);
		}
		if(removePoweredByAniways.first){
			setRemovePoweredByAniwaysInternal(removePoweredByAniways.second);
		}
		if(autoReplaceKeyPhrasesInTextView.first){
			setAutoReplaceKeyPhrasesInTextView(autoReplaceKeyPhrasesInTextView.second);
		}
		if(autoreplaceKeyPhrasesOnEncode.first){
			setAutoreplaceKeyPhrasesOnEncode(autoreplaceKeyPhrasesOnEncode.second);
		}
		if(debugPerformance.first){
			this.debugPerformance = debugPerformance.second;
		}
	}

	/**
	 * Parse the A-B testing config received from the server
	 */
	private void parseServerConfiguration(InputStream abTestConfigStream){

		if(abTestConfigStream == null){
			if(!AniwaysStatics.isInitializing()){
				Log.e(true, TAG, "Could not find a-b test config file, so running without");
			}
			else{
				Log.i(TAG, "Could not find pre-installed a-b test config file, so running without");
			}
			return;
		}

		String jsonText = null;
		try {
			byte[] buffer = null;
			buffer = new byte[4096];
			while (abTestConfigStream.read(buffer) != -1);
			abTestConfigStream.close();
			jsonText = new String(buffer, "UTF-8");
		} catch (FileNotFoundException e) {
			Log.e(true, TAG, "Caught FileNotFoundException while reading config Json", e);
		} catch (UnsupportedEncodingException e) {
			Log.e(true, TAG, "Caught UnsupportedEncodingException while reading config Json", e);
		} catch (IOException e) {
			Log.e(true, TAG, "Caught IOException while reading config Json", e);
		}

		if(TextUtils.isEmpty(jsonText)){
			Log.e(true, TAG, "a-b test config file empty, so running without");
			return;
		}

		JSONObject jsonObject = null;
		try {
			jsonObject = new JSONObject(jsonText);
		} catch (JSONException e) {
			Log.e(true, TAG, "Caught JSONException while creating object", e);
			return;
		}

		@SuppressWarnings("unchecked")
		Iterator<String> keys = jsonObject.keys();
		Class<? extends AniwaysPrivateConfig> configClass = this.getClass();
		while (keys.hasNext()){
			String key = keys.next();
			Field field = null;
			try {
				field = configClass.getDeclaredField(key);
			} catch (NoSuchFieldException e) {
				// TODO: this is currently not severe because we also send ios config which contains other fields. Need to send
				//		only android config and then fire this error
				Log.i(TAG, "Could not find field with name: " + key);
				continue;
			}
			Class<?> fieldType = field.getType();
			try{
				if(fieldType == int.class || fieldType == Integer.class){
					field.set(this, jsonObject.getInt(key));
				}
				else if(fieldType == long.class || fieldType == Long.class){
					field.set(this, jsonObject.getLong(key));
				}
				else if(fieldType == double.class || fieldType == Double.class){
					field.set(this, jsonObject.getDouble(key));
				}
				else if(fieldType == String.class){
					field.set(this, jsonObject.getString(key));
				}
				else if(fieldType == boolean.class || fieldType == Boolean.class){
					field.set(this, jsonObject.getBoolean(key));
				}
				else if(fieldType == Verbosity.class){
					String verbosityString = "";
					try{
						verbosityString = jsonObject.getString(key);
						Verbosity verbosity = Verbosity.valueOf(verbosityString);
						field.set(this, verbosity);
					}
					catch(Throwable e){
						Log.e(true, TAG, "Could not parse verbosity: " + verbosityString, e);
						continue;
					}
				}
				else if(fieldType == IconEncodingMethod.class){
					String methodString = "";
					try{
						methodString = jsonObject.getString(key);
						IconEncodingMethod method = IconEncodingMethod.valueOf(methodString);
						field.set(this, method);
					}
					catch(Throwable e){
						Log.e(true, TAG, "Could not parse icon encoding method: " + methodString, e);
						continue;
					}
				}
				else if(fieldType == AnalyticsCloud.class){
					String cloudString = "";
					try{
						cloudString = jsonObject.getString(key);
						AnalyticsCloud cloud = AnalyticsCloud.valueOf(cloudString);
						field.set(this, cloud);
					}
					catch(Throwable e){
						Log.e(true, TAG, "Could not parse analytics cloud: " + cloudString, e);
						continue;
					}
				}
				else if(fieldType == String[].class){
					JSONArray jsonArray = jsonObject.getJSONArray(key);
					int length = jsonArray.length();
					if(length > 0){
						String[] value = new String[length];
						for(int i = 0 ; i < length ; i++){
							value[i] = jsonArray.getString(i);
						}
						field.set(this, value);
					}
				}
				else if(fieldType == HashMap.class){
					// TODO: right now, the only HashMaps we have are for Float,Int - so no need to discover the real types
					// when this will change we will have to use field.getGenericType()
					try{
						JSONObject map = jsonObject.getJSONObject(key);
						@SuppressWarnings("unchecked")
						HashMap<Float, Integer> hm = (HashMap<Float, Integer>) field.get(this);
						@SuppressWarnings("unchecked")
						Iterator<String> iterator = map.keys();
						while(iterator.hasNext()){
							String k = iterator.next();
							int v = map.getInt(k);
							hm.put(Float.parseFloat(k), v);
						}
					}
					catch(Throwable e){
						Log.e(true, TAG, "Could not parse Hashmap: " + field == null ? "null" : field.toGenericString(), e);
						continue;
					}
				}
				else if(fieldType == int[].class){
					JSONArray array = jsonObject.optJSONArray(key);
					int length = array.length();
					if(length > 0){
						int[] value = new int[length];
						for(int i = 0 ; i < length ; i++){
							value[i] = array.getInt(i);
						}
						field.set(this, value);
					}
				}
			} catch (IllegalArgumentException e) {
				Log.e(true, TAG, "Could not parse field: " + key, e);
			} catch (IllegalAccessException e) {
				Log.e(true, TAG, "Could not parse field: " + key, e);
			} catch (JSONException e) {
				Log.e(true, TAG, "Could not parse field: " + key, e);
			}
		}
	}

	private void convertIconDimentionsToPixels() {
		iconInSuggestionPopupWidth = AniwaysUiUtil.convertDipsToPixels(iconInSuggestionPopupWidth);
		iconInSuggestionPopupHeight = AniwaysUiUtil.convertDipsToPixels(iconInSuggestionPopupHeight);
        animatedGifInSuggestionPopupWidth = AniwaysUiUtil.convertDipsToPixels(animatedGifInSuggestionPopupWidth);
        animatedGifInSuggestionPopupHeight = AniwaysUiUtil.convertDipsToPixels(animatedGifInSuggestionPopupHeight);
        contextualGridRowHeight = AniwaysUiUtil.convertDipsToPixels(contextualGridRowHeight);
        contextualGridAnimatedItemMinMargin = AniwaysUiUtil.convertDipsToPixels(contextualGridAnimatedItemMinMargin);
        contextualGridEmoticonItemMinMargin = AniwaysUiUtil.convertDipsToPixels(contextualGridEmoticonItemMinMargin);
		iconInEditTextWidth = AniwaysUiUtil.convertDipsToPixels(iconInEditTextWidth);
		iconInEditTextHeight = AniwaysUiUtil.convertDipsToPixels(iconInEditTextHeight);
		iconInTextViewWidth = AniwaysUiUtil.convertDipsToPixels(iconInTextViewWidth);
		iconInTextViewHeight = AniwaysUiUtil.convertDipsToPixels(iconInTextViewHeight);
		smallIconTextWidth = AniwaysUiUtil.convertDipsToPixels(smallIconTextWidth);
		smallIconTextHeight = AniwaysUiUtil.convertDipsToPixels(smallIconTextHeight);
		bigIconWidth = AniwaysUiUtil.convertDipsToPixels(bigIconWidth);
		bigIconHeight = AniwaysUiUtil.convertDipsToPixels(bigIconHeight);
		bannerWidth = AniwaysUiUtil.convertDipsToPixels(bannerWidth);
		bannerHeight = AniwaysUiUtil.convertDipsToPixels(bannerHeight);
		bannerPaddingLeft = AniwaysUiUtil.convertDipsToPixels(bannerPaddingLeft);
		bannerPaddingTop = AniwaysUiUtil.convertDipsToPixels(bannerPaddingTop);
		bannerPaddingRight = AniwaysUiUtil.convertDipsToPixels(bannerPaddingRight);
		bannerPaddingBottom = AniwaysUiUtil.convertDipsToPixels(bannerPaddingBottom);
		int onDemandSize = useSmallerIconsInIconsOnDemendPopup ? 47 : 70;

		// We do not use the big icon size here, because we want to conserve costs and not download big icons.
		// Super sampling should be good enough for most big sizes.
		Integer [] sizes = {iconInSuggestionPopupWidth, iconInSuggestionPopupHeight, iconInEditTextWidth, iconInEditTextHeight,
				iconInTextViewWidth, iconInTextViewHeight, smallIconTextWidth, smallIconTextHeight, AniwaysUiUtil.convertDipsToPixels(onDemandSize)};
		maxIconSize  = Collections.max(Arrays.asList(sizes));

		Integer[] sizes2 = { bigIconWidth, bigIconHeight };
		maxBigIconSize = Collections.max(Arrays.asList(sizes2));

		Integer[] sizes3 = { bannerWidth, bannerHeight };
		maxBannerSize = Collections.max(Arrays.asList(sizes3));
	}

	private  Pair<Boolean,String> getResourceString(String name, boolean mandatory, Context context){
		int resId = getResourceId(name, "string", context);
		if (mandatory){
			// This throws an Exception if the validation fails
			verifyMandatoryResourceId(name, resId);
		}
		if(resId != 0){
			String result = context.getResources().getString(resId);
			Log.i(TAG, "Found config value for " + name + " in Aniways.xml config file. Value is: " + result);
			return new Pair<Boolean,String>(true, result);
		}
		Log.i(TAG, "Did not find config value for " + name + " in Aniways.xml config file. Using default value");
		return new Pair<Boolean,String>(false, "");
	}

	private  Pair<Boolean,Integer> getResourceInt(String name, boolean mandatory, Context context){
		int resId = getResourceId(name, "integer", context);
		if (mandatory){
			// This throws an Exception if the validation fails
			verifyMandatoryResourceId(name, resId);
		}
		if(resId != 0){
			int result = context.getResources().getInteger(resId);
			Log.i(TAG, "Found config value for " + name + " in Aniways.xml config file. Value is: " + result);
			return new Pair<Boolean,Integer>(true, result);
		}
		Log.i(TAG, "Did not find config value for " + name + " in Aniways.xml config file. Using default value");
		return new Pair<Boolean,Integer>(false, -1);
	}

	private  Pair<Boolean,Boolean> getResourceBoolean(String name, boolean mandatory, Context context){
		int resId = getResourceId(name, "bool", context);
		if (mandatory){
			// This throws an Exception if the validation fails
			verifyMandatoryResourceId(name, resId);
		}
		if(resId != 0){
			boolean result = context.getResources().getBoolean(resId);
			Log.i(TAG, "Found config value for " + name + " in Aniways.xml config file. Value is: " + result);
			return new Pair<Boolean,Boolean>(true, result);
		}
		Log.i(TAG, "Did not find config value for " + name + " in Aniways.xml config file. Using default value");
		return new Pair<Boolean,Boolean>(false,false);
	}

	private  int getResourceId(String name, String type, Context context){
		int result = context.getResources().getIdentifier(name, type, context.getPackageName());
		return result;
	}

	private  void verifyMandatoryResourceId(String name, int id){
		if(id == 0){
			String errorMessage = "Missing mandatory config value from aniways xml: " + name;
			Log.e(false, TAG, errorMessage);
			throw new IllegalArgumentException(errorMessage);
		}
	}

	// TODO: put these in a different shared perfs file and put the keys and all in a different class cause they do not belong to the service, this is entirely in the app itself..
	private static synchronized String getParsedConfigVersion(Context context) {
		// open the shared preferences
		SharedPreferences prefs = context.getSharedPreferences(AniwaysServiceUtils.SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());

		// return the values that stored there, in case that no value
		// is stored return false
		String result = prefs.getString(KEY_PARSED_CONFIG_VERSION, AniwaysPhraseReplacementData.EMPTY_PARSER_VERSION);
		return result;
	}

	/**
	 * Update the APP_ID value in the shared preferences with the given value
	 * @param context Application context
	 */
	private static synchronized void setParsedConfigVersion(Context context, String version) {
		// open the shared preferences
		SharedPreferences prefs = context.getSharedPreferences(AniwaysServiceUtils.SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
		Editor edit = prefs.edit();
		// write the new value
		edit.putString(KEY_PARSED_CONFIG_VERSION, version);
		edit.commit();
	}

	//
	//// Config Properties internal setters
	//
	private void setIconInSuggestionPopupSizeInternal(int size) {
		if(size < 1){
			throw new IllegalArgumentException("received size < 1 for suggestion popup icon. Size was: " + size);
		}

		iconInSuggestionPopupWidth = size;
		iconInSuggestionPopupHeight = size;
	}

    private void setAnimatedGifInSuggestionPopupSizeInternal(int size) {
        if(size < 1){
            throw new IllegalArgumentException("received size < 1 for suggestion popup animated gif. Size was: " + size);
        }

        animatedGifInSuggestionPopupWidth = size;
        animatedGifInSuggestionPopupHeight = size;
    }

	private void setIconInEditTextSizeInternal(int size) {

		if(size < 1){
			throw new IllegalArgumentException("received size < 1 for edit text icon. Size was: " + size);
		}

		iconInEditTextWidth = size;
		iconInEditTextHeight = size;
	}

	private void setSmallIconSizeInternal(int size) {

		if(size < 1){
			throw new IllegalArgumentException("received size < 1 for small icon. Size was: " + size);
		}

		smallIconTextWidth = size;
		smallIconTextHeight = size;
	}

	private void setBigIconSizeInternal(int size) {

		if(size < 1){
			throw new IllegalArgumentException("received size < 1 for big icon. Size was: " + size);
		}

		bigIconWidth = size;
		bigIconHeight = size;
	}

	private void setBannerSizeInternal(int size) {

		if(size < 1){
			throw new IllegalArgumentException("received size < 1 for banner. Size was: " + size);
		}

		bannerWidth = size;
		bannerHeight = size;
	}

	void setIconInTextViewSizeInternal(int size) {
		if(size < 1){
			throw new IllegalArgumentException("received size < 1 for text view icon. Size was: " + size);
		}

		iconInTextViewWidth = size;
		iconInTextViewHeight = size;
	}

	private void setUseEditTextTutorialInternal(boolean useIt) {
		if(!useIt){
			Log.w(false, TAG, "Turning off EditText tutorial. This means that the users will not learn to click on highlighted words.");
		}

		useEditTextTutorial = useIt;
	}

	private void setDisableCreditStoreBalanceButton(boolean disable) {
		this.disableCreditStoreIcon = disable;

	}

	private void setUseTextViewTutorialInternal(boolean useIt) {
		if(!useIt){
			// TODO: re-enable when we will have the actual tutorial
			//Log.w(false, TAG, "Turning off TextView tutorial. This means that the users will not learn to click on Aniways Icons.");
		}

		useTextViewTutorial = useIt;
	}

	private void setMaxTimesToShowTutorialInternal(int times) {
		if(times < 0){
			throw new IllegalArgumentException("received times to show tutorial < 0. Times was: " + times);
		}
		if(times < 1){
			Log.w(false, TAG, "Received max time to show tutorial < 1 ( " + times + "). If your intention is to turn off the tutorial then set useTextViewTutorial and useEditTextTutorial properties to false");
		}

		maxTimesToShowTutorial = times;
	}

	private void setAppPublicKeyForCreditsStoreInternal(String key) {

		if (key == null || Utils.isStringEmpty(key) || key.equalsIgnoreCase(DEFAULT_PUBLIC_KEY)){
			Log.e(false, TAG, "Illegal app public key!! You must supply the application's public key. If the store is not enabled then remove this config value. If you would like to set it in code and not in the XML config then remove it from the XML");
			throw new IllegalArgumentException("Illegal app public key!! You must supply the application's public key. If the store is not enabled then remove this config value. If you would like to set it in code and not in the XML config then remove it from the XML");
		}

		appPublicKeyForCreditsStore = key;
	}

	private void setCreditsStoreInitialCreditsInternal(int amount) {

		if(amount < 0){
			throw new IllegalArgumentException("received initial store credits amount < 0. Amount was: " + amount);
		}
		if(amount < 10){
			Log.w(false, TAG, "Received initial store credits of " + amount + " which is smaller than 10 (the minimum amount to unlock one icon). \nWe recommend to set it to something like 100 to get the user used to using credits to unlocking icons and increase the chances that he she would buy credits later.");
		}

		creditsStoreInitialCredits = amount;
	}

	private  void setCreditsSkuInternal(int amount, String sku) {

		if(sku == null || Utils.isStringEmpty(sku)){
			throw new IllegalArgumentException("Received sku that is null or empty");
		}

		switch(amount){
		case 100 : {
			creditsSku100 = sku;
			break;
		}
		case 250 : {
			creditsSku250 = sku;
			break;
		}
		case 500 : {
			creditsSku500 = sku;
			break;
		}
		case 1000 : {
			creditsSku1000 = sku;
			break;
		}
		case 2000 : {
			creditsSku2000 = sku;
			break;
		}
		case 3000 : {
			creditsSku3000 = sku;
			break;
		}
		}
	}

	private  void setUpgradeMessageInternal(String upgradeMessage) {
		if(upgradeMessage == null){
			upgradeMessage = "";
		}

		if(upgradeMessage.length() == 0){
			Log.w(false, TAG, "The upgrade message is empty. This means that users without a version with Aniways SDK will receive messages with the upgrade url as their suffix without an explenation");
		}

		upgradeMessage = "\n\n" + upgradeMessage + " ";
	}

	private  void setUpgradeUrlInternal(String url) {
		// Do nothing, since this is no longer supported..
	}

	private  void setNumberOfWordsRequiredToShowTutorialAgainInternal(int number) {

		if(number < 0){
			throw new IllegalArgumentException("received number to show tutorial again < 0. Number was: " + number);
		}

		numberOfWordsRequiredToShowTutorialAgain = number;
	}

	private void setLogsVerbosityInternal(String verbosity) {
		try{
			logsVerbosity = Verbosity.valueOf(verbosity);
		}
		catch(Throwable e){
			String enums = "";
			for (Verbosity v : Verbosity.values())
			{
				String name = v.name();
				enums += (", " + name );
			}
			if(enums.length() > 2){
				enums = enums.substring(2);
			}
			String errorMessage = "Error parsing verbosity from configuration. Value was: " + verbosity + ". The value needs to be one of the following: " + enums;
			Log.e(true, TAG, errorMessage);
			throw new IllegalArgumentException(errorMessage, e);
		}
	}

	private void setIconEncodingMethodInternal(String method) {
		try{
			iconEncodingMethod = IconEncodingMethod.valueOf(method);
		}
		catch(Throwable e){
			String enums = "";
			for (IconEncodingMethod v : IconEncodingMethod.values())
			{
				String name = v.name();
				enums += (", " + name );
			}
			if(enums.length() > 2){
				enums = enums.substring(2);
			}
			String errorMessage = "Error parsing IconEncodingMethod from configuration. Value was: " + method + ". The value needs to be one of the following: " + enums;
			Log.e(true, TAG, errorMessage);
			throw new IllegalArgumentException(errorMessage, e);
		}
	}

	private void setRemovePoweredByAniwaysInternal(Boolean remove) {
		this.removePoweredByAniways = remove;
	}

	private void setAutoReplaceKeyPhrasesInTextView(Boolean replace) {
		this.autoReplaceKeyPhrasesInTextView = replace;
	}

	private void setAutoreplaceKeyPhrasesOnEncode(Boolean replace) {
		this.autoReplaceKeyPhrasesOnEncode = replace;
	}

	public boolean isGoogleAnalyticsDisabled(){
		return googleAnalyticsEventsVerbosity == Verbosity.Off &&
				gaTimingEventsVerbosity == Verbosity.Off &&
				gaScreenEventsVerbosity == Verbosity.Off;
	}

	public boolean isAnalyticsDisabled(){
		return analyticsEventsVerbosity == Verbosity.Off &&
				timingEventsVerbosity == Verbosity.Off &&
				screenEventsVerbosity == Verbosity.Off;
	}

	public int getIconPriceInCredits(IconData icon) {
		// TODO: Right now all icons are proced the same..
		return defalutLockedIconPrice;
	}

	public static Verbosity getLogsVerbosity() {
		return sLogsVerbosity;
	}

	public boolean isLowMemoryDevice() {
		return isLowMemoryDevice;
	}

	public boolean isExtremeLowMemoryDevice() {
		// TODO: really calc this
		return isExtremeLowMemoryDevice;
	}

	private void calculateIsLowMemoryDevice(){
		isLowMemoryDevice = calculateIsDeviceMemoryBelowThrwshold(lowMemoryThreshold);
	}

	private void calculateIsExtremeLowMemoryDevice(){
		isExtremeLowMemoryDevice = calculateIsDeviceMemoryBelowThrwshold(disableAniwaysExperianceMemoryThreshold);
	}

	private boolean calculateIsDeviceMemoryBelowThrwshold(HashMap<Float, Integer> thresholds){
		float density = calculateDisplayDensity(sContext);
		Float[] arr = new Float[thresholds.keySet().size()];
		int maxMem = (int) (Runtime.getRuntime().maxMemory() / (1024*1024));
		thresholds.keySet().toArray(arr);
		Arrays.sort(arr);
		for (int i = 0; i < arr.length; i++){
			float den = arr[i];
			if(density <= den){
				int threshold = thresholds.get(den);
				return maxMem <= threshold;
			}
		}

		// If the density is larger than anything configured, this must be a very high end device, and thus not low mem :)
		return false;
	}

	private float calculateDisplayDensity(Context context){
		WindowManager manager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);

		if (manager != null) {

			DisplayMetrics metrics = new DisplayMetrics();

			android.view.Display display = manager.getDefaultDisplay();
			display.getMetrics(metrics);

			return metrics.density;
		}

		return 1;
	}

	private void calculateEncodingParams() {
		delimiterString = new String(new int[] { Integer.parseInt(delimiter, 16) }, 0, 1);
		String[] decoderCodes = decoderCodepointsString.split("-");
		decoderRadix = decoderCodes.length;
		int[] decoderCodepoints = new int[decoderRadix];
		for (int i = 0; i< decoderRadix; i++){
			decoderCodepoints[i] = Integer.parseInt(decoderCodes[i], 16);
		}
		decoderCodepointStrings = new String[decoderRadix];
		for (int i = 0; i< decoderRadix; i++){
			decoderCodepointStrings[i] = new String(decoderCodepoints, i, 1);
		}
	}

	public boolean getUseBlurEffect(){

		Log.i(TAG, "Min blur android version: " + minBlurAndroidVersion + ". CPU: " + Build.CPU_ABI);
		Log.i(TAG, "height: " + iconInEditTextHeight + ". Width: " + iconInEditTextWidth + " Size: " + iconInEditTextSize);


		if(!Utils.isAndroidVersionAtLeast(minBlurAndroidVersion )){
			return false;
		}
		if (!Build.CPU_ABI.equalsIgnoreCase("armeabi-v7a")&& !Build.CPU_ABI.equalsIgnoreCase("mips-r2")) {
			return false;
		}

		Log.i(TAG, "Using blur effecr");
		return this.useBlurEffect;
	}

	public int getMaxWidthForCache(IconData icon){
		if(icon.isEmoji() && useSmallEmoji){
			return smallIconTextWidth;
		}
		return maxIconSize;
	}

	public int getMaxHeightForCache(IconData icon){
		if(icon.isEmoji() && useSmallEmoji){
			return smallIconTextHeight;
		}
		return maxIconSize;
	}

	public String getIconUrl(IconData icon, boolean displayBig, boolean displayBanner){
		String url = icon.getUrl(useSmallEmoji, displayBig, displayBanner);
        if(url != null){
            // Works for assets with urls that are returned per-asset, like in Giphy
            return url;
        }
        else if(icon.isEmoji() && useSmallEmoji){
			return this.emojiUrl + "/" + icon.getFileName();
		}
		else if (displayBig){
			return this.bigIconsUrl + "/" + icon.getFileName();
		}
		else if(displayBanner){
			return this.bannerUrl + "/" + icon.getFileName();
		}
		return this.assetsUrl + "/" + icon.getFileName();
	}

	public boolean useSmallIcon(IconData icon) {
		return icon.isEmoji() && useSmallEmoji;
	}

	public boolean canBeDisplayedBig(IconData icon) {
		// Unless the icon needs to be displayed small then we assume it can be displayed big
		// TODO: Emoji are a special case, I guess even in places where they should be displayed normal size,
		// they would not want them to be displayed big. So maybe need to add a condition here which checks that
		// the icon is not an emoji..
		return !useSmallIcon(icon);
	}
}
