package com.aniways.analytics.models;

import java.util.Calendar;

import org.json.JSONObject;

public class Alias extends BasePayload {
	
	public final static String TYPE = "alias";
	
	private final static String FROM_KEY = "from";
	private final static String TO_KEY = "to";
	
	public Alias (JSONObject obj) {
		super(obj);
	}
	
	public Alias(String from,
				 String to, 
				 Calendar timestamp,
				 Context context) {
		
		super(timestamp, context);

		put("type", TYPE);
		
		setFrom(from);
		setTo(to);
	}

	public String getFrom() {
		return this.optString(FROM_KEY, null);
	}
	
	public void setFrom(String from) {
		this.put(FROM_KEY, from);
	}
	
	public String getTo() {
		return this.optString(TO_KEY, null);
	}
	
	public void setTo(String to) {
		this.put(TO_KEY, to);
	}

}
