package com.aniways.analytics.info;

import com.aniways.Log;
import com.aniways.analytics.models.EasyJSONObject;

import org.json.JSONObject;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class Wifi implements Info<JSONObject> {

	private static final String TAG = "AniwaysAnalyticsContextWifi";

	@Override
	public String getKey() {
		return "wifi";
	}

	@Override
	public JSONObject get(Context context) {

		EasyJSONObject object = new EasyJSONObject();

		try{

			if (PackageManager.PERMISSION_GRANTED == context.checkCallingOrSelfPermission(Manifest.permission.ACCESS_NETWORK_STATE)) {
				ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
				NetworkInfo wifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

				object.put("available", wifi.isAvailable());
				object.put("connected", wifi.isConnected());
			}
		}
		catch (Exception ex) {
			Log.eToGaOnly(true, TAG, "Caught Exception in Location info", ex);
		}

		return object;
	}

}
