package com.aniways.analytics.info;

import com.aniways.Log;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.service.utils.AniwaysServiceUtils;

import org.json.JSONObject;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;

public class Build implements Info<JSONObject> {

	private static final String TAG = "AniwaysAnalyticsContextBuild";
	private static final String UNKNOWN = "unknown";

	@Override
	public String getKey() {
		return "build";
	}

	@Override
	public JSONObject get(Context context) {
		EasyJSONObject build = new EasyJSONObject();

		try {
			PackageInfo packageInfo = null;

			PackageManager pm = context.getPackageManager();
			if(pm != null){
				String packageName = context.getPackageName();
				if(packageName != null){
					try{
						packageInfo = pm.getPackageInfo(packageName, 0);
					}
					catch (NameNotFoundException e) {
						Log.eToGaOnly(true, TAG, "Could not get package name", e);
					}
				}
			}
			
			String appName = getAppName(context);

			build.put("appName", appName == null ? UNKNOWN : appName);
			build.put("packageName", packageInfo == null ? UNKNOWN : packageInfo.packageName);
			build.put("code", packageInfo == null ? UNKNOWN : packageInfo.versionCode);
			build.put("name", packageInfo == null ? UNKNOWN : packageInfo.versionName);
			build.put("aniwaysVersion", AniwaysServiceUtils.SDK_VERSION);
			build.put("appId", AniwaysPrivateConfig.getInstance().appId);

		} catch (Exception ex) {
			Log.eToGaOnly(true, TAG, "Caught Exception in Build info", ex);
		}

		return build;
	}
	
	public static String getAppName(Context context){
		ApplicationInfo appInfo = null;
		PackageManager pm = context.getPackageManager();
		if(pm != null){
			String packageName = context.getPackageName();
			if(packageName != null){
				try {
					appInfo = pm.getApplicationInfo(packageName, 0);
				} catch (final NameNotFoundException e) {
					Log.eToGaOnly(true, TAG, "Could not get package name", e);
				}
			}
		}
		
		CharSequence appName = (appInfo == null ? null : pm.getApplicationLabel(appInfo));
		if(appName == null){
			return null;
		}
		return appName.toString();
	}

}
