package com.aniways.analytics.db;

import com.aniways.Log;
import com.aniways.analytics.models.Alias;
import com.aniways.analytics.models.BasePayload;
import com.aniways.analytics.models.Identify;
import com.aniways.analytics.models.Screen;
import com.aniways.analytics.models.Timing;
import com.aniways.analytics.models.Track;

import org.json.JSONException;
import org.json.JSONObject;

public class JsonPayloadSerializer {
	
	private static final String TAG = "AniwaysJsonPayloadSerializer";

	public String serialize(BasePayload payload) {
		return payload.toString();
	}

	public BasePayload deseralize(String str) {
		
		JSONObject obj;
		
		try {
			obj = new JSONObject(str);
			
			String type = obj.getString("type");
			
			if (type.equals(Identify.TYPE)) {
				return new Identify(obj);
			} else if (type.equals(Track.TYPE)) {
				return new Track(obj);
			} else if (type.equals(Alias.TYPE)) {
				return new Alias(obj);
			} else if (type.equals(Screen.TYPE)) {
				return new Screen(obj);	
			} else if (type.equals(Timing.TYPE)) {
				return new Timing(obj);	
			} else if (type.equals(com.aniways.analytics.models.Error.TYPE)) {
				return new com.aniways.analytics.models.Error(obj);	
			} else if (type.equals(com.aniways.analytics.models.Log.TYPE)) {
				return new com.aniways.analytics.models.Log(obj);
			} else {
				
			}
		} catch (JSONException e) {
			Log.eToGaOnly(true, TAG, "Failed to convert json to base payload: " + str, e);
		}
		
		return null;
	}

}
