package com.aniways;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;

import com.aniways.data.Phrase;

public class IconDataForInteractive extends IconData{

	private static final String TAG = "AniwaysIconDataForInteractive";
	private String mExternalActivityPackage;
	private String mExternalWebsite;

	// TODO: Make sure this can also be animated in the icon info span and not only in NetworkImageView..
	public IconDataForInteractive(int id, String family, boolean isLocked, Phrase primaryPhrase, boolean isEmoji, String unicodeRepresentation, String externalActivityPackage, String externalWebsite, boolean isAnimated){
		super(id, family, isLocked, primaryPhrase, unicodeRepresentation, (isEmoji? AssetType.Emoji : AssetType.Emoticons), IAniwaysImageSpan.AssetProvider.Aniways, isAnimated);

		if(TextUtils.isEmpty(externalActivityPackage)&& TextUtils.isEmpty(externalWebsite)){
			Log.e(true, TAG, "Both vars are null");
		}

		mExternalActivityPackage = externalActivityPackage;
		mExternalWebsite = externalWebsite;
	}

	@Override
	public boolean hasExternalData() {
		return true;
	}

	@Override
	public String getExternalActivityPackage(){
		return mExternalActivityPackage;
	}

	@Override
	public String getExternalWebsite(){
		return mExternalWebsite;
	}

	@Override
	public AniwaysImageSpan createImageSpan(Object data, Phrase phrase,
			IAniwaysImageSpan.IconSelectionOrigin selectionOrigin, Context context, int width, int height,
			IIconInfoDisplayer iconInfoDisplayer) {
		if(iconInfoDisplayer instanceof AniwaysTextView){

			return new AniwaysInteractiveImageSpan((Bitmap)data, phrase, this, selectionOrigin, context, width, height, ((AniwaysTextView)iconInfoDisplayer).getText());
		} else {
			return new AniwaysImageSpan((Bitmap) data, phrase, this, selectionOrigin, context, width, height);
		}
	}

}
