/**
 * 
 */
package com.aniways;

import java.util.HashSet;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;

import com.aniways.AniwaysMessageListViewItemWrapperLayout.OnSetTextListener;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.data.AniwaysConfiguration.Verbosity;
import com.aniways.data.AniwaysStatics;

/**
 * @author Shai
 *
 */
public class AniwaysTextView extends TextView implements IAniwaysGestureResponder, IAniwaysTextEditor, IIconInfoDisplayer, IAniwaysTextContainer{
	private AniwaysEditTextAndTextViewCommonPart mAniwaysEditTextAndTextViewerCommonPart;
	private static final String TAG = "AniwaysTextView";
	private static int sSetTextTimingCounter = 0;
	private AniwaysIconInfoDisplayer mIconInfoDisplayer;
	public boolean mUseSmallIcons = false;
	private int mOldTextHashCode = -1;
	private boolean mIconsClickable = true;

	public AniwaysTextView(Context paramContext)
	{
		this(paramContext, null);
	}

	public AniwaysTextView(Context context, AttributeSet attributeSet)
	{
		super(context, attributeSet);
		if(!this.isInEditMode()){
			mAniwaysEditTextAndTextViewerCommonPart = new AniwaysEditTextAndTextViewCommonPart(this);
			mIconInfoDisplayer = new AniwaysIconInfoDisplayer();
			init(attributeSet);
		}
	}

	public AniwaysTextView(Context context, AttributeSet attrs, int defStyle){
		super(context, attrs, defStyle);
		if(!this.isInEditMode()){
			mAniwaysEditTextAndTextViewerCommonPart = new AniwaysEditTextAndTextViewCommonPart(this);
			mIconInfoDisplayer = new AniwaysIconInfoDisplayer();
			init(attrs);
		}
	}

	private void init(AttributeSet attrs) {

		try{

			if(attrs == null){
				return;
			}
			TypedArray a = getContext().obtainStyledAttributes(attrs, R.styleable.AniwaysSmallIcons);
			for (int i = 0; i < a.getIndexCount(); ++i) {
				int attr = a.getIndex(i);
				if (attr == R.styleable.AniwaysSmallIcons_aniways_use_small_icons) {
					this.mUseSmallIcons = a.getBoolean(attr, false);
				}
				else if (attr == R.styleable.AniwaysSmallIcons_aniways_icons_clickable) {
					this.mIconsClickable = a.getBoolean(attr, true);
				}
			}
			a.recycle();
		}
		catch (Throwable e) {
			Log.e(true, TAG, "Caught Exception in Ctor", e);
		}
	}


	// Supports copy-paste of images
	@Override
	public boolean onTextContextMenuItem(int id){
		try{
			return mAniwaysEditTextAndTextViewerCommonPart.onTextContextMenuItem(id);
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in onTextContextMenuItem. Id is: " + id, ex);
			return true;
		}
	}

	// Recognize the back button press close the suggestion or icon info popup
	@Override
	public boolean dispatchKeyEventPreIme(KeyEvent event){
		try{
			return mAniwaysEditTextAndTextViewerCommonPart.dispatchKeyEventPreIme(event);
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in dispatchKeyEventPreIme. Event is: " + event, ex);
			return true;
		}
	}

	@Override
	public boolean onTouchEvent(MotionEvent event){
		try{
			if(!this.mIconsClickable){
				Log.v(TAG, "Icons are not clickable so passing touch event to super");
				return super.onTouchEvent(event);
			}
			
			return mAniwaysEditTextAndTextViewerCommonPart.onTouchEvent(event);
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in onTouchEvent. Event is: " + event, ex);
			return true;
		}
	}

	@Override
	public void displayIconInfo(AniwaysInternalIconInfoSpan infoSpan, IAniwaysTextContainer textContainer) {
		this.mIconInfoDisplayer.displayIconInfo(infoSpan, textContainer);
	}

	@Override
	public void onSingleTap(MotionEvent event) {
		try{
			// If user clicked on an AniwaysSuggestionSpan then call its onClick (this is not
			// called by the EditText because it doesn't receive these events in order for it
			// not to display the paste menu and also to avoid the bug where if the span is
			// at the end of the input and the user clicks somewhere after it then the EditText treats it
			// like a click on the span itself
			Log.d(TAG, "Single tap detected on an AniwaysTextView icon");
			int pos = this.mAniwaysEditTextAndTextViewerCommonPart.getPositionOfTouchEventInText(event);
			if (pos != -1){
				IAniwaysIconInfoSpan[] infoSpans = getText().getSpans(pos, pos, IAniwaysIconInfoSpan.class);
				if (infoSpans.length != 0) {
					long eventTime = -1;
					if(event.getAction() == MotionEvent.ACTION_DOWN){
						eventTime = event.getEventTime();
					}
					infoSpans[0].onClick(this.mAniwaysEditTextAndTextViewerCommonPart, eventTime);
				}
			}
			else{
				Log.d(TAG, "single tap detected on an AniwaysTextView icon, but position is -1!!!");
			}
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in onSingleTap. Event is: " + event, ex);
		}
	}

	@Override
	public boolean callSuperOnTextContextMenuItem(int id) {
		return super.onTextContextMenuItem(id);		
	}

	@Override
	public boolean callSuperOnTouchEvent(MotionEvent event) {
		return super.onTouchEvent(event);
	}

	@Override
	public boolean callSuperDispatchKeyEventPreIme(KeyEvent event) {
		return super.dispatchKeyEventPreIme(event);
	}

	@Override
	public Editable getText() {
		if(!this.isInEditMode()){
			AniwaysStatics.makeSureAniwaysIsInitialized(false);
		}

		CharSequence text = super.getText(); 

		if(text instanceof Editable){
			return (Editable) text;
		}

		if(!TextUtils.isEmpty(text)){
			Log.e(true, TAG, "The text was not ediable: " + text);
		}

		return Editable.Factory.getInstance().newEditable(text);
	}

	@Override
	public void setText(CharSequence text, boolean justCallSuper) {
		if(justCallSuper){
			super.setText(text,BufferType.EDITABLE);
		}
		else{
			setText(text, BufferType.EDITABLE);
		}
	}

	// Make sure text is always editable (to manipulate icon insertions, etc.)
	// TODO: make sure that this hack will always hold (in all backward and forward Android versions)
	@Override
	public void setText(CharSequence text, BufferType type) {
		if(this.isInEditMode()){
			super.setText(text,type);
			return;
		}

		AniwaysStatics.makeSureAniwaysIsInitialized(false);

		try{
			
			Log.d(TAG, "Setting text: " + text);
			
			if(text == null){
				text = "";
			}

			Editable oldText = null;
			boolean oldTextWasNull = false;
			try{
				oldText = this.getText();
			}
			// This is because that during construction there is a call to this method
			// and there is an Android bug that causes this Exception 
			catch (ClassCastException ex)
			{
				oldTextWasNull = true;
				oldText = Editable.Factory.getInstance().newEditable("");
				Log.v(TAG, "set text cast exception caught");
			}

			int newHash = text.hashCode();
			if(!oldTextWasNull && oldText != null && newHash == this.mOldTextHashCode && mOldTextHashCode != -1){
				Log.v(TAG, "Trying to set the same text, so doing nothing..");
				// TODO: Find out why if the below is uncommented then we get an null pointer exception in Telegram in the boring layout
				//return;
			}
			mOldTextHashCode = newHash;

			long startTime = System.currentTimeMillis();
			super.setText(text, BufferType.EDITABLE);
			
			if(mAniwaysEditTextAndTextViewerCommonPart != null){
				mAniwaysEditTextAndTextViewerCommonPart.onSetText(this.getText(), oldText);
			}
			if (AnalyticsReporter.isInitialized()){
				//report timing in only 1 out of 10 cases, for performance sake when there are lots of settings to do (when building the wall for instance)
				if(sSetTextTimingCounter % 30 == 0){
					AnalyticsReporter.ReportTiming(Verbosity.Statistical, startTime, "Performance", "Set Text To Label", String.valueOf(text.length()), TAG, "num chars");
				}
				sSetTextTimingCounter++;
			}
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in setText. Text is: " + text, ex);
		}
	}

	/**
	 * Convenience for {@link android.text.Selection#setSelection(android.text.Spannable, int, int)}.
	 */
	public void setSelection(int start, int stop) {
		try{
			Selection.setSelection((Editable)getText(), start, stop);
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in setSelection. start is: " + start + ". Stop is: " + stop, ex);
		}
	}

	@Override
	public void removeTextChangedListener(TextWatcher watcher){
		this.mAniwaysEditTextAndTextViewerCommonPart.removeTextChangedListener(watcher);
	}

	@Override
	public void addTextChangedListener(TextWatcher watcher){
		this.mAniwaysEditTextAndTextViewerCommonPart.addTextChangedListener(watcher);
	}

	/**
	 * Convenience for {@link android.text.Selection#setSelection(android.text.Spannable, int)}.
	 */
	public void setSelection(int index) {
		try{
			Selection.setSelection((Editable)getText(), index);
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in setSelection. Index is: " + index, ex);
		}
	}

	/**
	 * Convenience for {@link android.text.Selection#selectAll}.
	 */
	public void selectAll() {
		try{
			Selection.selectAll((Editable)getText());
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in selectAll", ex);
		}
	}

	/**
	 * Convenience for {@link android.text.Selection#extendSelection}.
	 */
	public void extendSelection(int index) {
		try{
			Selection.extendSelection((Editable)getText(), index);
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught excedption in extendSelection. Index is: " + index, ex);
		}
	}

	/*
	@Override
	protected MovementMethod getDefaultMovementMethod() {
		return ArrowKeyMovementMethod.getInstance();
	}
	 */

	@Override
	public void callSuperSetSelection(int start, int stop) {
		this.setSelection(start, stop);

	}

	@Override
	public void callSuperSetSelection(int index) {
		this.setSelection(index);

	}

	@Override
	public void callSuperExtendSelection(int index) {
		this.extendSelection(index);

	}

	@Override
	public void callSuperSelectAll() {
		this.selectAll();

	}

	@Override
	public void callSuperRemoveTextChangedListener(TextWatcher watcher){
		super.removeTextChangedListener(watcher);
	}

	@Override
	public void callSuperAddTextChangedListener(TextWatcher watcher){
		super.addTextChangedListener(watcher);
	}

	@Override
	public IAniwaysTextWatcher addTheAniwaysTextWatcher() {
		return this.mAniwaysEditTextAndTextViewerCommonPart.addTheAniwaysTextWatcher();
	}

	@Override
	public IAniwaysTextWatcher removeTheAniwaysTextWatcher() {
		return this.mAniwaysEditTextAndTextViewerCommonPart.removeTheAniwaysTextWatcher();
	}

	@Override
	protected void onDetachedFromWindow() {
		this.mAniwaysEditTextAndTextViewerCommonPart.onDetachFromWindow();

		super.onDetachedFromWindow();
	}

	@Override
	protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
		super.onLayout(changed, left, top, right, bottom);

		this.mAniwaysEditTextAndTextViewerCommonPart.onLayoutCalled();
	}

	public void setDoNotShowIcons(boolean dontShow){
		this.mAniwaysEditTextAndTextViewerCommonPart.mDoNotShowIcons = dontShow;
	}

	public void setUseSmallIcons(boolean use) {
		this.mUseSmallIcons = use;
	}
	
	public void setIconsClickable(boolean clickable){
		this.mIconsClickable = clickable;
	}

	@Override
	public void registerSetTextListener(OnSetTextListener textChangedListener) {
		this.mAniwaysEditTextAndTextViewerCommonPart.registerSetTextListener(textChangedListener);
	}
	
	@Override
	public void unregisterSetTextListener(OnSetTextListener listener) {
		this.mAniwaysEditTextAndTextViewerCommonPart.unregisterSetTextListener(listener);
		
	}

	@Override
	public Point getPointOfPositionInText(int position, boolean fromTop) {
		return this.mAniwaysEditTextAndTextViewerCommonPart.getPointOfPositionInText(position, fromTop);
	}

	@Override
	public View getView() {
		return this;
	}

	@Override
	public AniwaysDynamicImageSpansContainer getDynamicImageSpansContainer() {
		return this.mAniwaysEditTextAndTextViewerCommonPart.getDynamicImageSpansContainer();
	}

	@Override
	public void removeTextWatchers() {
		this.mAniwaysEditTextAndTextViewerCommonPart.removeTextWatchers();
		
	}

	@Override
	public void addBackTheTextWatchers() {
		this.mAniwaysEditTextAndTextViewerCommonPart.addBackTheTextWatchers();
		
	}

	@Override
	public void onLoadedImageSuccessfuly() {
		this.mAniwaysEditTextAndTextViewerCommonPart.onLoadedImageSuccessfuly();
		
	}

	@Override
	public void onErrorLoadingImage() {
		this.mAniwaysEditTextAndTextViewerCommonPart.onErrorLoadingImage();
		
	}

	@Override
	public IIconInfoDisplayer getIconInfoDisplayer() {
		return this;
	}

}
