package com.aniways;

import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.AnalyticsReporter.ExternalDataType;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysStoreManager;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;

//not inheriting clickable span so it will not look like a link
public class AniwaysExternalIconInfoSpan implements IAniwaysIconInfoSpan
{
	private static final String TAG = "AniwaysExternalIconInfoSpan";
	private long dismissEventTime = -2;
	private Context mContext;
	private String mExternalActivityPackage;
	private String mExternalWebsite;
	private IconData iconData;

	public AniwaysExternalIconInfoSpan(IconData icon, Context context) {
		this.mContext = context;
		this.mExternalActivityPackage = icon.getExternalActivityPackage();
		this.mExternalWebsite = icon.getExternalWebsite();
		this.iconData = icon;
	}

	public void onClick(IAniwaysTextContainer textContainer, long clickEventTime) {
		try{
			if(dismissEventTime != clickEventTime){
				if(!TextUtils.isEmpty(mExternalActivityPackage)){
					Intent launchIntent = mContext.getPackageManager().getLaunchIntentForPackage(mExternalActivityPackage);
					if(launchIntent != null){
						Log.i(TAG, "Starting external application: " + mExternalActivityPackage);
						GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application", mExternalActivityPackage, iconData.getFileName(), 0);
						AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{iconData}, AniwaysStoreManager.isIconUnlocked(iconData), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, mExternalActivityPackage, ExternalDataType.openApp, IAniwaysImageSpan.ImageSpanMetadata.Empty);
						mContext.startActivity(launchIntent);
					} else {
						try {
							Log.i(TAG, "External application package " + mExternalActivityPackage + " not found, trying to start google market");
							GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application on Google market", mExternalActivityPackage, iconData.getFileName(), 0);
							AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{iconData}, AniwaysStoreManager.isIconUnlocked(iconData), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, "mExternalActivityPackage", ExternalDataType.openGooglePlay, IAniwaysImageSpan.ImageSpanMetadata.Empty);
							mContext.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + mExternalActivityPackage)));
						} catch (android.content.ActivityNotFoundException anfe) {
							Log.i(TAG, "Google market not found on device starting browser, openApp: " + mExternalActivityPackage);
							GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External application on browser", mExternalActivityPackage, iconData.getFileName(), 0);
							AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{iconData}, AniwaysStoreManager.isIconUnlocked(iconData), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, "Browser:" + mExternalActivityPackage, ExternalDataType.openGooglePlayBrowser, IAniwaysImageSpan.ImageSpanMetadata.Empty);
							mContext.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + mExternalActivityPackage)));
						}
					}
				} else if(!TextUtils.isEmpty(mExternalWebsite)){
					Intent i = new Intent(Intent.ACTION_VIEW);
					i.setData(Uri.parse(mExternalWebsite));
					Log.i(TAG, "Starting browser with url: " + mExternalWebsite);
					GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Display External link", mExternalWebsite, iconData.getFileName(), 0);
					AnalyticsReporter.reportPhrasesEvent(AnalyticsReporter.PhrasesEventAction.displayExternalInfo, null, null, new IconData[]{iconData}, AniwaysStoreManager.isIconUnlocked(iconData), null, false, null, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, mExternalWebsite, ExternalDataType.openWebsiteInBrowser, IAniwaysImageSpan.ImageSpanMetadata.Empty);
					
					mContext.startActivity(i);

				}
			} 
		}
		catch(Throwable ex){
			// TODO: fix this!!
			Log.e(true, TAG, "Caught exception in onClick", ex);
		}
	}

	public void setDismissEventTime(long dismissEventTime) {
		this.dismissEventTime = dismissEventTime;
	}
}
