/**
 * 
 */
package com.aniways;

import java.util.HashSet;

import android.graphics.Point;
import android.graphics.Rect;
import android.support.v4.view.GestureDetectorCompat;
import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;

import com.aniways.AniwaysMessageListViewItemWrapperLayout.OnSetTextListener;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.data.AniwaysBackendSyncChecker;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysPrivateConfig.IconEncodingMethod;
import com.aniways.data.AniwaysStatics;
import com.aniways.data.JsonParser;
import com.aniways.quick.action.QuickAction;

/**
 * @author Shai
 *
 */
class AniwaysEditTextAndTextViewCommonPart implements IAniwaysTextContainer{
	private TextView mTextView;
	private boolean mIsEditText;
	private static final String TAG = "AniwaysEditTextAndTextViewCommonPart";
	private GestureDetectorCompat mGestureDetector;
	private AniwaysGestureListener mGestureListener;
	//private boolean mSuppressLongClick;

	private IAniwaysTextWatcher mTextWatcher;
	private QuickAction mQuickAction;
	private boolean mTextWatcherEnabled = false;
	boolean mDoNotShowIcons = false;
	private AniwaysDynamicImageSpansContainer mDynamicImageSpansContainer = null;
	private HashSet<OnSetTextListener> mSetTextListeners = new HashSet<OnSetTextListener>();

	public AniwaysEditTextAndTextViewCommonPart(TextView textView){
		AniwaysStatics.makeSureAniwaysIsInitialized(false);

		mTextView = textView;
		mIsEditText = mTextView instanceof AniwaysEditText;

		// Send analytics data to GA
		if(mIsEditText){
			//AnalyticsReporter.reportView("EditText", true);
			AnalyticsReporter.reportNewSession();
		}
		else{
			//AnalyticsReporter.reportView("TextView", false);
		}

		mGestureListener = new AniwaysGestureListener((IAniwaysGestureResponder)mTextView);
		mGestureDetector = new GestureDetectorCompat(mTextView.getContext(), this.mGestureListener);	

		mDynamicImageSpansContainer = new AniwaysDynamicImageSpansContainer(this);

		// Used to suppress long clicks to disable the copy-paste menu if clicking on a suggestion
		/*
		mTextView.setOnLongClickListener(new View.OnLongClickListener() {
			@Override
			public boolean onLongClick(View v) {
				return mSuppressLongClick;
			}
		});
		 */

		// Init text Watcher
		if (mIsEditText){
			this.mTextWatcher = new AniwaysEditTextTextWatcher((AniwaysEditText) mTextView);
			this.addTheAniwaysTextWatcher();
		}
	}

	// Support copy-paste of images
	boolean onTextContextMenuItem(int id) {
		// Selection context mode
		//final int ID_SELECT_ALL = android.R.id.selectAll;
		final int ID_CUT = android.R.id.cut;
		final int ID_COPY = android.R.id.copy;
		final int ID_PASTE = android.R.id.paste;
		// Context menu entries
		// TODO: find out exactly what this is and see if I need to address it..
		//final int ID_COPY_URL = android.R.id.copyUrl;
		//final int ID_SELECTION_MODE = android.R.id.selectTextMode;

		int min = 0;
		int max = mTextView.getText().length();

		int selStart = 0;
		int selEnd = 0;
		if (mTextView.isFocused()) {
			selStart = mTextView.getSelectionStart();
			selEnd = mTextView.getSelectionEnd();

			min = Math.max(0, Math.min(selStart, selEnd));
			max = Math.max(0, Math.max(selStart, selEnd));
		}
		switch (id) {
		case ID_PASTE:
			this.removeTheAniwaysTextWatcher();
			boolean result = ((IAniwaysTextEditor)mTextView).callSuperOnTextContextMenuItem(id);

			// TODO: do this to the inserted text only and not all of it
			JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
			boolean useSmallIcons = false;
			if(mTextView instanceof AniwaysTextView){
				useSmallIcons =((AniwaysTextView)mTextView).mUseSmallIcons;
			}
			if(mTextView instanceof ISuggestionDisplayer){
				// TODO: do not do the decode when any text watcher is watching..
				AniwaysIconConverter.decodeMessage(mTextView.getContext(), (Editable) mTextView.getText(), (ISuggestionDisplayer)mTextView, null, this, parser, IconEncodingMethod.Invisible, useSmallIcons, true, false, false);
			}
			else if(isIconInfoDisplayer()){
				AniwaysIconConverter.decodeMessage(mTextView.getContext(), (Editable) mTextView.getText(), null, (IIconInfoDisplayer)mTextView, this, parser, IconEncodingMethod.Invisible, useSmallIcons, true, false, false);
			}
			else{
				Log.e(true, TAG, "mTextView is not a suggestion diplayer and not icon info displayer");
			}
			this.addTheAniwaysTextWatcher();
			return result;
		case ID_CUT:
			return copyOrCut(id, min, max, selStart, selEnd, false);

		case ID_COPY:		
			return copyOrCut(id, min, max, selStart, selEnd, true);
		}

		return ((IAniwaysTextEditor)mTextView).callSuperOnTextContextMenuItem(id);
	}

	// Recognize the back button press close the suggestion or icon info popup
	boolean dispatchKeyEventPreIme(KeyEvent event) {
		Log.d(TAG, "In dispatch key event pre ime. Key is: " + event.getAction());

		if (event.getKeyCode() == KeyEvent.KEYCODE_BACK) {
			if (event.getAction() == KeyEvent.ACTION_DOWN && event.getRepeatCount() == 0) {
				// Tell the framework to start tracking this event.
				mTextView.getKeyDispatcherState().startTracking(event, this);
				return true;
			} 
			else if (event.getAction() == KeyEvent.ACTION_UP) {
				mTextView.getKeyDispatcherState().handleUpEvent(event);
				if (event.isTracking() && !event.isCanceled()) {
					return onBack();
				}
				else{
					return onBack();
				}
			}
		} 
		return ((IAniwaysTextEditor)mTextView).callSuperDispatchKeyEventPreIme(event);
	}

	boolean onTouchEvent(MotionEvent event) {

		Log.d(TAG, "in on touch event: " + event.getAction());
		this.mGestureDetector.onTouchEvent(event);

		int pos = getPositionOfTouchEventInText(event);
		if (pos != -1){
			AniwaysSuggestionSpan[] suggestions = ((Editable)mTextView.getText()).getSpans(pos, pos, AniwaysSuggestionSpan.class);
			IAniwaysIconInfoSpan[] infos = ((Editable)mTextView.getText()).getSpans(pos, pos, IAniwaysIconInfoSpan.class);

			//this.mSuppressLongClick = false;
			if (suggestions.length != 0 || infos.length != 0) {
				if(this.mGestureListener.ismRecordEvents()){
					this.mGestureListener.recordEvent(event);
				}
				//TODO: if there are more relevant event types (like Keypad_center, etc.) that need addressing. 
				//- see reference in the TextView source code
				if(event.getAction() == MotionEvent.ACTION_DOWN)
				{
					// We set to record the event here after the event has been processed and not recorded
					// because when we later play back the recorded events we don't want this event to be processed
					// twice.
					if(!this.mGestureListener.ismRecordEvents()){
						this.mGestureListener.setRecordEvents(true);
						this.mGestureListener.recordEvent(event);
					}
				}
				if(event.getAction() == MotionEvent.ACTION_UP)
				{
					// disable the copy-paste menu if clicking on a suggestion
					// this.mSuppressLongClick = true;
					//return true;
				}
				return true;
			}
			else{
				this.mGestureListener.setRecordEvents(false);
			}
		}
		return ((IAniwaysTextEditor)mTextView).callSuperOnTouchEvent(event);

	}

	// Returns which character position is touched
	int getPositionOfTouchEventInText(MotionEvent event){
		Log.d(TAG, "event x: " + event.getX() + " y: " + event.getY());
		if (Utils.isAndroidVersionAtLeast(14)){
			// TODO: use this, but incoporate check that if the touch event is after the line ended we will not return the position of the last char as is done below for the lower versions
			//return mTextView.getOffsetForPosition(event.getX(), event.getY());
		}

		int x = (int) event.getX();
		int y = (int) event.getY();

		x -= mTextView.getTotalPaddingLeft();
		y -= mTextView.getTotalPaddingTop();

		x += mTextView.getScrollX();
		y += mTextView.getScrollY();

		Layout layout = mTextView.getLayout();
		// This could happen immediately after changing modes from vertical to horizontal, for instance..
		if (layout == null){
			Log.w(false, TAG, "Reeived null layout for TextView or EditText, so not calculating position of touch event in text and returning -1");
			return -1;
		}
		int line = layout.getLineForVertical(y);

		int off = layout.getOffsetForHorizontal(line, x);

		// This makes sure that if the touch event is after the line ended we will not return the position of the last char
		int paragraphDirection = layout.getParagraphDirection(line);
		int maxLineRight = (int) layout.getLineWidth(line);
		//Log.d(TAG, "x: " + x + " y: " + y + " max line right: " + maxLineRight);
		// TODO: make sure that this condition is enough because there is also paragraph orientation which can contradict the direction..
		if(paragraphDirection == Layout.DIR_LEFT_TO_RIGHT){

		}
		else if (paragraphDirection == Layout.DIR_RIGHT_TO_LEFT){
			Rect bounds = new Rect();
			layout.getLineBounds(line, bounds);
			// TODO: this calc is not always true (scroll, right hand side paddings, etc..
			x = bounds.width() - x; 
			Log.d(TAG, "line bounds: " + bounds.toString());
			Log.d(TAG, "new X: " + x);
		}
		if(x<=maxLineRight+25)
		{
			return off;
		}
		return -1;
	}

	@Override
	public Spannable getText() {
		return (Spannable) this.mTextView.getText();
	}

	/** Return the point (in pixels) of the received char position as it is displayed
	 * relative to the upper left corner of the widget, or lower left if fromTop == false.
	 * It accounts for scroll position and paddings
	 * !! Be careful, it can return null!!
	 **/
	@Override
	public Point getPointOfPositionInText(int position, boolean fromTop) {
		// TODO: what if right to left
		int leftPadding = mTextView.getTotalPaddingLeft();
		int topPadding = mTextView.getTotalPaddingTop();

		Layout layout = mTextView.getLayout();

		if(layout == null){
			// This could happen immediately after changing modes from vertical to horizontal, for instance..
			Log.w(false, TAG, "Reeived null layout for TextView or EditText, so not calculating point in text and retuirning null");
			return null;
		}

		int line = layout.getLineForOffset(position);
		int baseline = layout.getLineBaseline(line);

		float x = layout.getPrimaryHorizontal(position);
		x += leftPadding;
		x -= mTextView.getScrollX();

		float y = baseline;
		y += topPadding;
		y -= mTextView.getScrollY();
		if(fromTop){
			int ascent = layout.getLineAscent(line);
			y += ascent;
		}
		else{
			int viewHeight = mTextView.getHeight(); 
			y = viewHeight - y - mTextView.getTotalPaddingBottom();
		}


		Point point = new Point((int)Math.round(x), (int)Math.round(y));
		return point;
	}

	@Override
	public View getView() {
		return this.mTextView;
	}

	// Perform the copy or cut action from the copy-paste menu in order to support copying icons
	private boolean copyOrCut(int id, int min, int max, int selStart, int selEnd, boolean copy) {
		Log.v(TAG, "copy or cut. id: " + id + " min: " + min + " max: " + max + " selStart: " + selStart + " selEnd: " + selEnd + " copy: " + copy );
		Editable unchanged = Editable.Factory.getInstance().newEditable(mTextView.getText());

		// Need to remove the listener before extracting dirty, otherwise, changing dirty will call the watcher..
		this.removeTheAniwaysTextWatcher();
		Editable dirty = (Editable) mTextView.getText();

		// The selection might contain part of a picture - this is bad for the encoding, so we fix the selection to cover all the picture
		// for performance: only take the spans at the 2 edges..
		IAniwaysImageSpan[] imageSpansStart = dirty.getSpans(min, min, IAniwaysImageSpan.class);
		IAniwaysImageSpan[] imageSpansEnd = dirty.getSpans(max, max, IAniwaysImageSpan.class);
		if(imageSpansStart != null && imageSpansStart.length > 0){
			for(IAniwaysImageSpan span : imageSpansStart){
				int e = dirty.getSpanEnd(span);
				if(e == min){
					// This span is not partially selected, it is only adjacent
					continue;
				}
				int s = dirty.getSpanStart(span);
				if(s < min){
					min = s;
				}
			}
		}
		if(imageSpansEnd != null && imageSpansEnd.length > 0){
			for(IAniwaysImageSpan span : imageSpansEnd){
				int s = dirty.getSpanStart(span);
				if(s == max){
					// This span is not partially selected, it is only adjacent
					continue;
				}
				
				int e = dirty.getSpanEnd(span);
				if(e > max){
					max = e;
				}
			}
		}

		// Remove the Aniways marker spans from the selected part, so the color will not be copied over..
		IAniwaysWordMarkerSpan[] spansToRemove = dirty.getSpans(min, max, IAniwaysWordMarkerSpan.class);
		if(spansToRemove != null && spansToRemove.length > 0){
			for(IAniwaysWordMarkerSpan spanToRemove : spansToRemove){
				dirty.removeSpan(spanToRemove);
			}
		}

		// Depending on config - the icons will be either encoded as code or inside URL
		//TODO: add config specifically for how to encode in copy or cut and not use the general config..
		String replacement = AniwaysIconConverter.encodeMessage((Spannable)dirty.subSequence(min, max), mTextView.getContext(), false, IconEncodingMethod.Invisible, true);

		// I do the below instead of dirty.replace(min, max, replacement); because of bug in older android vers (api 8)
		// TODO: fix this!!!!!

		CharSequence suffix = dirty.subSequence(max, dirty.length());
		dirty.delete(min, dirty.length());
		dirty.append(replacement);
		dirty.append(suffix);
		setSelection(min, min + replacement.length());
		if(!copy){
			// Need to set the marker spans after that paste..
			this.addTheAniwaysTextWatcher();
		}
		boolean result = ((IAniwaysTextEditor)mTextView).callSuperOnTextContextMenuItem(id);
		if(copy){
			((IAniwaysTextEditor)mTextView).setText(unchanged, true);
			this.setSelection(selStart, selEnd);
			// if not copy then already added
			this.addTheAniwaysTextWatcher();
		}
		return result;
	}

	private boolean onBack() {
		// This is because this method will be called only on 1 view, but we need to close them all..
		return Aniways.closeAllOpenedPopups();

	}

	// inserts icons where needed and clears needed spans
	void onSetText(CharSequence newText, Spannable oldText) {
		// Call liteners
		if(mSetTextListeners != null){
			for(OnSetTextListener listener : mSetTextListeners){
				listener.onSetText(newText);
			}
		}

		if(newText.length() == 0 || newText == oldText){
			return;
		}

		// Cannot use the newText var since it is the text object before the call to super.setText(), which creates a new instance
		Editable text = (Editable)this.mTextView.getText();

		this.removeTheAniwaysTextWatcher();
		JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
		boolean useSmallIcons = false;
		if(mTextView instanceof AniwaysTextView){
			useSmallIcons =((AniwaysTextView)mTextView).mUseSmallIcons;
		}
		if(mTextView instanceof ISuggestionDisplayer){
			Log.d(TAG, "Decode start");
			// This was already done above if oldText != newText in order not to trigger any text watchers
			//AniwaysIconConverter.decodeMessage(mTextView.getContext(), text, (ISuggestionDisplayer)mTextView, null, this, parser, false, null, useSmallIcons);
			Log.d(TAG, "Decode end");
		}
		else if(isIconInfoDisplayer()){
			Log.d(TAG, "Start decode");
			AniwaysIconConverter.decodeMessage(mTextView.getContext(), text, null, (IIconInfoDisplayer)mTextView, this, parser, null, useSmallIcons, false, false, false);
			Log.d(TAG, "End decode");

			if(AniwaysPrivateConfig.getInstance().autoReplaceKeyPhrasesInTextView){
				Log.d(TAG, "Start autoreplace phrases");
				AniwaysIconConverter.autoreplaceTextWithIcons(text, mTextView.getContext(), (IIconInfoDisplayer)mTextView, useSmallIcons);
				Log.d(TAG, "End autoreplace phrases");
			}
		}
		else{
			Log.e(true, TAG, "mTextView is not a suggestion diplayer and not icon info displayer");
		}

		if(this.mDoNotShowIcons ){
			AniwaysIconConverter.removeAllAniwaysSpans(text);
		}

		this.mDynamicImageSpansContainer.onSetText(text, oldText);

		this.addTheAniwaysTextWatcher();

		AniwaysBackendSyncChecker.requestSyncWithServerIfNecessary();
	}

	/**
	 * Convenience for {@link android.text.Selection#setSelection(android.text.Spannable, int, int)}.
	 */
	public void setSelection(int start, int stop) {
		if (stop > mTextView.getText().length()){
			stop = mTextView.getText().length();
		}
		((IAniwaysTextEditor)mTextView).callSuperSetSelection(start, stop);
	}

	/**
	 * Convenience for {@link android.text.Selection#setSelection(android.text.Spannable, int)}.
	 */
	public void setSelection(int index) {
		if (index > mTextView.getText().length()){
			index = mTextView.getText().length();
		}
		((IAniwaysTextEditor)mTextView).callSuperSetSelection(index);
	}

	/**
	 * Convenience for {@link android.text.Selection#selectAll}.
	 */
	public void selectAll() {
		((IAniwaysTextEditor)mTextView).callSuperSelectAll();
	}

	/**
	 * Convenience for {@link android.text.Selection#extendSelection}.
	 */
	public void extendSelection(int index) {
		if ((mTextView.getSelectionEnd() + index) > mTextView.getText().length()){
			index = mTextView.getText().length() - mTextView.getSelectionEnd();
		}
		((IAniwaysTextEditor)mTextView).callSuperExtendSelection(index);
	}


	Point[] calculateCenterPointsForAboveAndBelowLine(int start, int end) {
		return calculateCenterPointsForAboveAndBelowLine(start, end, this);
	}

	/**
	 * 
	 * @param start
	 * @param end
	 * @return !!Be careful, can return null if there was a recent layout change!!
	 */
	static Point[] calculateCenterPointsForAboveAndBelowLine(int start, int end, IAniwaysTextContainer textContainer) {
		// calculate center point if arrow comes above the line
		// TODO: Deal with cases where start and end are not in the same line
		Point startPointForAboveLine = textContainer.getPointOfPositionInText(start, true);
		Point endPointForAboveLine = textContainer.getPointOfPositionInText(end, true);

		if(startPointForAboveLine== null || endPointForAboveLine == null){
			return null;
		}

		Point centerPointForAboveLine = new Point((startPointForAboveLine.x + endPointForAboveLine.x) / 2, startPointForAboveLine.y );

		// calculate center point if arrow comes below the line
		// TODO: Deal with cases where start and end are not in the same line
		Point startPointForBelowLine = textContainer.getPointOfPositionInText(start, false);
		Point endPointForBelowLine = textContainer.getPointOfPositionInText(end, false);

		if(startPointForAboveLine== null || endPointForBelowLine == null){
			return null;
		}

		Point centerPointForBelowLine = new Point((startPointForBelowLine.x + endPointForBelowLine.x) / 2, endPointForBelowLine.y );

		Log.v(TAG, "start pos: " + start + "end pos: " + end);
		Log.v(TAG, "center point for above line: " + centerPointForAboveLine.x + " " + centerPointForAboveLine.y);
		Log.v(TAG, "center point for below line: " + centerPointForBelowLine.x + " " + centerPointForBelowLine.y);

		return new Point[] {centerPointForAboveLine, centerPointForBelowLine};
	}

	/**
	 * Dismisses the old quick action, if exists, and creates a new one
	 * @return
	 */
	QuickAction createAndSetNewQuickAction(View anchor, JsonParser parser, boolean showCreditsIfStoreIsEnabled) {
		if (this.mQuickAction != null && this.mQuickAction.isShowing()){
			this.mQuickAction.dismiss();
		}
		this.mQuickAction = new QuickAction(mTextView.getContext(), anchor, parser, showCreditsIfStoreIsEnabled, false, true);
		return mQuickAction;
	}

	/**
	 * Will remove the watcher if enabled
	 * 
	 * There is a bug in the Android implementation of the add and remove text change listener.
	 * It is just a list, so the same listener can be added more than once, when removing it just removes the first occurance of the given instance. 
	 * So if my code is not perfect and the listener is added more then once it will not really be removed when removing.
	 * This might happen if there are 2 methods that first remove then add, and they call each other. So both methods first remove, then they add and it is added twice..
	 * Need to override the remove and add methods and keep a hash map of the objects and make sure there is only one instance at a time and that it is indeed removed.
	 */
	IAniwaysTextWatcher removeTheAniwaysTextWatcher(){
		if(!mIsEditText){
			return mTextWatcher;
		}

		if(this.mTextWatcherEnabled){
			((IAniwaysTextEditor)this.mTextView).callSuperRemoveTextChangedListener(mTextWatcher);
			this.mTextWatcherEnabled  = false;
		}

		return mTextWatcher;
	}

	/**
	 * Will add the watcher if not enabled
	 * 
	 * There is a bug in the Android implementation of the add and remove text change listener.
	 * It is just a list, so the same listener can be added more than once, when removing it just removes the first occurance of the given instance. 
	 * So if my code is not perfect and the listener is added more then once it will not really be removed when removing.
	 * This might happen if there are 2 methods that first remove then add, and they call each other. So both methods first remove, then they add and it is added twice..
	 * Need to override the remove and add methods and keep a hash map of the objects and make sure there is only one instance at a time and that it is indeed removed.
	 */
	IAniwaysTextWatcher addTheAniwaysTextWatcher(){
		if(!mIsEditText){
			return mTextWatcher;
		}

		if(!this.mTextWatcherEnabled){
			((IAniwaysTextEditor)this.mTextView).callSuperAddTextChangedListener(mTextWatcher);
			this.mTextWatcherEnabled = true;
		}

		return mTextWatcher;
	}

	@Override
	public void removeTextWatchers(){
		removeTheAniwaysTextWatcher();
	}

	@Override
	public void addBackTheTextWatchers(){
		addTheAniwaysTextWatcher();
	}

	/**
	 * There is a bug in the Android implementation of the add and remove text change listener.
	 * It is just a list, so the same listener can be added more than once, when removing it just removes the first occurance of the given instance. 
	 * So if my code is not perfect and the listener is added more then once it will not really be removed when removing.
	 * This might happen if there are 2 methods that first remove then add, and they call each other. So both methods first remove, then they add and it is added twice..
	 * Need to override the remove and add methods and keep a hash map of the objects and make sure there is only one instance at a time and that it is indeed removed.
	 * @param watcher
	 */
	void removeTextChangedListener(TextWatcher watcher) {
		if (watcher instanceof IAniwaysTextWatcher){
			Log.e(true, TAG, "Removing the Aniways text watcher not through calling removeTheAniwaysTextWatcher() which makes sure that there is a max of only one such watcher at each time");
			this.removeTheAniwaysTextWatcher();
		}
		else{
			((IAniwaysTextEditor)mTextView).callSuperRemoveTextChangedListener(watcher);
		}
	}

	void addTextChangedListener(TextWatcher watcher) {
		if (watcher instanceof IAniwaysTextWatcher){
			Log.e(true, TAG, "Adding the Aniways text watcher not through calling addTheAniwaysTextWatcher() which makes sure that there is a max of only one such watcher at each time");
			this.addTheAniwaysTextWatcher();
		}
		else{
			((IAniwaysTextEditor)mTextView).callSuperAddTextChangedListener(watcher);
		}
	}

	@Override
	public
	AniwaysDynamicImageSpansContainer getDynamicImageSpansContainer(){
		return this.mDynamicImageSpansContainer;
	}

	void onRemoveDynamicImageSpan(IAniwaysDynamicImageSpan span){
		mDynamicImageSpansContainer.onRemoveSpan(span);
	}

	void onDetachFromWindow(){
		//TODO: see if need also onAttachToWindow..
		mDynamicImageSpansContainer.onDetachFromWindowCalled();
	}

	void onLayoutCalled(){
		mDynamicImageSpansContainer.onLayoutCalled();
	}

	@Override
	public void onLoadedImageSuccessfuly() {
		// TODO Auto-generated method stub

	}

	@Override
	public void onErrorLoadingImage() {
		// TODO Auto-generated method stub

	}

	private boolean isIconInfoDisplayer(){
		return mTextView instanceof IIconInfoDisplayer;
	}

	@Override
	public IIconInfoDisplayer getIconInfoDisplayer() {
		if(isIconInfoDisplayer()){
			return (IIconInfoDisplayer)mTextView;
		}
		return null;
	}

	//TODO: Put the functionality of below 2 methods in their own class, which could be used by Telegram..
	
	@Override
	public void registerSetTextListener(OnSetTextListener setTextListener) {
		this.mSetTextListeners.add(setTextListener);
		setTextListener.onSetText(this.getText());

	}

	@Override
	public void unregisterSetTextListener(OnSetTextListener listener) {
		this.mSetTextListeners.remove(listener);

	}
}

interface IAniwaysGestureResponder{
	public void onSingleTap(MotionEvent event);
	public boolean callSuperOnTouchEvent(MotionEvent moEvent);
}

interface IAniwaysTextEditor{
	boolean callSuperOnTextContextMenuItem(int id);

	boolean callSuperOnTouchEvent(MotionEvent event);

	boolean callSuperDispatchKeyEventPreIme(KeyEvent event);

	void callSuperSetSelection(int start, int stop);

	void callSuperSetSelection(int index);

	void callSuperExtendSelection(int index);

	void callSuperSelectAll();

	void callSuperRemoveTextChangedListener(TextWatcher watcher);

	void callSuperAddTextChangedListener(TextWatcher watcher);

	IAniwaysTextWatcher addTheAniwaysTextWatcher();

	IAniwaysTextWatcher removeTheAniwaysTextWatcher();

	void setText(CharSequence text, boolean justCallSuper);
}
