/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageButton;
import java.io.IOException;
import pl.droidsonroids.gif.GifDrawable;

public class GifImageButton
extends ImageButton {
    public GifImageButton(Context context) {
        super(context);
    }

    public GifImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.trySetGifDrawable(attrs, this.getResources());
    }

    public GifImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.trySetGifDrawable(attrs, this.getResources());
    }

    @TargetApi(value=21)
    public GifImageButton(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        this.trySetGifDrawable(attrs, this.getResources());
    }

    public void setImageResource(int resId) {
        this.setResource(true, resId, this.getResources());
    }

    public void setBackgroundResource(int resId) {
        this.setResource(false, resId, this.getResources());
    }

    private void trySetGifDrawable(AttributeSet attrs, Resources res) {
        if (attrs != null && res != null && !this.isInEditMode()) {
            int resId = attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "src", -1);
            if (resId > 0 && "drawable".equals(res.getResourceTypeName(resId))) {
                this.setResource(true, resId, res);
            }
            if ((resId = attrs.getAttributeResourceValue("http://schemas.android.com/apk/res/android", "background", -1)) > 0 && "drawable".equals(res.getResourceTypeName(resId))) {
                this.setResource(false, resId, res);
            }
        }
    }

    @TargetApi(value=16)
    private void setResource(boolean isSrc, int resId, Resources res) {
        try {
            GifDrawable d = new GifDrawable(res, resId);
            if (isSrc) {
                this.setImageDrawable(d);
            } else if (Build.VERSION.SDK_INT >= 16) {
                this.setBackground(d);
            } else {
                this.setBackgroundDrawable(d);
            }
            return;
        }
        catch (Resources.NotFoundException | IOException ignored) {
            if (isSrc) {
                super.setImageResource(resId);
            } else {
                super.setBackgroundResource(resId);
            }
            return;
        }
    }

    public void setImageURI(Uri uri) {
        if (uri != null) {
            try {
                this.setImageDrawable(new GifDrawable(this.getContext().getContentResolver(), uri));
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.setImageURI(uri);
    }
}

