/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Locale;
import pl.droidsonroids.gif.GifInfoHandle;

public class GifAnimationMetaData
implements Serializable,
Parcelable {
    private static final long serialVersionUID = 5692363926580237325L;
    private final int mLoopCount;
    private final int mDuration;
    private final int mHeight;
    private final int mWidth;
    private final int mImageCount;
    public static final Parcelable.Creator<GifAnimationMetaData> CREATOR = new Parcelable.Creator<GifAnimationMetaData>(){

        public GifAnimationMetaData createFromParcel(Parcel source) {
            return new GifAnimationMetaData(source);
        }

        public GifAnimationMetaData[] newArray(int size) {
            return new GifAnimationMetaData[size];
        }
    };

    public GifAnimationMetaData(Resources res, int id2) throws Resources.NotFoundException, IOException {
        this(res.openRawResourceFd(id2));
    }

    public GifAnimationMetaData(AssetManager assets, String assetName) throws IOException {
        this(assets.openFd(assetName));
    }

    public GifAnimationMetaData(String filePath) throws IOException {
        this(GifInfoHandle.openFile(filePath, true));
    }

    public GifAnimationMetaData(File file) throws IOException {
        this(GifInfoHandle.openFile(file.getPath(), true));
    }

    public GifAnimationMetaData(InputStream stream) throws IOException {
        this(GifInfoHandle.openMarkableInputStream(stream, true));
    }

    public GifAnimationMetaData(AssetFileDescriptor afd) throws IOException {
        this(GifInfoHandle.openAssetFileDescriptor(afd, true));
    }

    public GifAnimationMetaData(FileDescriptor fd) throws IOException {
        this(GifInfoHandle.openFd(fd, 0L, true));
    }

    public GifAnimationMetaData(byte[] bytes) throws IOException {
        this(GifInfoHandle.openByteArray(bytes, true));
    }

    public GifAnimationMetaData(ByteBuffer buffer) throws IOException {
        this(GifInfoHandle.openDirectByteBuffer(buffer, true));
    }

    public GifAnimationMetaData(ContentResolver resolver, Uri uri) throws IOException {
        this(resolver.openAssetFileDescriptor(uri, "r"));
    }

    private GifAnimationMetaData(GifInfoHandle gifInfoHandle) {
        this.mLoopCount = gifInfoHandle.getLoopCount();
        this.mDuration = gifInfoHandle.getDuration();
        gifInfoHandle.recycle();
        this.mWidth = gifInfoHandle.width;
        this.mHeight = gifInfoHandle.height;
        this.mImageCount = gifInfoHandle.imageCount;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getNumberOfFrames() {
        return this.mImageCount;
    }

    public int getLoopCount() {
        return this.mLoopCount;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public boolean isAnimated() {
        return this.mImageCount > 1 && this.mDuration > 0;
    }

    public String toString() {
        String loopCount = this.mLoopCount == 0 ? "Infinity" : Integer.toString(this.mLoopCount);
        String suffix = String.format(Locale.US, "GIF: size: %dx%d, frames: %d, loops: %s, duration: %d", this.mWidth, this.mHeight, this.mImageCount, loopCount, this.mDuration);
        return this.isAnimated() ? "Animated " + suffix : suffix;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLoopCount);
        dest.writeInt(this.mDuration);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mImageCount);
    }

    private GifAnimationMetaData(Parcel in) {
        this.mLoopCount = in.readInt();
        this.mDuration = in.readInt();
        this.mHeight = in.readInt();
        this.mWidth = in.readInt();
        this.mImageCount = in.readInt();
    }
}

