/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.volley.toolbox;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.http.AndroidHttpClient;
import android.os.Build;
import android.text.TextUtils;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.volley.Request;
import com.aniways.volley.RequestQueue;
import com.aniways.volley.toolbox.AniwaysLruImageCache;
import com.aniways.volley.toolbox.BasicNetwork;
import com.aniways.volley.toolbox.DiskBasedCache;
import com.aniways.volley.toolbox.HttpClientStack;
import com.aniways.volley.toolbox.HttpStack;
import com.aniways.volley.toolbox.HurlStack;
import com.aniways.volley.toolbox.ImageLoader;
import java.io.File;
import org.apache.http.client.HttpClient;

public class Volley {
    private static final String DEFAULT_CACHE_DIR = "volley-aniways";
    private static Context sContext;
    public static final String TAG;
    private static RequestQueue sRequestQueue;
    private static ImageLoader sImageLoader;

    public static void forceInit(Context applicationContext) {
        sContext = applicationContext;
        Volley.getImageLoader();
    }

    public static RequestQueue newRequestQueue(Context context, HttpStack stack) {
        File cacheDir = new File(context.getCacheDir(), DEFAULT_CACHE_DIR);
        String userAgent = "volley/0";
        try {
            String packageName = context.getPackageName();
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
            userAgent = packageName + "/" + info.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        if (stack == null) {
            stack = Build.VERSION.SDK_INT >= 9 ? new HurlStack() : new HttpClientStack((HttpClient)AndroidHttpClient.newInstance((String)userAgent));
        }
        BasicNetwork network = new BasicNetwork(stack);
        RequestQueue queue = new RequestQueue(new DiskBasedCache(cacheDir, AniwaysPrivateConfig.getInstance().diskCacheSize), network);
        queue.start();
        return queue;
    }

    public static RequestQueue newRequestQueue(Context context) {
        return Volley.newRequestQueue(context, null);
    }

    public static RequestQueue getRequestQueue() {
        if (sRequestQueue == null) {
            sRequestQueue = Volley.newRequestQueue(sContext);
        }
        return sRequestQueue;
    }

    public static ImageLoader getImageLoader() {
        Volley.getRequestQueue();
        if (sImageLoader == null) {
            sImageLoader = new ImageLoader(sRequestQueue, new AniwaysLruImageCache(sContext));
        }
        return sImageLoader;
    }

    public static <T> void addToRequestQueue(Request<T> req, String tag) {
        req.setTag(TextUtils.isEmpty((CharSequence)tag) ? TAG : tag);
        Volley.getRequestQueue().add(req);
    }

    public static <T> void addToRequestQueue(Request<T> req) {
        req.setTag(TAG);
        Volley.getRequestQueue().add(req);
    }

    public static void cancelPendingRequests(Object tag) {
        if (sRequestQueue != null) {
            sRequestQueue.cancelAll(tag);
        }
    }

    static {
        TAG = "Aniways" + Volley.class.getSimpleName();
    }
}

