/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.volley.toolbox;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import com.aniways.AniwaysBitmapDecodeUtils;
import com.aniways.Log;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.volley.Cache;
import com.aniways.volley.ParseError;
import com.aniways.volley.Request;
import com.aniways.volley.RequestQueue;
import com.aniways.volley.Response;
import com.aniways.volley.VolleyError;
import com.aniways.volley.toolbox.AniwaysImageRequest;
import com.aniways.volley.toolbox.AniwaysImageUtil;
import com.aniways.volley.toolbox.AniwaysVolleyImageResponse;
import java.util.HashMap;
import java.util.LinkedList;

public class ImageLoader {
    private static final String TAG = "AniwaysVolleyImageLoader";
    private final RequestQueue mRequestQueue;
    private int mBatchResponseDelayMs = 100;
    private final ImageCache mCache;
    private final HashMap<String, BatchedImageRequest> mInFlightRequests = new HashMap();
    private final HashMap<String, BatchedImageRequest> mBatchedResponses = new HashMap();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private Runnable mRunnable;

    public ImageLoader(RequestQueue queue, ImageCache imageCache) {
        this.mRequestQueue = queue;
        this.mCache = imageCache;
    }

    public static ImageListener getImageListener(final ImageView view, final int defaultImageResId, final int errorImageResId) {
        return new ImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (errorImageResId != 0) {
                    view.setImageResource(errorImageResId);
                }
            }

            @Override
            public void onResponse(ImageContainer response, boolean isImmediate) {
                if (response.getBitmap() != null) {
                    view.setImageBitmap(response.getBitmap());
                } else if (defaultImageResId != 0) {
                    view.setImageResource(defaultImageResId);
                }
            }
        };
    }

    public boolean isCached(String requestUrl, int maxWidth, int maxHeight) {
        this.throwIfNotOnMainThread();
        String cacheKey = ImageLoader.getCacheKey(requestUrl, maxWidth, maxHeight);
        return this.mCache.getBitmap(cacheKey, maxWidth, maxHeight) != null;
    }

    public Object getCached(String requestUrl, int maxWidth, int maxHeight, String iconName) {
        Cache cache;
        Cache.Entry entry;
        Bitmap bitmap;
        String cacheKey = ImageLoader.getCacheKey(requestUrl, maxWidth, maxHeight);
        boolean isGif = requestUrl.endsWith(".gif");
        if (!isGif) {
            bitmap = (Bitmap)this.mCache.getBitmap(cacheKey, maxWidth, maxHeight);
            if (bitmap != null) {
                Log.v(TAG, "Found cached mem or pre-installed bitmap for image: " + iconName);
                return bitmap;
            }
        } else {
            byte[] rawData = (byte[])this.mCache.getBitmap(cacheKey, maxWidth, maxHeight);
            if (rawData != null) {
                Log.v(TAG, "Found cached mem or pre-installed gif for image: " + iconName);
                return rawData;
            }
        }
        if ((entry = (cache = this.mRequestQueue.getCache()).get(requestUrl)) == null) {
            return null;
        }
        if (isGif) {
            Log.v(TAG, "Returning animated gif from disk cache: " + iconName);
            return entry.data;
        }
        Log.v(TAG, "Found disk cached bitmap for image: " + iconName);
        try {
            bitmap = AniwaysBitmapDecodeUtils.decodeBitmapFromByteArray(entry.data, maxWidth, maxHeight, requestUrl, false);
        }
        catch (OutOfMemoryError e) {
            Log.e(true, TAG, "Caught OOM Exception while puttin Bitmap in cache", e);
            return null;
        }
        this.mCache.putBitmap(cacheKey, bitmap);
        return bitmap;
    }

    public ImageContainer get(String requestUrl, ImageListener listener) {
        return this.get(requestUrl, listener, 0, 0, false);
    }

    public ImageContainer get(String requestUrl, ImageListener imageListener, int maxWidth, int maxHeight, boolean getDiskCacheOnMainThread) {
        this.throwIfNotOnMainThread();
        final String cacheKey = ImageLoader.getCacheKey(requestUrl, maxWidth, maxHeight);
        try {
            Object data;
            Bitmap cachedBitmap = null;
            byte[] cachedGif = null;
            if (getDiskCacheOnMainThread) {
                data = this.getCached(requestUrl, maxWidth, maxHeight, requestUrl);
                if (data instanceof Bitmap) {
                    cachedBitmap = (Bitmap)data;
                }
                if (data instanceof byte[]) {
                    cachedGif = (byte[])data;
                }
            } else {
                data = this.mCache.getBitmap(cacheKey, maxWidth, maxHeight);
            }
            if (data != null) {
                ImageContainer container = new ImageContainer(data, requestUrl, null, null);
                imageListener.onResponse(container, true);
                return container;
            }
        }
        catch (OutOfMemoryError ex) {
            ImageContainer container = new ImageContainer(null, requestUrl, null, null);
            imageListener.onErrorResponse(new ParseError(ex));
            return container;
        }
        ImageContainer imageContainer = new ImageContainer(null, requestUrl, cacheKey, imageListener);
        imageListener.onResponse(imageContainer, true);
        BatchedImageRequest request = this.mInFlightRequests.get(cacheKey);
        if (request != null) {
            request.addContainer(imageContainer);
            return imageContainer;
        }
        AniwaysImageRequest newRequest = new AniwaysImageRequest(requestUrl, new Response.Listener<AniwaysVolleyImageResponse>(){

            @Override
            public void onResponse(AniwaysVolleyImageResponse response) {
                ImageLoader.this.onGetImageSuccess(cacheKey, response);
            }
        }, maxWidth, maxHeight, new Response.ErrorListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
            }
        });
        this.mRequestQueue.add(newRequest);
        this.mInFlightRequests.put(cacheKey, new BatchedImageRequest(newRequest, imageContainer));
        return imageContainer;
    }

    public void setBatchedResponseDelay(int newBatchedResponseDelayMs) {
        this.mBatchResponseDelayMs = newBatchedResponseDelayMs;
    }

    private void onGetImageSuccess(String cacheKey, AniwaysVolleyImageResponse response) {
        if (AniwaysImageUtil.isGif(cacheKey)) {
            this.mCache.putBitmap(cacheKey, response.getRawData());
        } else {
            this.mCache.putBitmap(cacheKey, response.getBitmap());
        }
        BatchedImageRequest request = this.mInFlightRequests.remove(cacheKey);
        if (request != null) {
            if (AniwaysImageUtil.isGif(cacheKey)) {
                BatchedImageRequest.access$102(request, response.rawData);
            } else {
                request.mResponseBitmap = response.getBitmap();
            }
            this.batchResponse(cacheKey, request);
        }
    }

    private void onGetImageError(String cacheKey, VolleyError error) {
        BatchedImageRequest request = this.mInFlightRequests.remove(cacheKey);
        if (request != null) {
            request.setError(error);
            this.batchResponse(cacheKey, request);
        }
    }

    private void batchResponse(String cacheKey, BatchedImageRequest request) {
        this.mBatchedResponses.put(cacheKey, request);
        if (this.mRunnable == null) {
            this.mRunnable = new NonThrowingRunnable("Aniways volley image loder", "batchResponse", null){

                @Override
                public void innerRun() {
                    try {
                        for (BatchedImageRequest bir : ImageLoader.this.mBatchedResponses.values()) {
                            for (ImageContainer container : bir.mContainers) {
                                if (container.mListener == null) continue;
                                if (bir.getError() == null) {
                                    ImageContainer.access$802(container, bir.mRawData);
                                    container.mBitmap = bir.mResponseBitmap;
                                    container.mListener.onResponse(container, false);
                                    continue;
                                }
                                container.mListener.onErrorResponse(bir.getError());
                            }
                        }
                        ImageLoader.this.mBatchedResponses.clear();
                    }
                    catch (Throwable ex) {
                        Log.e(true, ImageLoader.TAG, "Caught Exception in batchResponse" + ex);
                    }
                    ImageLoader.this.mRunnable = null;
                }
            };
            this.mHandler.postDelayed(this.mRunnable, (long)this.mBatchResponseDelayMs);
        }
    }

    private void throwIfNotOnMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ImageLoader must be invoked from the main thread.");
        }
    }

    private static String getCacheKey(String url, int maxWidth, int maxHeight) {
        return new StringBuilder(url.length() + 12).append("#W").append(maxWidth).append("#H").append(maxHeight).append(url).toString();
    }

    private class BatchedImageRequest {
        private final Request<?> mRequest;
        private Bitmap mResponseBitmap;
        private byte[] mRawData;
        private VolleyError mError;
        private final LinkedList<ImageContainer> mContainers = new LinkedList();

        public BatchedImageRequest(Request<?> request, ImageContainer container) {
            this.mRequest = request;
            this.mContainers.add(container);
        }

        public void setError(VolleyError error) {
            this.mError = error;
        }

        public VolleyError getError() {
            return this.mError;
        }

        public void addContainer(ImageContainer container) {
            this.mContainers.add(container);
        }

        public boolean removeContainerAndCancelIfNecessary(ImageContainer container) {
            this.mContainers.remove(container);
            if (this.mContainers.size() == 0) {
                this.mRequest.cancel();
                return true;
            }
            return false;
        }

        static /* synthetic */ byte[] access$102(BatchedImageRequest x0, byte[] x1) {
            x0.mRawData = x1;
            return x1;
        }
    }

    public class ImageContainer {
        private Bitmap mBitmap;
        private byte[] rawData;
        private final ImageListener mListener;
        private final String mCacheKey;
        private final String mRequestUrl;

        public ImageContainer(Object data, String requestUrl, String cacheKey, ImageListener listener) {
            if (data == null) {
                this.mBitmap = null;
                this.rawData = null;
            } else if (AniwaysImageUtil.isGif(requestUrl)) {
                this.mBitmap = null;
                this.rawData = (byte[])data;
            } else {
                this.mBitmap = (Bitmap)data;
                this.rawData = null;
            }
            this.mRequestUrl = requestUrl;
            this.mCacheKey = cacheKey;
            this.mListener = listener;
        }

        public void cancelRequest() {
            ImageLoader.this.throwIfNotOnMainThread();
            if (this.mListener == null) {
                return;
            }
            BatchedImageRequest request = (BatchedImageRequest)ImageLoader.this.mInFlightRequests.get(this.mCacheKey);
            if (request != null) {
                boolean canceled = request.removeContainerAndCancelIfNecessary(this);
                if (canceled) {
                    ImageLoader.this.mInFlightRequests.remove(this.mCacheKey);
                }
            } else {
                request = (BatchedImageRequest)ImageLoader.this.mBatchedResponses.get(this.mCacheKey);
                if (request != null) {
                    request.removeContainerAndCancelIfNecessary(this);
                    if (request.mContainers.size() == 0) {
                        ImageLoader.this.mBatchedResponses.remove(this.mCacheKey);
                    }
                }
            }
        }

        public Bitmap getBitmap() {
            return this.mBitmap;
        }

        public String getRequestUrl() {
            return this.mRequestUrl;
        }

        public byte[] getRawData() {
            return this.rawData;
        }

        static /* synthetic */ byte[] access$802(ImageContainer x0, byte[] x1) {
            x0.rawData = x1;
            return x1;
        }
    }

    public static interface ImageListener
    extends Response.ErrorListener {
        public void onResponse(ImageContainer var1, boolean var2);
    }

    public static interface ImageCache {
        public void putBitmap(String var1, Object var2);

        public Object getBitmap(String var1, int var2, int var3);
    }
}

