/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.viewpagerindicator;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.LinearLayout;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;

class IcsLinearLayout
extends LinearLayout {
    private static final int LL_DIVIDER = 0;
    private static final int LL_SHOW_DIVIDER = 1;
    private static final int LL_DIVIDER_PADDING = 2;
    private static final String TAG = "AniwaysIcsLinearLayout";
    private Drawable mDivider;
    private int mDividerWidth;
    private int mDividerHeight;
    private int mShowDividers;
    private int mDividerPadding;

    public IcsLinearLayout(Context context) {
        this(context, R.attr.aniways_vpiTabPageIndicatorStyle);
    }

    @SuppressLint(value={"InlinedApi"})
    public IcsLinearLayout(Context context, int themeAttr) {
        super((Context)new ContextThemeWrapper(context, R.style.Aniways_StyledIndicators));
        int[] LL = null;
        LL = Utils.isAndroidVersionAtLeast(11) ? new int[]{16843049, 16843561, 16843562} : new int[]{16843049, 16843561, 16843562};
        TypedArray a = this.getContext().obtainStyledAttributes(null, LL, themeAttr, R.style.Aniways_StyledIndicators);
        this.setDividerDrawable(a.getDrawable(0));
        this.mDividerPadding = a.getDimensionPixelSize(2, 0);
        this.mShowDividers = a.getInteger(1, 0);
        a.recycle();
    }

    public void setDividerDrawable(Drawable divider) {
        try {
            if (divider == this.mDivider) {
                return;
            }
            this.mDivider = divider;
            if (divider != null) {
                this.mDividerWidth = divider.getIntrinsicWidth();
                this.mDividerHeight = divider.getIntrinsicHeight();
            } else {
                this.mDividerWidth = 0;
                this.mDividerHeight = 0;
            }
            this.setWillNotDraw(divider == null);
            this.requestLayout();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in setDividerDrawable", ex);
        }
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        try {
            int count;
            int index = this.indexOfChild(child);
            int orientation = this.getOrientation();
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (this.hasDividerBeforeChildAt(index)) {
                if (orientation == 1) {
                    params.topMargin = this.mDividerHeight;
                } else {
                    params.leftMargin = this.mDividerWidth;
                }
            }
            if (index == (count = this.getChildCount()) - 1 && this.hasDividerBeforeChildAt(count)) {
                if (orientation == 1) {
                    params.bottomMargin = this.mDividerHeight;
                } else {
                    params.rightMargin = this.mDividerWidth;
                }
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in measureChildWithMargins", ex);
        }
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    protected void onDraw(Canvas canvas) {
        try {
            if (this.mDivider != null) {
                if (this.getOrientation() == 1) {
                    this.drawDividersVertical(canvas);
                } else {
                    this.drawDividersHorizontal(canvas);
                }
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onDraw", ex);
        }
        super.onDraw(canvas);
    }

    private void drawDividersVertical(Canvas canvas) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int top = child.getTop() - lp.topMargin;
            this.drawHorizontalDivider(canvas, top);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int bottom = 0;
            bottom = child == null ? this.getHeight() - this.getPaddingBottom() - this.mDividerHeight : child.getBottom();
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    private void drawDividersHorizontal(Canvas canvas) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int left = child.getLeft() - lp.leftMargin;
            this.drawVerticalDivider(canvas, left);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int right = 0;
            right = child == null ? this.getWidth() - this.getPaddingRight() - this.mDividerWidth : child.getRight();
            this.drawVerticalDivider(canvas, right);
        }
    }

    private void drawHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    private void drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    private boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0 || childIndex == this.getChildCount()) {
            return false;
        }
        if ((this.mShowDividers & 2) != 0) {
            boolean hasVisibleViewBefore = false;
            for (int i = childIndex - 1; i >= 0; --i) {
                if (this.getChildAt(i).getVisibility() == 8) continue;
                hasVisibleViewBefore = true;
                break;
            }
            return hasVisibleViewBefore;
        }
        return false;
    }
}

