/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.preference.Preference;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.ui.AniwaysUiUtil;

public class AniwaysSeekBarPreference
extends Preference
implements SeekBar.OnSeekBarChangeListener {
    private final String TAG = ((Object)((Object)this)).getClass().getName();
    private static final String ANDROIDNS = "http://schemas.android.com/apk/res/android";
    private static final String APPLICATIONNS = "http://aniways.com";
    private static final int DEFAULT_VALUE = 60;
    private int mMaxValue = 80;
    private int mMinValue = 20;
    private int mInterval = 1;
    private int mCurrentValue;
    private SeekBar mSeekBar;
    private ImageView mEmoticonSizeIndicatorImage;

    public int getPersistedValue() {
        return this.getPersistedInt(60);
    }

    public AniwaysSeekBarPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPreference(context, attrs);
    }

    public AniwaysSeekBarPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initPreference(context, attrs);
    }

    private void initPreference(Context context, AttributeSet attrs) {
        this.setValuesFromXml(attrs);
        this.mSeekBar = new SeekBar(context, attrs);
        this.mSeekBar.setMax(this.mMaxValue - this.mMinValue);
        this.mSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.setWidgetLayoutResource(R.layout.aniways_seek_bar_preference);
    }

    private void setValuesFromXml(AttributeSet attrs) {
        this.mMaxValue = attrs.getAttributeIntValue(ANDROIDNS, "max", 80);
        this.mMinValue = attrs.getAttributeIntValue(APPLICATIONNS, "min", 20);
        try {
            String newInterval = attrs.getAttributeValue(APPLICATIONNS, "interval");
            if (newInterval != null) {
                this.mInterval = Integer.parseInt(newInterval);
            }
        }
        catch (Exception e) {
            Log.e(true, this.TAG, "Invalid interval value", e);
        }
    }

    protected View onCreateView(ViewGroup parent) {
        try {
            View view = super.onCreateView(parent);
            LinearLayout layout2 = (LinearLayout)view;
            layout2.setOrientation(1);
            return view;
        }
        catch (Exception e) {
            Log.e(true, this.TAG, "Caught exception at onCreateView in AniwaysSeekbarPrefernce", e);
            return null;
        }
    }

    public void onBindView(View view) {
        super.onBindView(view);
        try {
            ViewParent oldContainer = this.mSeekBar.getParent();
            ViewGroup newContainer = (ViewGroup)view.findViewById(R.id.seekBarPrefBarContainer);
            if (oldContainer != newContainer) {
                if (oldContainer != null) {
                    ((ViewGroup)oldContainer).removeView((View)this.mSeekBar);
                }
                newContainer.removeAllViews();
                newContainer.addView((View)this.mSeekBar, -1, -2);
            }
        }
        catch (Exception ex) {
            Log.e(true, this.TAG, "Error binding view: " + ex.toString());
        }
        if (view != null && !view.isEnabled()) {
            this.mSeekBar.setEnabled(false);
        }
        this.updateView(view);
    }

    protected void updateView(View view) {
        try {
            int progress = this.mCurrentValue - this.mMinValue;
            this.mEmoticonSizeIndicatorImage = (ImageView)view.findViewById(R.id.emoticon_seek_bar_indication);
            this.mSeekBar.setProgress(progress);
            this.onProgressChanged(this.mSeekBar, progress, false);
        }
        catch (Exception e) {
            Log.e(true, this.TAG, "Error updating seek bar preference", e);
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        int newValue = progress + this.mMinValue;
        if (newValue > this.mMaxValue) {
            newValue = this.mMaxValue;
        } else if (newValue < this.mMinValue) {
            newValue = this.mMinValue;
        } else if (this.mInterval != 1 && newValue % this.mInterval != 0) {
            newValue = Math.round((float)newValue / (float)this.mInterval) * this.mInterval;
        }
        if (!this.callChangeListener(newValue)) {
            seekBar.setProgress(this.mCurrentValue - this.mMinValue);
            return;
        }
        this.mCurrentValue = newValue;
        this.setImageIndicatorSize(this.mCurrentValue);
        this.persistInt(newValue);
    }

    private void setImageIndicatorSize(int newSize) {
        int newSizeInDp;
        if (this.mEmoticonSizeIndicatorImage == null) {
            return;
        }
        this.mEmoticonSizeIndicatorImage.getLayoutParams().width = newSizeInDp = AniwaysUiUtil.convertDipsToPixels(newSize);
        this.mEmoticonSizeIndicatorImage.getLayoutParams().height = newSizeInDp;
        Log.d("setImageIndicatorSize", "new size: " + newSize);
        this.mEmoticonSizeIndicatorImage.requestLayout();
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    protected Object onGetDefaultValue(TypedArray ta, int index) {
        int defaultValue = ta.getInt(index, 60);
        return defaultValue;
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        if (restoreValue) {
            this.mCurrentValue = this.getPersistedInt(this.mCurrentValue);
        } else {
            int temp = 60;
            try {
                temp = (Integer)defaultValue;
            }
            catch (Exception ex) {
                Log.e(true, this.TAG, "Invalid default value: " + defaultValue.toString());
            }
            this.persistInt(temp);
            this.mCurrentValue = temp;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mSeekBar.setEnabled(enabled);
    }

    public void onDependencyChanged(Preference dependency, boolean disableDependent) {
        super.onDependencyChanged(dependency, disableDependent);
        if (this.mSeekBar != null) {
            this.mSeekBar.setEnabled(!disableDependent);
        }
    }
}

