/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.ui.views;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.data.AniwaysStatics;
import com.aniways.quick.action.ContextualPopupCreationContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AniwaysPopupWindow
extends PopupWindow
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = "AniwaysPopupWindow";
    protected ContextualPopupCreationContext creationContext;
    private static final List<AniwaysPopupWindow> openPopups = new ArrayList<AniwaysPopupWindow>();
    protected final Context context;
    protected final LayoutInflater layoutInflater;
    private final Object syncObject;
    private Timer touchOutsideDismissalTimer;
    private Timer autoDismissalTimer;
    private final PopupTimingOptions timingOptions;
    protected WeakReference<View> anchorRef;
    private boolean dismissed;
    private final List<View.OnTouchListener> touchInterceptors;

    protected AniwaysPopupWindow(Context context, ContextualPopupCreationContext creationContext, boolean matchParentWidth, final PopupTimingOptions timingOptions) {
        super(context);
        this.creationContext = creationContext;
        this.context = context;
        this.timingOptions = timingOptions;
        this.layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.syncObject = new Object();
        this.touchInterceptors = new ArrayList<View.OnTouchListener>();
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setWidth(matchParentWidth ? -1 : -2);
        this.setHeight(-2);
        this.setTouchable(true);
        this.setFocusable(false);
        this.setInputMethodMode(2);
        this.setOutsideTouchable(true);
        super.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean retProcessed = false;
                for (View.OnTouchListener onTouchListener : AniwaysPopupWindow.this.touchInterceptors) {
                    retProcessed |= onTouchListener.onTouch(v, event);
                }
                return retProcessed;
            }
        });
        this.addTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                try {
                    switch (event.getAction()) {
                        case 4: {
                            if (timingOptions.delayTouchOutsideDismissal) {
                                AniwaysPopupWindow.this.touchOutsideDismissalTimer = new Timer();
                                AniwaysPopupWindow.this.touchOutsideDismissalTimer.schedule((TimerTask)new DismissPopupTask(AniwaysPopupWindow.this), timingOptions.touchOutsideDismissalDelay);
                            } else {
                                AniwaysPopupWindow.this.dismiss();
                            }
                            return true;
                        }
                        case 0: {
                            if (timingOptions.autoDismiss && timingOptions.extendAutoDismissOnTouch) {
                                Timer autoDismissalTimer = AniwaysPopupWindow.this.autoDismissalTimer;
                                AniwaysPopupWindow.this.autoDismissalTimer = null;
                                if (autoDismissalTimer != null) {
                                    autoDismissalTimer.cancel();
                                }
                            }
                            return false;
                        }
                        case 1: 
                        case 3: {
                            AniwaysPopupWindow.this.scheduleAutoDismissalTimer();
                            return false;
                        }
                    }
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysPopupWindow.TAG, "Caught Exception in onTouch", ex);
                }
                return false;
            }
        });
    }

    private void scheduleAutoDismissalTimer() {
        this.autoDismissalTimer = new Timer();
        this.autoDismissalTimer.schedule((TimerTask)new DismissPopupTask(this), this.timingOptions.autoDismissalDelay);
    }

    public void addTouchInterceptor(@NonNull View.OnTouchListener onTouchListener) {
        this.touchInterceptors.add(onTouchListener);
    }

    public void setTouchInterceptor(View.OnTouchListener onTouchListener) {
        this.addTouchInterceptor(onTouchListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void dismiss() {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.dismissed) {
                this.dismissed = true;
                this.touchOutsideDismissalTimer = null;
                this.autoDismissalTimer = null;
                openPopups.remove((Object)this);
                View anchor = (View)this.anchorRef.get();
                this.anchorRef.clear();
                if (anchor != null && Utils.isAndroidVersionAtLeast(16)) {
                    anchor.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            } else {
                return;
            }
        }
        try {
            super.dismiss();
        }
        catch (Exception e) {
            Log.w(true, TAG, "caught Exception while dismissing popup", e);
        }
    }

    public void tryCancelDismissal() {
        if (!this.timingOptions.delayTouchOutsideDismissal || this.dismissed) {
            return;
        }
        Timer activeTimer = this.touchOutsideDismissalTimer;
        if (activeTimer != null) {
            activeTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void onGlobalLayout() {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.dismissed) {
                if (AniwaysStatics.getApplicationContext().getResources().getConfiguration().orientation == 2) {
                    this.dismiss();
                    return;
                }
                Rect bounds = this.calculateTargetBounds((View)this.anchorRef.get());
                try {
                    if (this.isShowing()) {
                        this.update(bounds.left, bounds.top, bounds.width(), bounds.height(), true);
                    }
                }
                catch (IllegalArgumentException ex) {
                    Log.e(true, TAG, "Caught popup not attached to window error when updating popup", ex);
                    try {
                        View anchor;
                        if (Utils.isAndroidVersionAtLeast(16) && (anchor = (View)this.anchorRef.get()) != null) {
                            anchor.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                    catch (Throwable ex2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected abstract Rect calculateTargetBounds(View var1);

    public static boolean dismissAllOpenPopups() {
        boolean retClosedSomething = false;
        HashSet<AniwaysPopupWindow> windows = new HashSet<AniwaysPopupWindow>(openPopups);
        for (AniwaysPopupWindow popup : windows) {
            if (!popup.isShowing()) continue;
            retClosedSomething = true;
            popup.dismiss();
        }
        return retClosedSomething;
    }

    public static void cancelAutoDismissOfAllOpenQuickActions() {
        HashSet<AniwaysPopupWindow> windows = new HashSet<AniwaysPopupWindow>(openPopups);
        for (AniwaysPopupWindow popup : windows) {
            popup.tryCancelDismissal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void show(View anchor) {
        Object object = this.syncObject;
        synchronized (object) {
            this.anchorRef = new WeakReference<View>(anchor);
            anchor.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            Rect bounds = this.calculateTargetBounds(anchor);
            this.setHeight(bounds.height());
            this.setWidth(bounds.width());
            try {
                super.showAtLocation(anchor, 0x800033, bounds.left, bounds.top);
                this.creationContext.startTimeUserInPopup = System.currentTimeMillis();
                openPopups.add(this);
                this.scheduleAutoDismissalTimer();
            }
            catch (WindowManager.BadTokenException ex) {
                Log.e(true, TAG, "Caught bad token Exception while trying to show popup", ex);
                try {
                    if (Utils.isAndroidVersionAtLeast(16)) {
                        anchor.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
        }
    }

    protected static class PopupTimingOptions {
        private static final int DefaultTouchOutsideDismissalDelay = 400;
        private static final int DefaultAutoDismissalDelay = 60000;
        public final boolean delayTouchOutsideDismissal;
        public final int touchOutsideDismissalDelay;
        public final boolean autoDismiss;
        public final int autoDismissalDelay;
        public final boolean extendAutoDismissOnTouch;

        public PopupTimingOptions() {
            this(true, true, true);
        }

        public PopupTimingOptions(boolean delayTouchOutsideDismissal, boolean autoDismiss, boolean extendAutoDismissOnTouch) {
            this(delayTouchOutsideDismissal, 400, autoDismiss, 60000, extendAutoDismissOnTouch);
        }

        public PopupTimingOptions(boolean delayTouchOutsideDismissal, int touchOutsideDismissalDelay, boolean autoDismiss, int autoDismissalDelay, boolean extendAutoDismissOnTouch) {
            this.delayTouchOutsideDismissal = delayTouchOutsideDismissal;
            this.touchOutsideDismissalDelay = touchOutsideDismissalDelay;
            this.autoDismiss = autoDismiss;
            this.autoDismissalDelay = autoDismissalDelay;
            this.extendAutoDismissOnTouch = extendAutoDismissOnTouch;
        }
    }

    private class DismissPopupTask
    extends TimerTask {
        private final AniwaysPopupWindow mPopupToDismiss;

        public DismissPopupTask(AniwaysPopupWindow popupToDismiss) {
            this.mPopupToDismiss = popupToDismiss;
        }

        @Override
        public void run() {
            ((Activity)this.mPopupToDismiss.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DismissPopupTask.this.mPopupToDismiss.dismiss();
                }
            });
        }
    }
}

