/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.ui;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;
import com.aniways.Log;
import com.aniways.data.AniwaysStatics;

public class AniwaysUiUtil {
    private static final String TAG = "AniwaysUiUtil";

    public static int convertDipsToPixels(int dips) {
        Context applicationContext = AniwaysStatics.getApplicationContext();
        if (applicationContext == null) {
            String erroMessage = "Trying to use null application context";
            Log.e(true, TAG, erroMessage);
            throw new NullPointerException(erroMessage);
        }
        Resources r = applicationContext.getResources();
        float px = TypedValue.applyDimension((int)1, (float)dips, (DisplayMetrics)r.getDisplayMetrics());
        return (int)px;
    }

    public static DisplayMetrics getScreenDisplayMatrix() {
        WindowManager windowManager = (WindowManager)AniwaysStatics.getApplicationContext().getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(dm);
        return dm;
    }

    public static float convertPixelsToDips(float pixels) {
        Context applicationContext = AniwaysStatics.getApplicationContext();
        if (applicationContext == null) {
            String erroMessage = "Trying to use null application context";
            Log.e(true, TAG, erroMessage);
            throw new NullPointerException(erroMessage);
        }
        Resources r = applicationContext.getResources();
        float dips = pixels / applicationContext.getResources().getDisplayMetrics().density;
        return dips;
    }
}

