/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service.utils;

import com.aniways.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FileUtils {
    private static final String TAG = "AniwaysFileUtils";

    public static List<String> getFileNames(String dirPath, int sort) {
        ArrayList<String> filesList = new ArrayList();
        File fileDir = new File(dirPath);
        if (!fileDir.exists() || !fileDir.isDirectory()) {
            Log.w(true, TAG, "Invalid dir path: " + fileDir);
            return null;
        }
        String[] files = fileDir.list();
        if (null == files) {
            Log.w(true, TAG, "Could not get listing of files in dir: " + fileDir);
            return null;
        }
        filesList = Arrays.asList(files);
        if (sort != 0) {
            Collections.sort(filesList, String.CASE_INSENSITIVE_ORDER);
            if (sort < 0) {
                Collections.reverse(filesList);
            }
        }
        return filesList;
    }

    public static boolean copyFile(String srcFilePath, String destFilePath, boolean overwriteExisting) {
        Log.i(TAG, "Copying file from: " + srcFilePath + "to: " + destFilePath);
        try {
            File srcFile = new File(srcFilePath);
            if (!srcFile.exists()) {
                Log.e(true, TAG, "Source file doesn't exist");
                return false;
            }
            File destFile = new File(destFilePath);
            if (destFile.exists()) {
                if (overwriteExisting) {
                    Log.v(TAG, "Source file exists, deleting");
                    destFile.delete();
                } else {
                    Log.w(true, TAG, "Source file exists, and not deleting");
                }
            }
            return FileUtils.copyFile(srcFile, destFile);
        }
        catch (SecurityException e) {
            Log.e(true, TAG, "Could not copy file: ", e);
            return false;
        }
    }

    public static boolean copyFile(File srcFile, File destFile) {
        FileChannel in = null;
        FileChannel out = null;
        Log.i(TAG, "Copying file from: " + srcFile.getAbsolutePath() + "to: " + destFile.getAbsolutePath());
        try {
            in = new FileInputStream(srcFile).getChannel();
            out = new FileOutputStream(destFile).getChannel();
            long size = in.size();
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            out.write(buf);
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            return true;
        }
        catch (IOException e) {
            Log.e(true, TAG, "Could not copy file: ", e);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {
                Log.e(true, TAG, "Could not close in channel: ", e2);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e2) {
                Log.e(true, TAG, "Could not close out channel: ", e2);
            }
            return false;
        }
    }

    public static boolean saveDataToFile(File destFile, String data) {
        Log.v(TAG, "saving data to file: " + destFile.getAbsolutePath() + ". Data is: " + data);
        BufferedOutputStream outputStreamWriter = null;
        try {
            if (!destFile.exists()) {
                Log.v(TAG, "Creating file");
                destFile.createNewFile();
            }
            outputStreamWriter = new BufferedOutputStream(new FileOutputStream(destFile));
            outputStreamWriter.write(data.getBytes("UTF-8"));
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (FileNotFoundException e) {
            Log.e(true, TAG, "Could not save data to file cause it was not found: ", e);
            return false;
        }
        catch (IOException e) {
            Log.e(true, TAG, "Could not save data to file.", e);
            if (null != outputStreamWriter) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException e1) {
                    Log.e(true, TAG, "Could not close output stream", e1);
                }
            }
            return false;
        }
        return true;
    }

    public static String getFileContent(File file) {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            fis = new FileInputStream(file);
            isr = new InputStreamReader(fis);
            bufferedReader = new BufferedReader(isr);
            StringBuilder fileContent = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                fileContent.append(line);
            }
            fis.close();
            isr.close();
            bufferedReader.close();
            return fileContent.toString();
        }
        catch (IOException e) {
            Log.e(true, TAG, "Could not get file content: " + file.getAbsolutePath(), e);
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e1) {
                    Log.e(true, TAG, "Could not close input stream", e1);
                }
            }
            if (null != isr) {
                try {
                    isr.close();
                }
                catch (IOException e1) {
                    Log.e(true, TAG, "Could not close input stream reader", e1);
                }
            }
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e1) {
                    Log.e(true, TAG, "Could not close buffered reader", e1);
                }
            }
            return null;
        }
    }
}

