/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.aniways.Utils;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.service.AniwaysIntentService;

public final class AniwaysServiceUtils {
    public static final String SDK_VERSION = "2.3.05";
    public static final String SHARED_PREFERENCES = "com.aniways.SHARED_PREFERENCES";
    public static final String KEY_UPDATE_REQUIRED = "com.aniways.UPDATE_REQUIRED";
    public static final String KEY_APP_ID = "com.aniways.APP_ID";
    public static final String KEY_LOGS_VERBOSITY = "com.aniways.LOGS_VERBOSITY";
    public static final String KEY_TRY_USE_EXTERNAL_STORAGE_TO_CACHE_ICONS = "com.aniways.TRY_USE_EXTERNAL_STORAGE_TO_CACHE_ICONS";
    public static final String KEY_KEYWORDS_VERSION = "com.aniways.KEYWORDS_VERSION";
    public static final String KEY_KEYWORDS_ETAG = "com.aniways.KEYWORDS_ETAG";
    public static final String KEY_PARSED_KEYWORDS_VERSION = "com.aniways.PARSED_KEYWORDS_VERSION";
    public static final String KEY_CONFIG_VERSION = "com.aniways.CONFIG_VERSION";
    public static final String KEY_CONFIG_ETAG = "com.aniways.CONFIG_ETAG";
    public static final String KEY_LAST_SUCCESSFUL_CHECK_FOR_UPDATES = "com.aniways.LAST_SUCCESSFUL_CHECK_FOR_UPDATES_UPDATES";
    public static final String KEY_LAST_USER_ACTIVITY = "com.aniways.LAST_USER_ACTIVITY";
    private static final String KEY_LAST_SUCCESSFUL_ANALYTICS_FLUSH = "com.aniways.LAST_SUCCESSFUL_ANALYTICS_FLUSH";
    public static final String KEY_BACKEND_SYNC = "com.aniways.BACKEND_SYNC";
    public static final String KEY_ARE_EMOTICONS_STORED_ON_EXTERNAL_STORAGE = "com.aniways.ARE_EMOTICONS_STORED_ON_EXTERNAL_STORAGE";
    public static final String EMPTY_STRING = "";
    public static final String KEYWORDS_DIR = "/aniways/keywords";
    public static final String KEYWORDS_FILE = "keywords";
    public static final String OLD_ASSETS_DIR = "/assets";
    public static final int THREAD_POOL_SIZE = 5;
    public static final int NUM_OF_DOWNLOAD_RETRIES = 10;
    public static final long INTERVAL_BETWEEN_DOWNLOAD_RETRY_MILLIS = 2500L;
    public static final long INTERVAL_HALF_MINUTE = 30000L;
    public static final String NO_CHANGE_JSON_RESPONSE_STRING = "304";
    static final String NON_EXISTANT_APP_ID = "not set!!";
    private static final String TAG = "AniwaysServiceUtils";
    public static final String ACTION_SYNC_WITH_SERVER = "com.aniways.SYNC_WITH_SERVER";
    public static final long CONNECTION_MANAGER_TIMEOUT = 15000L;
    public static final int READ_TIMEOUT = 15000;
    public static final int CONNECTION_TIMEOUT = 15000;
    private static final String KEY_APP_INSTALL_TIME = "com.aniways.APP_INSTALL_TIME";

    public static String getConfigUrl() {
        return AniwaysPrivateConfig.getInstance().baseApiUrl + "configuration";
    }

    public static String getKeywordsUrl() {
        return AniwaysPrivateConfig.getInstance().baseApiUrl + KEYWORDS_FILE;
    }

    public static synchronized void setUpdateRequired(Context context, boolean isUpdateRequired) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putBoolean(KEY_UPDATE_REQUIRED, isUpdateRequired);
        edit.commit();
    }

    public static synchronized boolean getIsUpdateRequired(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        return prefs.getBoolean(KEY_UPDATE_REQUIRED, false);
    }

    public static boolean isServiceRunning(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!AniwaysIntentService.class.getName().equals(service.service.getClassName()) || !context.getPackageName().equals(service.service.getPackageName())) continue;
            return true;
        }
        return false;
    }

    public static synchronized void setLastSuccessfulUpdate(Context context, long time) {
        Log.i((String)TAG, (String)("Setting last successful update time to: " + time));
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putLong(KEY_LAST_SUCCESSFUL_CHECK_FOR_UPDATES, time);
        edit.commit();
    }

    public static synchronized long getLastSuccessfulUpdate(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        return prefs.getLong(KEY_LAST_SUCCESSFUL_CHECK_FOR_UPDATES, 0L);
    }

    public static synchronized void setAppInstallTime(Context context, long installTime) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putLong(KEY_APP_INSTALL_TIME, installTime);
        edit.commit();
    }

    public static synchronized long getAppInstallTime(Context context, long now) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        return prefs.getLong(KEY_APP_INSTALL_TIME, now);
    }

    public static synchronized void setLastSuccessAnalyticsFlush(Context context, long time) {
        Log.i((String)TAG, (String)("Setting last successful analytics flush time to: " + time));
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putLong(KEY_LAST_SUCCESSFUL_ANALYTICS_FLUSH, time);
        edit.commit();
    }

    public static synchronized long getLastUserActivityTime(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        if (!prefs.contains(KEY_LAST_USER_ACTIVITY)) {
            AniwaysServiceUtils.setLastUserActivityTime(context, System.currentTimeMillis());
        }
        return prefs.getLong(KEY_LAST_USER_ACTIVITY, System.currentTimeMillis());
    }

    public static synchronized void setLastUserActivityTime(Context context, long time) {
        Log.i((String)TAG, (String)("Setting last user activity time to: " + time));
        SharedPreferences prefs = context.getSharedPreferences(KEY_LAST_USER_ACTIVITY, Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putLong(KEY_LAST_USER_ACTIVITY, time);
        edit.commit();
    }

    public static synchronized long getLastSuccessAnalyticsFlush(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFERENCES, Utils.getSharedPreferencesFlags());
        return prefs.getLong(KEY_LAST_SUCCESSFUL_ANALYTICS_FLUSH, 0L);
    }

    public static boolean shouldPerformSync(Context context) {
        long elapsedTimeFromLastUpdate;
        boolean shouldSync;
        boolean isActiveUser;
        AniwaysPrivateConfig aniwaysPrivateConfig = AniwaysPrivateConfig.getInstance();
        if (AniwaysServiceUtils.isServiceRunning(context)) {
            Log.i((String)TAG, (String)"Not performing sync since service is running");
            return false;
        }
        if (aniwaysPrivateConfig.forceUpdate) {
            Log.i((String)TAG, (String)"Performing sync since forceUpdate = true");
            return true;
        }
        long timeFromLastUserActivity = System.currentTimeMillis() - AniwaysServiceUtils.getLastUserActivityTime(context);
        boolean bl = isActiveUser = timeFromLastUserActivity <= aniwaysPrivateConfig.timeFromLastMessageBeforeStopSyncing;
        if (!isActiveUser) {
            Log.i((String)TAG, (String)("Not performing sync since user is not active. Time from last user activity: " + timeFromLastUserActivity + ". Threshold: " + aniwaysPrivateConfig.timeFromLastMessageBeforeStopSyncing));
            return false;
        }
        boolean keywordsVersionIsZero = "0.0".equalsIgnoreCase(AniwaysPhraseReplacementData.getParsedKeywordsVersion(context));
        if (keywordsVersionIsZero) {
            Log.i((String)TAG, (String)"Performing sync since keywords version is zero");
            return true;
        }
        long updateInterval = aniwaysPrivateConfig.syncAlarmScheduleInterval;
        if (aniwaysPrivateConfig.restrictDataUsage && !AniwaysServiceUtils.isConnectedToWifi(context)) {
            Log.v((String)TAG, (String)"Restricted data usage update interval used");
            updateInterval = aniwaysPrivateConfig.syncAlarmScheduleIntervalRestricted;
        }
        boolean bl2 = shouldSync = (elapsedTimeFromLastUpdate = System.currentTimeMillis() - AniwaysServiceUtils.getLastSuccessfulUpdate(context)) >= updateInterval;
        if (!shouldSync) {
            Log.i((String)TAG, (String)("Not performing sync since not enough time passed since last update: " + elapsedTimeFromLastUpdate + ". In hours: " + elapsedTimeFromLastUpdate / 3600000L + ". Interval: " + updateInterval + ". In hours: " + updateInterval / 3600000L));
        } else {
            Log.i((String)TAG, (String)("Performing sync since enough time passed since last update: " + elapsedTimeFromLastUpdate + " . In hours: " + elapsedTimeFromLastUpdate / 3600000L + ". Interval: " + updateInterval + ". In hours: " + updateInterval / 3600000L));
        }
        return shouldSync;
    }

    public static boolean shouldPerformFlush(Context context) {
        AniwaysPrivateConfig aniwaysPrivateConfig = AniwaysPrivateConfig.getInstance();
        if (aniwaysPrivateConfig.restrictDataUsage) {
            long elapsedTimeFromLastFlush = System.currentTimeMillis() - AniwaysServiceUtils.getLastSuccessAnalyticsFlush(context);
            return AniwaysServiceUtils.isConnectedToWifi(context) || elapsedTimeFromLastFlush > aniwaysPrivateConfig.analyticsFlushIntervalRestricted;
        }
        return true;
    }

    private static boolean isConnectedToWifi(Context context) {
        if (0 == context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo mWifi = connManager.getNetworkInfo(1);
            return mWifi.isConnected();
        }
        Log.e((String)TAG, (String)"ACCESS_NETWORK_STATE permission not granted");
        return false;
    }
}

