/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStatics;
import com.aniways.service.AlarmListener;
import com.aniways.service.AlarmReceiver;
import com.aniways.service.AniwaysAlarmListener;
import com.aniways.service.utils.AniwaysServiceUtils;

public abstract class WakefulIntentService
extends IntentService {
    private static final String TAG = "AniwaysWakefulIntentService";
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final int DAY = 86400000;

    public WakefulIntentService(String name) {
        super(name);
        this.setIntentRedelivery(true);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        return 3;
    }

    public void onCreate() {
        super.onCreate();
        try {
            AniwaysStatics.init(this.getApplicationContext(), (Context)this, true);
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Error creating service", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onHandleIntent(Intent intent) {
        try {
            this.doWakefulWork(intent);
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Error handling intent", e);
        }
    }

    protected abstract void doWakefulWork(Intent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendWakefulWork(Context context, Intent intent) {
        context.startService(intent);
    }

    public static void sendWakefulWork(Context context, Class<?> classService, boolean fromAlarm) {
        Log.i(TAG, "Starting request. From alarm=" + fromAlarm);
        Intent intent = new Intent(context, classService);
        if (!fromAlarm) {
            intent.setAction("com.aniways.SYNC_WITH_SERVER");
        }
        WakefulIntentService.sendWakefulWork(context, intent);
    }

    public static void scheduleAlarms(AlarmListener listener, Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, AlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        Intent heartBeatIntent = new Intent(context, AlarmReceiver.class);
        heartBeatIntent.setAction("com.aniways.heartbeat.action");
        PendingIntent heartBeatPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)heartBeatIntent, (int)0);
        Log.i(TAG, "Scheduling alarms");
        long now = System.currentTimeMillis();
        long appInstallTime = AniwaysServiceUtils.getAppInstallTime(context, now);
        long timeUntilNextFullDay = 86400000L;
        if (appInstallTime == now) {
            AlarmReceiver.sendAppInstalledEvent(context, false);
        } else {
            long timeFromInstall = now - appInstallTime;
            long timeFromInstallAfterFullDays = timeFromInstall % 86400000L;
            timeUntilNextFullDay = 86400000L - timeFromInstallAfterFullDays;
        }
        AniwaysAlarmListener alarmListener = new AniwaysAlarmListener();
        alarmListener.sendWakefulWork(context, false);
        listener.scheduleAlarms(alarmManager, pendingIntent, AniwaysPrivateConfig.getInstance().syncAlarmScheduleInterval, AniwaysPrivateConfig.getInstance().syncAlarmScheduleInterval, context, "check for updates from server");
        listener.scheduleAlarms(alarmManager, heartBeatPendingIntent, 86400000L, timeUntilNextFullDay, context, "send app install time event");
    }
}

