/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.quick.action;

import com.aniways.quick.action.IEvent;
import com.aniways.quick.action.IEventListener;
import java.util.HashMap;
import java.util.Map;

public class EventAggregator {
    private static EventAggregator instance;
    private HashMap<String, IEventListener> listeners = new HashMap();

    private EventAggregator() {
    }

    public static EventAggregator getInstance() {
        if (instance == null) {
            instance = new EventAggregator();
        }
        return instance;
    }

    public void register(String key, IEventListener listener) {
        this.listeners.put(key, listener);
    }

    public void unRegister(String key) {
        this.listeners.remove(key);
    }

    public void notify(IEvent event) {
        for (Map.Entry<String, IEventListener> entry : this.listeners.entrySet()) {
            entry.getValue().notify(event);
        }
    }
}

