/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.emoticons.button;

import android.content.Context;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.aniways.AniwaysEditText;
import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker;
import com.aniways.emoticons.button.AniwaysRecentIconsManager;
import com.aniways.emoticons.button.EmoticonCategoriesPagerAdapter;
import com.aniways.emoticons.button.EmoticonsOnDemandPagerAdapterBase;
import com.aniways.viewpagerindicator.TabPageIndicator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class EmoticonAssetsPagerAdapter
extends EmoticonsOnDemandPagerAdapterBase {
    private static final String TAG = "AniwaysEmoticonAssetsPagerAdapter";
    private static final long DELETE_DELAY_MS = 100L;
    private AssetType[] mAssetTypesInOrder;
    private AniwaysLockedIconHelper mLockedIconHelper;
    private AniwaysEmoticonsButtonMaker.LastPagesLocation mLastPagesLocation;
    private List<IconData> mIconsForGenius = null;
    private Context mContext;
    private AniwaysEditText mEditText;
    private Runnable mDeleteRunnable;

    public EmoticonAssetsPagerAdapter(AniwaysLockedIconHelper lockedIconHelper, AniwaysEmoticonsButtonMaker.LastPagesLocation lastPagesLocation, Context context, List<IconData> iconsForGenius, AniwaysEditText editText) {
        super(TAG, EmoticonsOnDemandPagerAdapterBase.AdapterType.Asset, 0, 0, 0, null, -1);
        try {
            this.mLockedIconHelper = lockedIconHelper;
            this.mLastPagesLocation = lastPagesLocation;
            this.mContext = context;
            this.mAssetTypesInOrder = this.mLockedIconHelper.getDataParser().getAssetTypesInOrder();
            if (this.mAssetTypesInOrder == null || this.mAssetTypesInOrder.length == 0) {
                Log.e(true, TAG, "No asset types in parser");
            }
            this.mIconsForGenius = iconsForGenius == null ? new ArrayList() : iconsForGenius;
            this.mEditText = editText;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in constructor", ex);
        }
    }

    public int getCount() {
        if (this.mAssetTypesInOrder == null) {
            return 0;
        }
        return this.mAssetTypesInOrder.length;
    }

    public AssetType getAssetType(int position) {
        try {
            return this.mAssetTypesInOrder[position];
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in getAssetName", ex);
            return AssetType.Unknown;
        }
    }

    @Override
    protected View instantiateItem(View collection) {
        try {
            LayoutInflater inflater = (LayoutInflater)collection.getContext().getSystemService("layout_inflater");
            return inflater.inflate(R.layout.aniways_emoticons_button_popup_icon_categories_pager, null);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in instantiateItem", ex);
            return null;
        }
    }

    @Override
    protected void instantiateItemInternal(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
        View layout2 = holder.view;
        AssetType assetType = this.getAssetType(holder.position);
        AniwaysDirectionalViewPager pager = (AniwaysDirectionalViewPager)layout2.findViewById(R.id.aniways_ebp_icon_categories_pager);
        pager.setOffscreenPageLimit(1);
        holder.pager = pager;
        ArrayList<IconData> filteredGeniusIcons = new ArrayList<IconData>();
        for (IconData icon : this.mIconsForGenius) {
            if (icon.assetType != assetType) continue;
            filteredGeniusIcons.add(icon);
        }
        EmoticonCategoriesPagerAdapter adapter = new EmoticonCategoriesPagerAdapter(this.mLockedIconHelper, this.mLastPagesLocation, assetType, this.mContext, filteredGeniusIcons, this);
        pager.setAdapter(adapter);
        pager.setOrientation(0);
        TabPageIndicator indicator = (TabPageIndicator)layout2.findViewById(R.id.aniways_ebp_icon_categories_pager_indicator);
        indicator.setViewPager(pager);
        indicator.setOnPageChangeListener(new AniwaysDirectionalViewPager.OnPageChangeListener(){

            @Override
            public void onPageScrollStateChanged(int arg0) {
            }

            @Override
            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            @Override
            public void onPageSelected(int categoryPage) {
                try {
                    EmoticonAssetsPagerAdapter.this.mLastPagesLocation.setCategoryPage(categoryPage);
                    Log.i(EmoticonAssetsPagerAdapter.TAG, "Selected category num: " + categoryPage);
                }
                catch (Throwable ex) {
                    Log.e(true, EmoticonAssetsPagerAdapter.TAG, "Caught Exception in onPageSelected", ex);
                }
            }
        });
        if (this.mLastPagesLocation.getSelectedAssetType() == this.mAssetTypesInOrder[holder.position]) {
            indicator.setCurrentItem(this.mLastPagesLocation.getCategoryPage());
            if (!this.mLastPagesLocation.isCurrentCategoryTheRecentsCategory() && adapter.getCount() > this.mLastPagesLocation.getCategoryPage()) {
                this.mLastPagesLocation.reportScreenViewEvent();
                indicator.setCurrentItem(this.mLastPagesLocation.getCategoryPage());
            } else if (adapter.getCount() > 1 && AniwaysRecentIconsManager.isEmpty(assetType) && filteredGeniusIcons.size() == 0) {
                indicator.setCurrentItem(1);
            } else if (adapter.getCount() > 0 && adapter.getCategoryName(0).equalsIgnoreCase("Recent")) {
                this.mLastPagesLocation.reportScreenViewEvent();
                indicator.setCurrentItem(0);
            }
        } else if (adapter.getCount() > 1 && AniwaysRecentIconsManager.isEmpty(assetType) && filteredGeniusIcons.size() == 0) {
            indicator.setCurrentItem(1);
        } else if (adapter.getCount() > 0 && adapter.getCategoryName(0).equalsIgnoreCase("Recent")) {
            this.mLastPagesLocation.reportScreenViewEvent();
            indicator.setCurrentItem(0);
        }
        if (this.mEditText != null) {
            ImageView backSpace = (ImageView)layout2.findViewById(R.id.aniways_ebp_backspace_button);
            this.setupBackspace(backSpace);
        }
        holder.instantiated = true;
    }

    @Override
    protected void onHolderCreated(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
    }

    public CharSequence getPageTitle(int position) {
        return this.mAssetTypesInOrder[position].toString().toUpperCase(Locale.getDefault());
    }

    private void setupBackspace(final ImageView backSpace) {
        this.mDeleteRunnable = new NonThrowingRunnable(TAG, "while deleting in long press", ""){

            @Override
            public void innerRun() {
                if (backSpace.isPressed()) {
                    KeyEvent event = new KeyEvent(0L, 0L, 0, 67, 0, 0, 0, 0, 6);
                    EmoticonAssetsPagerAdapter.this.mEditText.dispatchKeyEvent(event);
                    backSpace.postDelayed(EmoticonAssetsPagerAdapter.this.mDeleteRunnable, 100L);
                }
            }
        };
        backSpace.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                try {
                    backSpace.postDelayed(EmoticonAssetsPagerAdapter.this.mDeleteRunnable, 100L);
                }
                catch (Throwable ex) {
                    Log.e(true, EmoticonAssetsPagerAdapter.TAG, "Caught Exception in long click of backspace", ex);
                }
                return false;
            }
        });
        backSpace.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                try {
                    if (event.getAction() == 0) {
                        KeyEvent newEvent = new KeyEvent(event.getDownTime(), event.getEventTime(), event.getAction(), 67, 0);
                        EmoticonAssetsPagerAdapter.this.mEditText.dispatchKeyEvent(newEvent);
                    }
                }
                catch (Throwable ex) {
                    Log.e(true, EmoticonAssetsPagerAdapter.TAG, "Caught Exception in backspace onTouch", ex);
                }
                return false;
            }
        });
    }
}

