/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.data.Chars;
import com.aniways.data.Phrase;
import java.util.Locale;

public class PhraseWithPartToReplace
extends Phrase {
    private static final String TAG = "AniwaysPhraseWithPartToReplace";
    private static final long serialVersionUID = 1L;
    private int startOfPartToReplace;
    private int lengthOfPartToReplace;

    public PhraseWithPartToReplace(Chars chars, int start, int length, int startOfPartToReplace, int lengthOfPartToReplace, IconData[] icons) {
        super(chars, start, length, icons);
        if (startOfPartToReplace < 0 || lengthOfPartToReplace < 1 || startOfPartToReplace + lengthOfPartToReplace > length) {
            Log.e(true, TAG, "Illegal params for part to replace. start: " + start + ". length: " + length + ". startOfPartToReplace: " + startOfPartToReplace + ". lengthOfPartToReplace: " + lengthOfPartToReplace);
        }
        this.startOfPartToReplace = startOfPartToReplace;
        this.lengthOfPartToReplace = lengthOfPartToReplace;
    }

    public PhraseWithPartToReplace(String name, String partToReplace, IconData icon) {
        super(name, icon);
        this.startOfPartToReplace = name.toLowerCase(Locale.US).indexOf(partToReplace.toLowerCase(Locale.US));
        this.lengthOfPartToReplace = partToReplace.length();
        if (this.startOfPartToReplace < 0 || this.lengthOfPartToReplace < 1 || this.startOfPartToReplace + this.lengthOfPartToReplace > this.length) {
            Log.e(true, TAG, "Illegal params for part to replace from strings. name: " + name + ". partToReplace:  " + partToReplace + ". start: " + this.start + ". length: " + this.length + ". startOfPartToReplace: " + this.startOfPartToReplace + ". lengthOfPartToReplace: " + this.lengthOfPartToReplace);
        }
    }

    @Override
    public String getPartToReplace() {
        return this.getName().substring(this.startOfPartToReplace, this.startOfPartToReplace + this.lengthOfPartToReplace);
    }

    @Override
    public int getIndexOfPartToReplaceInPhrase() {
        return this.startOfPartToReplace;
    }

    @Override
    public int getLengthOfPartToReplace() {
        return this.lengthOfPartToReplace;
    }

    @Override
    public int getEndOfPartToReplace() {
        return this.startOfPartToReplace + this.lengthOfPartToReplace;
    }

    @Override
    public boolean isFullReplacement() {
        return false;
    }
}

