/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ObjectSerializer {
    public static String serialize(Serializable obj) throws Exception {
        if (obj == null) {
            return "";
        }
        ByteArrayOutputStream serialObj = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(serialObj);
        objStream.writeObject(obj);
        objStream.close();
        return ObjectSerializer.encodeBytes(serialObj.toByteArray());
    }

    public static Object deserialize(String str) throws Exception {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayInputStream serialObj = new ByteArrayInputStream(ObjectSerializer.decodeBytes(str));
        ObjectInputStream objStream = new ObjectInputStream(serialObj);
        return objStream.readObject();
    }

    public static String encodeBytes(byte[] bytes) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            strBuf.append((char)((bytes[i] >> 4 & 0xF) + 97));
            strBuf.append((char)((bytes[i] & 0xF) + 97));
        }
        return strBuf.toString();
    }

    public static byte[] decodeBytes(String str) {
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < str.length(); i += 2) {
            char c = str.charAt(i);
            bytes[i / 2] = (byte)(c - 97 << 4);
            c = str.charAt(i + 1);
            int n = i / 2;
            bytes[n] = (byte)(bytes[n] + (c - 97));
        }
        return bytes;
    }
}

