/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import aniways.com.google.gson.Gson;
import aniways.com.google.gson.reflect.TypeToken;
import aniways.com.google.gson.stream.JsonReader;
import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AnimatedGifsDataForPhrase;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Chars;
import com.aniways.data.EmojiHashSet;
import com.aniways.data.IconDataFactory;
import com.aniways.data.IconsHashSet;
import com.aniways.data.KeywordsFile;
import com.aniways.data.Phrase;
import com.aniways.data.PhraseWithPartToReplace;
import com.aniways.data.PhrasesHashSet;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonParser {
    private static final String TAG = "AniwaysKeywordsJsonParser";
    private static final String REVERT_TO_TEXT_ICON_NAME = "revert_to_text.png";
    private static final String UNKNOWN = "UNKNOWN";
    private IconsHashSet mIcons;
    private IconsHashSet mCommercialIcons;
    private EmojiHashSet mEmoji;
    private EmojiHashSet mEmojiWithVarientSelector;
    private PhrasesHashSet mPhrases;
    private PhrasesHashSet mCommercialPhrases;
    private Chars mChars;
    private Chars mCommercialChars;
    private LinkedHashMap<AssetType, LinkedHashMap<String, LinkedHashMap<String, List<IconData>>>> mAssetsCategoriesFamiliesIcons;
    private KeywordsFile mKeywordsFile;
    static JsonParser emptyInstance = new JsonParser();

    public JsonParser() {
        this.init();
    }

    void parseDataFile(InputStreamProvider inputStreamProvider) throws FileNotFoundException {
        if (inputStreamProvider == null) {
            Log.e(true, TAG, "Received null input stream provider, not parsing.");
            return;
        }
        InputStream inputStream = inputStreamProvider.getStream();
        if (inputStream == null) {
            Log.e(true, TAG, "Received null input stream, not parsing.");
            return;
        }
        KeywordsFile keywordsFile = null;
        try {
            long startTime = System.currentTimeMillis();
            String jsontext = this.loadTextFile(inputStream);
            long jsonTextLength = jsontext.length();
            if (TextUtils.isEmpty((CharSequence)jsontext)) {
                Log.e(true, TAG, "Empty json text, doing nothig");
                return;
            }
            keywordsFile = KeywordsFile.parseFromJson(jsontext);
            this.extractInfoFromKeywordsFile(keywordsFile);
            if (AnalyticsReporter.isInitialized()) {
                AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, startTime, "Performance", "Create Data From Json with gson", "num Json chars: " + jsonTextLength, TAG, "num chars");
            }
            return;
        }
        catch (OutOfMemoryError ex) {
            Log.w(true, TAG, "Received out of memory error while parsing json - trying to parse stream. Version is: " + (keywordsFile == null ? "null" : keywordsFile.version), ex);
            keywordsFile = null;
            try {
                long startTime = System.currentTimeMillis();
                this.init();
                try {
                    inputStream.close();
                }
                catch (Throwable tr) {
                    // empty catch block
                }
                inputStream = inputStreamProvider.getStream();
                if (inputStream == null) {
                    Log.e(true, TAG, "Received null input stream after out of mem error, not parsing.");
                    return;
                }
                this.parseStream(inputStream);
                if (AnalyticsReporter.isInitialized()) {
                    AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, startTime, "Performance", "Create Data From Json from stream", "num Json chars: unknown", TAG, "num chars");
                }
                return;
            }
            catch (Throwable ex2) {
                Log.e(true, TAG, "Could not parse keywords JSON from stream after out of memory!! Version is: " + (keywordsFile == null ? "null" : keywordsFile.version), ex2);
                this.init();
                return;
            }
        }
        catch (Throwable ex) {
            Log.w(true, TAG, "Could not parse keywords JSON!! with gson. Trying manually. Version is: " + (keywordsFile == null ? "null" : keywordsFile.version), ex);
            keywordsFile = null;
            try {
                long startTime = System.currentTimeMillis();
                this.init();
                try {
                    inputStream.close();
                }
                catch (Throwable tr) {
                    // empty catch block
                }
                inputStream = inputStreamProvider.getStream();
                if (inputStream == null) {
                    Log.e(true, TAG, "Received null input stream after error, not parsing.");
                    return;
                }
                String jsontext = this.loadTextFile(inputStream);
                long jsonTextLength = jsontext.length();
                if (TextUtils.isEmpty((CharSequence)jsontext)) {
                    Log.i(TAG, "Empty json text, doing nothig");
                    return;
                }
                keywordsFile = this.parseManually(jsontext);
                this.extractInfoFromKeywordsFile(keywordsFile);
                if (AnalyticsReporter.isInitialized()) {
                    AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, startTime, "Performance", "Create Data From Json manually", "num Json chars: " + jsonTextLength, TAG, "num chars");
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, TAG, "Finished manual parse successfully after Exception: " + ex.getMessage(), keywordsFile.version, 0L);
                }
                return;
            }
            catch (OutOfMemoryError ex2) {
                Log.w(true, TAG, "Received out of memory error while parsing json manually - trying to parse stream. Version is: " + (keywordsFile == null ? "null" : keywordsFile.version), ex2);
                keywordsFile = null;
                try {
                    long startTime = System.currentTimeMillis();
                    this.init();
                    try {
                        inputStream.close();
                    }
                    catch (Throwable tr) {
                        // empty catch block
                    }
                    inputStream = inputStreamProvider.getStream();
                    if (inputStream == null) {
                        Log.e(true, TAG, "Received null input stream after out of mem error when parsing manually, not parsing.");
                        return;
                    }
                    this.parseStream(inputStream);
                    if (AnalyticsReporter.isInitialized()) {
                        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, startTime, "Performance", "Create Data From Json from stream after oom exception when parsing manually", "num Json chars: unknown", TAG, "num chars");
                    }
                    return;
                }
                catch (Throwable ex3) {
                    Log.e(true, TAG, "Could not parse keywords JSON from stream after out of memory when trying to parse manually!! Version is: " + (keywordsFile == null ? "null" : keywordsFile.version), ex3);
                    this.init();
                    return;
                }
            }
            catch (Throwable ex2) {
                Log.w(true, TAG, "Received error while parsing json manually - trying to parse stream. Version is: " + (keywordsFile == null ? "null" : keywordsFile.version), ex2);
                keywordsFile = null;
                try {
                    long startTime = System.currentTimeMillis();
                    this.init();
                    try {
                        inputStream.close();
                    }
                    catch (Throwable tr) {
                        // empty catch block
                    }
                    inputStream = inputStreamProvider.getStream();
                    if (inputStream == null) {
                        Log.e(true, TAG, "Received null input stream after error when parsing manually, not parsing.");
                        return;
                    }
                    this.parseStream(inputStream);
                    if (AnalyticsReporter.isInitialized()) {
                        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, startTime, "Performance", "Create Data From Json from stream after exception when parsing manually", "num Json chars: unknown", TAG, "num chars");
                        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, TAG, "Finished stream parse successfully after Exception in manual parse: " + ex2.getMessage(), this.mKeywordsFile.version, 0L);
                    }
                    return;
                }
                catch (Throwable ex3) {
                    Log.e(true, TAG, "Could not parse keywords JSON from stream after error when trying to parse manually!! Version is: " + (keywordsFile == null ? "null" : keywordsFile.version), ex3);
                    this.init();
                    return;
                }
            }
        }
    }

    @SuppressLint(value={"UseSparseArrays"})
    private void extractInfoFromKeywordsFile(KeywordsFile keywordsFile) throws IOException {
        if (keywordsFile.version == null) {
            Log.e(true, TAG, "No kw version definition in kw file");
            keywordsFile = new KeywordsFile();
        }
        if (keywordsFile.superCategoriesToIcons == null || !keywordsFile.version.equalsIgnoreCase("0.0") && keywordsFile.superCategoriesToIcons.isEmpty()) {
            Log.e(true, TAG, "No super categories to tab icons definition in kw file with version: " + keywordsFile.version);
            keywordsFile.superCategoriesToIcons = new LinkedHashMap();
        }
        if (keywordsFile.primaryPhrases == null || !keywordsFile.version.equalsIgnoreCase("0.0") && keywordsFile.primaryPhrases.isEmpty()) {
            Log.e(true, TAG, "No primary phrases definition in kw file with version: " + keywordsFile.version);
            keywordsFile.primaryPhrases = new HashMap();
        }
        if (keywordsFile.lockedIcons == null) {
            Log.w(keywordsFile.lockedIcons == null, TAG, "No locked icons definition in kw file with version: " + keywordsFile.version);
            keywordsFile.lockedIcons = new long[0];
        }
        if (keywordsFile.phrasesToIcons == null || !keywordsFile.version.equalsIgnoreCase("0.0") && keywordsFile.phrasesToIcons.isEmpty()) {
            Log.e(true, TAG, "No phrases to icons definition in kw file with version: " + keywordsFile.version);
            keywordsFile.phrasesToIcons = new HashMap();
        }
        if (keywordsFile.iconFamilies == null || !keywordsFile.version.equalsIgnoreCase("0.0") && keywordsFile.iconFamilies.isEmpty()) {
            Log.e(true, TAG, "No families definition in kw file with version: " + keywordsFile.version);
            keywordsFile.iconFamilies = new HashMap();
        }
        if (keywordsFile.iconIdsToEmojiUnicodes == null || !keywordsFile.version.equalsIgnoreCase("0.0") && keywordsFile.iconIdsToEmojiUnicodes.isEmpty()) {
            Log.e(true, TAG, "No icon ids to emojis definition in kw file with version: " + keywordsFile.version);
            keywordsFile.iconIdsToEmojiUnicodes = new HashMap();
        }
        if (keywordsFile.superCategoriesToIconFamilies == null || !keywordsFile.version.equalsIgnoreCase("0.0") && keywordsFile.superCategoriesToIconFamilies.isEmpty()) {
            Log.e(true, TAG, "No super categories to icon families definition in kw file with version: " + keywordsFile.version);
            keywordsFile.superCategoriesToIconFamilies = new LinkedHashMap();
        }
        if (keywordsFile.phrasesToCommercialIcons == null) {
            Log.e(true, TAG, "No phrases to commercial icons defined in kw file with version: " + keywordsFile.version);
            keywordsFile.phrasesToCommercialIcons = new HashMap();
        }
        if (keywordsFile.phraseToAnimatedGifs == null) {
            Log.e(true, TAG, "No phrase To Animated Gifs defined in kw file with version: " + keywordsFile.version);
            keywordsFile.phraseToAnimatedGifs = new HashMap();
        }
        if (keywordsFile.iconsCount < 0) {
            keywordsFile.iconsCount = 0;
            for (ArrayList<Long> value : keywordsFile.iconFamilies.values()) {
                keywordsFile.iconsCount += value.size();
            }
        }
        this.parseIconFamilies(keywordsFile);
        if (keywordsFile.numPhrases < 0) {
            keywordsFile.numPhrases = keywordsFile.phrasesToIcons.size();
        }
        if (keywordsFile.numPhraseChars < 0) {
            keywordsFile.numPhraseChars = keywordsFile.numPhrases * 10;
        }
        this.parsePhrases(keywordsFile, null, null);
        this.parsePrimaryPhrases(keywordsFile);
        this.parseLockedIcons(keywordsFile);
        this.parseSuperCategoriesToIconFamilies(keywordsFile);
        this.parseCommercialPhrases(keywordsFile);
        this.parsePhraseToAnimatedGifs(keywordsFile);
        this.nullLeftovers(keywordsFile);
        this.mKeywordsFile = keywordsFile;
    }

    private void parsePhraseToAnimatedGifs(KeywordsFile keywordsFile) {
        if (keywordsFile.phraseToAnimatedGifs == null || keywordsFile.phraseToAnimatedGifs.isEmpty()) {
            this.addDefaultAnimatedGifProviderToPhrase();
            return;
        }
        if (this.mPhrases == null) {
            return;
        }
        for (Map.Entry<String, HashMap<String, String[]>> entry : keywordsFile.phraseToAnimatedGifs.entrySet()) {
            String key = entry.getKey();
            HashMap<String, String[]> value = entry.getValue();
            Phrase phrase = this.mPhrases.get(key);
            if (phrase == null) continue;
            phrase.animatedGifs = new AnimatedGifsDataForPhrase(value);
        }
    }

    private void addDefaultAnimatedGifProviderToPhrase() {
        if (!AniwaysPrivateConfig.getInstance().addDefaultPhraseToAnimatedGif) {
            return;
        }
        if (this.mPhrases == null) {
            return;
        }
        for (Phrase phrase : this.mPhrases) {
            phrase.animatedGifs = AnimatedGifsDataForPhrase.SEARCH_PHRASE_IN_ALL_PROVIDERS;
        }
    }

    private void parseSuperCategoriesToIconFamilies(KeywordsFile keywordsFile) {
        String catName;
        LinkedHashMap oldCategoriesToIconFamilies = new LinkedHashMap();
        for (Map.Entry<String, LinkedHashMap<String, Long[]>> entry : keywordsFile.superCategoriesToIconFamilies.entrySet()) {
            catName = entry.getKey();
            LinkedHashMap<String, Long[]> familiesToIcons = entry.getValue();
            LinkedHashMap<String, IconData[]> familiesToIconDatas = new LinkedHashMap<String, IconData[]>();
            for (Map.Entry<String, Long[]> entry2 : familiesToIcons.entrySet()) {
                String familyName = entry2.getKey();
                Long[] iconIds = entry2.getValue();
                int numIcons = iconIds.length;
                IconData[] icons = new IconData[numIcons];
                for (int i = 0; i < numIcons; ++i) {
                    IconData icon = this.mIcons.get(iconIds[i].intValue());
                    if (icon == null) {
                        Log.e(true, TAG, "Null icon: " + iconIds[i].intValue());
                    }
                    icons[i] = icon;
                }
                familiesToIconDatas.put(familyName, icons);
            }
            oldCategoriesToIconFamilies.put(catName, familiesToIconDatas);
        }
        for (Map.Entry<String, LinkedHashMap<String, Object>> entry : oldCategoriesToIconFamilies.entrySet()) {
            catName = entry.getKey();
            LinkedHashMap<String, Object> originalFamiliesToIcons = entry.getValue();
            for (Map.Entry<String, Object> originalFamilyToIcons : originalFamiliesToIcons.entrySet()) {
                IconData[] originalFamilyIcons = (IconData[])originalFamilyToIcons.getValue();
                for (int i = 0; i < originalFamilyIcons.length; ++i) {
                    String familyName;
                    List<IconData> familyIcons;
                    LinkedHashMap<String, List<IconData>> familiesToIcons;
                    AssetType currentAsset = originalFamilyIcons[i].assetType;
                    LinkedHashMap<String, LinkedHashMap<String, List<IconData>>> categoriesToFamiliesAndIcons = this.mAssetsCategoriesFamiliesIcons.get((Object)currentAsset);
                    if (categoriesToFamiliesAndIcons == null) {
                        categoriesToFamiliesAndIcons = new LinkedHashMap();
                        LinkedHashMap recentCategory = new LinkedHashMap();
                        recentCategory.put("Default", new ArrayList());
                        categoriesToFamiliesAndIcons.put("Recent", recentCategory);
                        this.mAssetsCategoriesFamiliesIcons.put(originalFamilyIcons[i].assetType, categoriesToFamiliesAndIcons);
                    }
                    if ((familiesToIcons = categoriesToFamiliesAndIcons.get(catName)) == null) {
                        familiesToIcons = new LinkedHashMap();
                        categoriesToFamiliesAndIcons.put(catName, familiesToIcons);
                    }
                    if ((familyIcons = familiesToIcons.get(familyName = originalFamilyToIcons.getKey())) == null) {
                        familyIcons = new ArrayList<IconData>();
                        familiesToIcons.put(familyName, familyIcons);
                    }
                    familyIcons.add(originalFamilyIcons[i]);
                }
            }
        }
        keywordsFile.superCategoriesToIconFamilies = null;
    }

    private void parseLockedIcons(KeywordsFile keywordsFile) {
        long[] arr$ = keywordsFile.lockedIcons;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long iconId = arr$[i$];
            IconData icon = this.mIcons.get(iconId.intValue());
            icon.isLocked = true;
        }
        keywordsFile.lockedIcons = null;
    }

    private void parsePrimaryPhrases(KeywordsFile keywordsFile) {
        for (Map.Entry<Long, String> entry : keywordsFile.primaryPhrases.entrySet()) {
            Long iconId = entry.getKey();
            String phraseName = entry.getValue();
            if (phraseName == null) {
                Log.w(false, TAG, "Phrase is null for icon id: " + iconId);
                continue;
            }
            Phrase phrase = this.mPhrases.get(phraseName);
            IconData icon = this.mIcons.get(iconId.intValue());
            if (icon == null) {
                Log.e(true, TAG, "Null icon found when parsing primary phrases: " + iconId.intValue() + " . Phrase: " + phrase);
                int id2 = iconId.intValue();
                boolean isEmoji = this.isEmoji(keywordsFile, id2);
                IconData newIcon = IconDataFactory.iconData(iconId, UNKNOWN, keywordsFile, isEmoji);
                this.mIcons.put(newIcon);
                if (isEmoji) {
                    this.mEmoji.put(newIcon);
                }
            }
            if (phrase == null) {
                phrase = new Phrase(phraseName, icon);
            }
            icon.primaryPhrase = phrase;
        }
    }

    private void parseCommercialPhrases(KeywordsFile keywordsFile) {
        if (this.noCommercialDatasToParse(keywordsFile)) {
            return;
        }
        int commercialPhrasesLength = keywordsFile.numOfCommercialPhrases;
        this.mCommercialIcons = new IconsHashSet(keywordsFile.commercialIconsCount);
        this.mCommercialPhrases = new PhrasesHashSet(commercialPhrasesLength);
        this.mCommercialChars = new Chars();
        this.mCommercialChars.chars = new char[commercialPhrasesLength * 20];
        for (Map.Entry<String, Long> entry : keywordsFile.phrasesToCommercialIcons.entrySet()) {
            this.parseCommercialPhrase(keywordsFile, entry);
        }
    }

    private void parseCommercialPhrase(KeywordsFile keywordsFile, Map.Entry<String, Long> commercialPharse) {
        String phraseName = commercialPharse.getKey();
        Long iconId = commercialPharse.getValue();
        IconData icon = this.mCommercialIcons.get(iconId.intValue());
        if (icon == null) {
            boolean isEmoji = this.isEmoji(keywordsFile, iconId.intValue());
            icon = IconDataFactory.iconData(iconId, UNKNOWN, keywordsFile, isEmoji);
            this.mCommercialIcons.put(icon);
        }
        int nameStartInArray = this.mCommercialChars.size;
        int nameLength = phraseName.length();
        this.mCommercialChars.add(phraseName);
        Phrase p = new Phrase(this.mCommercialChars, nameStartInArray, nameLength, new IconData[]{icon});
        this.mCommercialPhrases.put(p);
    }

    private boolean noCommercialDatasToParse(KeywordsFile keywordsFile) {
        return keywordsFile.numOfCommercialPhrases <= 0 || keywordsFile.commercialIconsCount <= 0;
    }

    private void parsePhrases(KeywordsFile keywordsFile, JsonReader jsonReader, Gson gson) throws IOException {
        this.mChars = new Chars();
        if (keywordsFile.numPhrases < 0) {
            throw new IllegalArgumentException("numPhrases < 0");
        }
        if (keywordsFile.numPhraseChars < 0) {
            throw new IllegalArgumentException("numPhraseChars < 0");
        }
        this.mPhrases = new PhrasesHashSet(keywordsFile.numPhrases);
        this.mChars.chars = new char[keywordsFile.numPhrases * 10];
        if (jsonReader == null) {
            for (Map.Entry<String, HashMap<String, Long[]>> entry : keywordsFile.phrasesToIcons.entrySet()) {
                String phraseName = entry.getKey();
                HashMap<String, Long[]> subPhrasesToIcons = entry.getValue();
                this.parsePhrase(keywordsFile, phraseName, subPhrasesToIcons);
            }
            keywordsFile.phrasesToIcons = null;
            this.mChars.trim();
            Log.i(TAG, "Num of chars: " + this.mChars.size);
        } else {
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String phraseName = jsonReader.nextName();
                HashMap subPhrasesToIcons = (HashMap)gson.fromJson(jsonReader, new TypeToken<HashMap<String, Long[]>>(){}.getType());
                this.parsePhrase(keywordsFile, phraseName, subPhrasesToIcons);
            }
            jsonReader.endObject();
            this.mChars.trim();
            Log.i(TAG, "Num of chars: " + this.mChars.size);
        }
    }

    private void parsePhrase(KeywordsFile keywordsFile, String phraseName, HashMap<String, Long[]> subPhrasesToIcons) {
        if (subPhrasesToIcons != null && !subPhrasesToIcons.isEmpty()) {
            for (Map.Entry<String, Long[]> entry2 : subPhrasesToIcons.entrySet()) {
                String subPhrase = entry2.getKey();
                Long[] iconIds = entry2.getValue();
                int numIcons = iconIds.length;
                IconData[] icons = new IconData[numIcons];
                for (int i = 0; i < numIcons; ++i) {
                    IconData icon = this.mIcons.get(iconIds[i].intValue());
                    if (icon == null) {
                        Log.e(true, TAG, "Null icon: " + iconIds[i].intValue());
                        int id2 = iconIds[i].intValue();
                        boolean isEmoji = this.isEmoji(keywordsFile, id2);
                        icon = IconDataFactory.iconData(iconIds[i], UNKNOWN, keywordsFile, isEmoji);
                    }
                    icons[i] = icon;
                }
                int nameStartInArray = this.mChars.size;
                int nameLength = phraseName.length();
                this.mChars.add(phraseName);
                Phrase p = null;
                if (subPhrase.length() == 0) {
                    p = new Phrase(this.mChars, nameStartInArray, nameLength, icons);
                } else {
                    int startOfSubPhrase = phraseName.indexOf(subPhrase);
                    if (startOfSubPhrase == -1) {
                        Log.e(true, TAG, "Start index of subphrase < -1: name: " + phraseName + " . ptr: " + subPhrase);
                        continue;
                    }
                    int lengthOfSubphrase = subPhrase.length();
                    if (startOfSubPhrase == 0 && lengthOfSubphrase == nameLength) {
                        Log.w(true, TAG, "Discovered subphrase equals to phrase. Name: " + phraseName + " . Sub: " + subPhrase);
                        p = new Phrase(this.mChars, nameStartInArray, nameLength, icons);
                    } else {
                        p = new PhraseWithPartToReplace(this.mChars, nameStartInArray, nameLength, startOfSubPhrase, lengthOfSubphrase, icons);
                    }
                }
                this.mPhrases.put(p);
            }
        } else if (!phraseName.equals(REVERT_TO_TEXT_ICON_NAME)) {
            Log.w(true, TAG, "No icons for phrase with name: " + phraseName + " in kw file with version: " + keywordsFile.version);
        }
    }

    private boolean isEmoji(KeywordsFile keywordsFile, int id2) {
        return (long)id2 >= keywordsFile.emojiMinIndex && (long)id2 <= keywordsFile.emojiMaxIndex;
    }

    private void parseIconFamilies(KeywordsFile keywordsFile) {
        if (keywordsFile.iconsCount < 0) {
            throw new IllegalArgumentException("icons count < 0");
        }
        this.mIcons = new IconsHashSet(keywordsFile.iconsCount);
        this.mEmoji = new EmojiHashSet(keywordsFile.numberOfEmojis);
        this.mEmojiWithVarientSelector = new EmojiHashSet(keywordsFile.numberOfEmojis);
        for (Map.Entry<String, ArrayList<Long>> entry : keywordsFile.iconFamilies.entrySet()) {
            String familyName = entry.getKey();
            for (Long icon : entry.getValue()) {
                int id2 = icon.intValue();
                boolean isEmoji = this.isEmoji(keywordsFile, id2);
                IconData newIcon = IconDataFactory.iconData(icon, familyName, keywordsFile, isEmoji);
                this.mIcons.put(newIcon);
                if (!isEmoji) continue;
                this.mEmoji.put(newIcon);
            }
        }
        keywordsFile.iconFamilies = null;
    }

    static String getVersionFromStream(InputStream stream) {
        String result = null;
        try {
            String name;
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream, "UTF-8"));
            jsonReader.beginObject();
            if (jsonReader.hasNext() && (name = jsonReader.nextName()).equals("version")) {
                result = jsonReader.nextString();
                Log.d(TAG, "Discovered version: " + result);
            }
            jsonReader.close();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught exception while trying to get version from stream", ex);
        }
        return result;
    }

    private void parseStream(InputStream stream) throws IOException {
        Gson gson = new Gson();
        KeywordsFile file = new KeywordsFile();
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream, "UTF-8"));
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String name = jsonReader.nextName();
            if (name.equals("version")) {
                file.version = jsonReader.nextString();
                continue;
            }
            if (name.equals("iconsCount")) {
                file.iconsCount = jsonReader.nextInt();
                continue;
            }
            if (name.equals("numberOfEmojis")) {
                file.numberOfEmojis = jsonReader.nextInt();
                continue;
            }
            if (name.equals("emojiMinIndex")) {
                file.emojiMinIndex = jsonReader.nextLong();
                continue;
            }
            if (name.equals("emojiMaxIndex")) {
                file.emojiMaxIndex = jsonReader.nextLong();
                continue;
            }
            if (name.equals("iconsToExternalApps")) {
                file.iconsToExternalApps = (HashMap)gson.fromJson(jsonReader, new TypeToken<HashMap<Long, String>>(){}.getType());
                continue;
            }
            if (name.equals("iconsToExternalWebsite")) {
                file.iconsToExternalWebsite = (HashMap)gson.fromJson(jsonReader, new TypeToken<HashMap<Long, String>>(){}.getType());
                continue;
            }
            if (name.equals("iconIdsToEmojiUnicodes")) {
                file.iconIdsToEmojiUnicodes = (HashMap)gson.fromJson(jsonReader, new TypeToken<HashMap<Long, String>>(){}.getType());
                continue;
            }
            if (name.equals("animatedGifs")) {
                ArrayList temp = (ArrayList)gson.fromJson(jsonReader, new TypeToken<ArrayList<Long>>(){}.getType());
                file.animatedGifs.addAll(temp);
                continue;
            }
            if (name.equals("iconFamilies")) {
                file.iconFamilies = (HashMap)gson.fromJson(jsonReader, new TypeToken<HashMap<String, ArrayList<Long>>>(){}.getType());
                this.parseIconFamilies(file);
                continue;
            }
            if (name.equals("numPhrases")) {
                file.numPhrases = jsonReader.nextInt();
                continue;
            }
            if (name.equals("numPhraseChars")) {
                file.numPhraseChars = jsonReader.nextInt();
                continue;
            }
            if (name.equals("commercialIconsCount")) {
                file.commercialIconsCount = jsonReader.nextInt();
                continue;
            }
            if (name.equals("numOfCommercialPhrases")) {
                file.numOfCommercialPhrases = jsonReader.nextInt();
                continue;
            }
            if (name.equals("phrasesToIcons")) {
                this.parsePhrases(file, jsonReader, gson);
                continue;
            }
            if (name.equals("primaryPhrases")) {
                file.primaryPhrases = (HashMap)gson.fromJson(jsonReader, new TypeToken<HashMap<Long, String>>(){}.getType());
                this.parsePrimaryPhrases(file);
                continue;
            }
            if (name.equals("lockedIcons")) {
                file.lockedIcons = (long[])gson.fromJson(jsonReader, new TypeToken<long[]>(){}.getType());
                this.parseLockedIcons(file);
                continue;
            }
            if (name.equals("superCategoriesToIconFamilies")) {
                file.superCategoriesToIconFamilies = (LinkedHashMap)gson.fromJson(jsonReader, new TypeToken<LinkedHashMap<String, LinkedHashMap<String, Long[]>>>(){}.getType());
                this.parseSuperCategoriesToIconFamilies(file);
                continue;
            }
            if (name.equals("superCategoriesToIcons")) {
                file.superCategoriesToIcons = (LinkedHashMap)gson.fromJson(jsonReader, new TypeToken<LinkedHashMap<String, String>>(){}.getType());
                continue;
            }
            if (name.equals("phrasesToCommercialIcons")) {
                file.phrasesToCommercialIcons = (HashMap)gson.fromJson(jsonReader, new TypeToken<HashMap<String, Long>>(){}.getType());
                this.parseCommercialPhrases(file);
                continue;
            }
            if (name.equals("phraseToAssetIds")) {
                file.phraseToAnimatedGifs = (HashMap)gson.fromJson(jsonReader, new TypeToken<HashMap<String, HashMap<String, String[]>>>(){}.getType());
                this.parsePhraseToAnimatedGifs(file);
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        jsonReader.close();
        stream.close();
        this.nullLeftovers(file);
        this.mKeywordsFile = file;
    }

    private void nullLeftovers(KeywordsFile file) {
        file.primaryPhrases = null;
        file.iconIdsToEmojiUnicodes = null;
        file.animatedGifs = null;
        file.iconsToExternalApps = null;
        file.iconsToExternalWebsite = null;
        file.phrasesToCommercialIcons = null;
    }

    private KeywordsFile parseManually(String jsontext) throws JSONException {
        JSONObject phrasesToAnimatedGifs;
        int i;
        Gson gson = new Gson();
        KeywordsFile file = null;
        Log.d(TAG, "Start manual parse");
        JSONObject obj = new JSONObject(jsontext);
        file = new KeywordsFile();
        file.version = obj.getString("version");
        file.numberOfEmojis = obj.optInt("numberOfEmojis", 845);
        file.numPhraseChars = obj.optInt("numPhraseChars", -1);
        file.numPhrases = obj.optInt("numPhrases", -1);
        file.iconsCount = obj.optInt("iconsCount", -1);
        file.emojiMinIndex = obj.optLong("emojiMinIndex", 1000L);
        file.emojiMaxIndex = obj.optLong("emojiMaxIndex", 2999L);
        file.commercialIconsCount = obj.optInt("commercialIconsCount", -1);
        file.numOfCommercialPhrases = obj.optInt("numOfCommercialPhrases", -1);
        JSONObject families = obj.getJSONObject("iconFamilies");
        Iterator keys = families.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONArray icons = families.getJSONArray(key);
            ArrayList<Long> ids = new ArrayList<Long>(icons.length());
            for (i = 0; i < icons.length(); ++i) {
                ids.add(icons.getLong(i));
            }
            ids.trimToSize();
            file.iconFamilies.put(key, ids);
        }
        JSONObject iconIdsToEmojiUnicodes = obj.getJSONObject("iconIdsToEmojiUnicodes");
        keys = iconIdsToEmojiUnicodes.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = iconIdsToEmojiUnicodes.getString(key);
            file.iconIdsToEmojiUnicodes.put(Long.decode(key), value);
        }
        JSONArray lockedIcons = obj.getJSONArray("lockedIcons");
        int numLockedIcons = lockedIcons.length();
        file.lockedIcons = new long[numLockedIcons];
        for (i = 0; i < numLockedIcons; ++i) {
            file.lockedIcons[i] = lockedIcons.getLong(i);
        }
        JSONArray animatedGifs = obj.getJSONArray("animatedGifs");
        int numAnimatedGifs = animatedGifs.length();
        for (int i2 = 0; i2 < numAnimatedGifs; ++i2) {
            file.animatedGifs.add(animatedGifs.getLong(i2));
        }
        JSONObject phrasesToIcons = obj.getJSONObject("phrasesToIcons");
        keys = phrasesToIcons.keys();
        while (keys.hasNext()) {
            String phraseName = (String)keys.next();
            JSONObject subphrasesToIcons = phrasesToIcons.optJSONObject(phraseName);
            if (subphrasesToIcons == null) {
                Log.e(true, TAG, "Found a phrase with no definition: " + phraseName);
                continue;
            }
            HashMap<String, Long[]> map = new HashMap<String, Long[]>();
            Iterator keys2 = subphrasesToIcons.keys();
            while (keys2.hasNext()) {
                String subphraseName = (String)keys2.next();
                JSONArray icons = subphrasesToIcons.getJSONArray(subphraseName);
                Long[] ids = new Long[icons.length()];
                for (int i3 = 0; i3 < icons.length(); ++i3) {
                    ids[i3] = icons.getLong(i3);
                }
                map.put(subphraseName, ids);
            }
            file.phrasesToIcons.put(phraseName, map);
        }
        JSONObject primaryPhrases = obj.getJSONObject("primaryPhrases");
        keys = primaryPhrases.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = primaryPhrases.optString(key);
            file.primaryPhrases.put(Long.decode(key), value);
        }
        JSONObject externalApps = obj.getJSONObject("iconsToExternalApps");
        keys = externalApps.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = externalApps.optString(key);
            file.iconsToExternalApps.put(Long.decode(key), value);
        }
        JSONObject externalWebsites = obj.getJSONObject("iconsToExternalWebsite");
        keys = externalWebsites.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = externalWebsites.optString(key);
            file.iconsToExternalWebsite.put(Long.decode(key), value);
        }
        JSONObject superCategoriesToIcons = obj.getJSONObject("superCategoriesToIcons");
        JSONArray superCategoriesOrdered = obj.getJSONArray("superCategoriesOrder");
        for (int i4 = 0; i4 < superCategoriesOrdered.length(); ++i4) {
            String key = superCategoriesOrdered.getString(i4);
            String value = superCategoriesToIcons.getString(key);
            file.superCategoriesToIcons.put(key, value);
        }
        JSONObject superCategoriesToIconFamilies = obj.getJSONObject("superCategoriesToIconFamilies");
        for (int i5 = 0; i5 < superCategoriesOrdered.length(); ++i5) {
            String catName = superCategoriesOrdered.getString(i5);
            JSONObject familiesToIcons = superCategoriesToIconFamilies.getJSONObject(catName);
            LinkedHashMap<String, Long[]> familyToIcons = new LinkedHashMap<String, Long[]>();
            JSONObject superCategoriesToFamiliesOrder = obj.getJSONObject("superCategoriesToFamiliesOrder");
            JSONArray familiesOrder = superCategoriesToFamiliesOrder.getJSONArray(catName);
            for (int k = 0; k < familiesOrder.length(); ++k) {
                String familyName = familiesOrder.getString(k);
                JSONArray icons = familiesToIcons.getJSONArray(familyName);
                Long[] ids = new Long[icons.length()];
                for (int j = 0; j < icons.length(); ++j) {
                    ids[j] = icons.getLong(j);
                }
                familyToIcons.put(familyName, ids);
            }
            file.superCategoriesToIconFamilies.put(catName, familyToIcons);
        }
        JSONObject phrasesToCommercialIcons = obj.optJSONObject("phrasesToCommercialIcons");
        if (phrasesToCommercialIcons != null) {
            keys = phrasesToCommercialIcons.keys();
            while (keys.hasNext()) {
                String phraseName = (String)keys.next();
                Long iconId = phrasesToCommercialIcons.optLong(phraseName);
                file.phrasesToCommercialIcons.put(phraseName, iconId);
            }
        }
        if ((phrasesToAnimatedGifs = obj.getJSONObject("phraseToAssetIds")) != null) {
            keys = phrasesToAnimatedGifs.keys();
            while (keys.hasNext()) {
                String phraseName = (String)keys.next();
                JSONObject provider = phrasesToAnimatedGifs.getJSONObject(phraseName);
                Iterator innerKeys = provider.keys();
                HashMap<String, String[]> providerToAssetsIds = new HashMap<String, String[]>();
                while (innerKeys.hasNext()) {
                    String providerName = (String)keys.next();
                    String[] ids = (String[])gson.fromJson(provider.getJSONArray(providerName).toString(), new TypeToken<ArrayList<String>>(){}.getType());
                    providerToAssetsIds.put(providerName, ids);
                }
                file.phraseToAnimatedGifs.put(phraseName, providerToAssetsIds);
            }
        }
        Log.d(TAG, "End manual parse");
        return file;
    }

    public Phrase getPhraseByName(String name) {
        return this.mPhrases.get(name);
    }

    public PhrasesHashSet getCommercialPhrases() {
        return this.mCommercialPhrases;
    }

    public String getKeywordsVersion() {
        return this.mKeywordsFile.version;
    }

    public AssetType[] getAssetTypesInOrder() {
        Set<AssetType> assetTypes = this.mAssetsCategoriesFamiliesIcons.keySet();
        AssetType[] retAssetTypes = new AssetType[assetTypes.size()];
        assetTypes.toArray(retAssetTypes);
        return retAssetTypes;
    }

    public String[] getIconCategoriesInOrderByAssetType(AssetType assetType) {
        LinkedHashMap<String, LinkedHashMap<String, List<IconData>>> categoriesToIcons = this.mAssetsCategoriesFamiliesIcons.get((Object)assetType);
        if (categoriesToIcons == null) {
            return new String[0];
        }
        Set<String> categories = categoriesToIcons.keySet();
        String[] result = new String[categories.size()];
        return categories.toArray(result);
    }

    public String getSuperCategoryTabIconName(String category) {
        return this.mKeywordsFile.superCategoriesToIcons.get(category);
    }

    public HashMap<String, List<IconData>> getFamiliesToIconsByAssetTypeAndCategory(AssetType assetType, String category) {
        LinkedHashMap<String, LinkedHashMap<String, List<IconData>>> categoriesToFamiliesAndIcons = this.mAssetsCategoriesFamiliesIcons.get((Object)assetType);
        if (categoriesToFamiliesAndIcons == null) {
            return new HashMap<String, List<IconData>>();
        }
        return categoriesToFamiliesAndIcons.get(category);
    }

    public ArrayList<String> getFamiliesInOrderForSuperCategory(AssetType assetType, String superCategory) {
        LinkedHashMap<String, List<IconData>> familiesToIcons;
        ArrayList<String> result = new ArrayList<String>();
        LinkedHashMap<String, LinkedHashMap<String, List<IconData>>> categoriesToFamiliesAndIcons = this.mAssetsCategoriesFamiliesIcons.get((Object)assetType);
        if (categoriesToFamiliesAndIcons != null && (familiesToIcons = categoriesToFamiliesAndIcons.get(superCategory)) != null) {
            result.addAll(familiesToIcons.keySet());
        }
        return result;
    }

    public IconData getIconById(int id2) {
        return this.mIcons.get(id2);
    }

    public IconData getEmoji(int unicode) {
        return this.mEmoji.get(unicode);
    }

    public IconData getEmoji(int[] unicodes) {
        return this.mEmoji.get(unicodes);
    }

    public IconData getEmojiWithVarientSelector(int unicode) {
        return this.mEmojiWithVarientSelector.get(unicode);
    }

    public IconData getEmojiWithVarientSelector(int[] unicodes) {
        return this.mEmojiWithVarientSelector.get(unicodes);
    }

    public void addEmojiWithVarientSelector(IconData icon) {
        this.mEmojiWithVarientSelector.put(icon);
    }

    private String loadTextFile(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] bytes = new byte[4096];
        int len = 0;
        while ((len = inputStream.read(bytes)) > 0) {
            byteStream.write(bytes, 0, len);
        }
        inputStream.close();
        return new String(byteStream.toByteArray(), "UTF-8");
    }

    private void init() {
        this.mPhrases = new PhrasesHashSet(0);
        this.mIcons = new IconsHashSet(0);
        this.mEmoji = new EmojiHashSet(0);
        this.mEmojiWithVarientSelector = new EmojiHashSet(0);
        this.mChars = new Chars();
        this.mAssetsCategoriesFamiliesIcons = new LinkedHashMap();
        this.mKeywordsFile = new KeywordsFile();
    }

    public boolean isEmpty() {
        boolean result = "0.0".equals(this.getKeywordsVersion());
        return result;
    }

    void setKeywordsVersion(String newVersion) {
        this.mKeywordsFile.version = newVersion;
    }

    public static interface InputStreamProvider {
        public InputStream getStream() throws FileNotFoundException;
    }
}

