/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import com.aniways.data.DataForPhraseRequestContext;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.IPhraseAssetInfoBuilder;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.service.utils.AniwaysAction;
import java.util.HashMap;
import java.util.List;

public abstract class DataForAssetTypeInPhrase {
    protected static final HashMap<Integer, DataForPhraseRequestContext> requests = new HashMap();
    private static int lastRequestId = 0;

    protected AniwaysAction<List<IAniwaysAssetInfo>> getBuildersCallback(final int requestId, final DataForPhraseRequestContext ctx) {
        return new AniwaysAction<List<IAniwaysAssetInfo>>(){

            @Override
            public synchronized void call(List<IAniwaysAssetInfo> assetInfos) {
                ++ctx.numCallbacksFromBuilders;
                if (assetInfos != null && !assetInfos.isEmpty()) {
                    ctx.assetInfos.addAll(assetInfos);
                }
                if (ctx.numBuilders == ctx.numCallbacksFromBuilders) {
                    ctx.callback.call(ctx.assetInfos);
                    requests.remove(requestId);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getNewRequestId() {
        int returnValue;
        HashMap<Integer, DataForPhraseRequestContext> hashMap = requests;
        synchronized (hashMap) {
            returnValue = lastRequestId++;
        }
        return returnValue;
    }

    public void cancellBuildAssetInfosRequest(int currentRequestId) {
        DataForPhraseRequestContext ctx = requests.get(currentRequestId);
        if (ctx != null) {
            if (ctx.builders == null) {
                return;
            }
            for (IPhraseAssetInfoBuilder iPhraseAssetInfoBuilder : ctx.builders) {
                iPhraseAssetInfoBuilder.cancelAllInProgressRequests();
            }
            requests.remove(currentRequestId);
        }
    }

    public abstract Phrase getReferencePhrase(JsonParser var1, Phrase var2);

    public abstract boolean isEmpty();

    public abstract int buildAssetInfos(AniwaysAction<List<IAniwaysAssetInfo>> var1, Phrase var2);
}

