/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.Display;
import android.view.WindowManager;
import com.aniways.Aniways;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.VersionComparisonResult;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysBackendSyncChecker;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysStatics;
import com.aniways.ui.AniwaysUiUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AniwaysPrivateConfig {
    public int animatedGifsRequestSize = 10;
    public String animatedGifsRating = "g";
    public long phoneRegTimeout = 30000L;
    public boolean printAnalyticsToLogs = false;
    public boolean addDefaultPhraseToAnimatedGif = true;
    public boolean performLiveBlur = false;
    public String animatedGifsSearchTermPrefix = "search:";
    public String giphyLowQualityImageObjectName = "fixed_height_downsampled";
    public String giphyHighQualityImageObjectName = "fixed_height_small";
    public String giphyHighQualityStillImageObjectName = "fixed_height_small_still";
    private int minDiskCacheSize = 5;
    public static final String SUGGESTION_POPUP_NAME = "Suggestion popup";
    public static final String TEXT_VIEW_OR_EDIT_TEXT_NAME = "Text view or edit text";
    private static final String DEFAULT_APP_ID = "Placeholder";
    private static final String DEFAULT_GOOGLE_ANALYTICS_ID = "UA-46026454-3";
    private static final String DEFAULT_PUBLIC_KEY = "!!MUST REPLACE THIS with your app's public key";
    private static final String TAG = "AniwaysPrivateConfig";
    private static final String KEY_PARSED_CONFIG_VERSION = "com.aniways.PARSED_CONFIG_VERSION";
    public IconEncodingMethod iconEncodingMethod = IconEncodingMethod.Invisible;
    public boolean useOnlyConfiguredEncodingMethodForDecoding = false;
    public boolean encodeEmojisWithEmojiUnicode = false;
    public boolean encodeIconsWithEmojiReplacementWithEmojiUnicode = false;
    public int decoderChunkSize = 6;
    private String delimiter = "200C";
    private String decoderCodepointsString = "200C-200D-feff";
    public String delimiterString;
    public int decoderRadix;
    public String[] decoderCodepointStrings;
    public String upgradeMessage = "\n\nTo view emoticons in this message, please upgrade to the latest version: ";
    public static final String ICON_ID = "id";
    public static final String PHRASE_NAME = "pn";
    public static final String START_INDEX = "si";
    public static final String LENGTH = "l";
    public static final String MESSAGE_LENGTH = "ml";
    public static final String VERSION = "v";
    public String viralMessage = "\n\nTo view icons in this message, please install Telegram with Aniways: ";
    public String viralUrl = "http://www.aniways.com/anygram/dl2 ";
    public int viralLinkImageId = 31;
    public int animatedGifImageId = 14;
    public int iconInTextViewSize = 30;
    public int iconInEditTextSize = 30;
    public int iconInSuggestionPopupSize = 60;
    public int maxIconsInRecentsTab = 32;
    public boolean useSmallerIconsInIconsOnDemendPopup = false;
    public boolean useEditTextTutorial = true;
    public boolean useTextViewTutorial = false;
    public int maxTimesToShowTutorial = 3;
    public int numberOfWordsRequiredToShowTutorialAgain = 7;
    public int wordHighlightColor = -16711936;
    public float lockedIconAlpha = 0.4f;
    public int defalutLockedIconPrice = 10;
    public boolean creditsStoreEnabled = true;
    public int creditsStoreInitialCredits = 100;
    public String creditsSku100 = "aniways_100_credits";
    public String creditsSku250 = "aniways_250_credits";
    public String creditsSku500 = "aniways_500_credits";
    public String creditsSku1000 = "aniways_1000_credits";
    public String creditsSku2000 = "aniways_2000_credits";
    public String creditsSku3000 = "aniways_3000_credits";
    public String appPublicKeyForCreditsStore = "!!MUST REPLACE THIS with your app's public key";
    public boolean tryUsingExternalStorageForIconCaching = false;
    public String appId = "Placeholder";
    public boolean doNotSendMessagesInAnalytics = false;
    public boolean doNotSendMessageIdInAnalytics = false;
    public int statisticalEventsInterval = 30000;
    public String googleAnalyticsId = "UA-46026454-3";
    public AniwaysConfiguration.Verbosity googleAnalyticsEventsVerbosity = AniwaysConfiguration.Verbosity.Info;
    public AniwaysConfiguration.Verbosity gaTimingEventsVerbosity = AniwaysConfiguration.Verbosity.Statistical;
    public AniwaysConfiguration.Verbosity gaScreenEventsVerbosity = AniwaysConfiguration.Verbosity.Info;
    public boolean sendErrorsToGoogleAnalytics = true;
    public boolean gaDebug = false;
    public int gaDispatchPeriod = 10;
    public AniwaysConfiguration.Verbosity analyticsEventsVerbosity = AniwaysConfiguration.Verbosity.Info;
    public AniwaysConfiguration.Verbosity timingEventsVerbosity = AniwaysConfiguration.Verbosity.Off;
    public AniwaysConfiguration.Verbosity screenEventsVerbosity = AniwaysConfiguration.Verbosity.Info;
    public boolean sendErrorsToAniwaysServer = false;
    public AniwaysConfiguration.Verbosity errorHandlingVerbosity = AniwaysConfiguration.Verbosity.Warning;
    public int analyticsMaxEventsBeforeFlush = 200;
    public int analyticsMaxFlushSize = 1000;
    public int analyticsFlushInterval = (int)TimeUnit.SECONDS.toMillis(900L);
    public long analyticsFlushIntervalRestricted = 86400000L;
    public int analyticsMaxEventsInDb = 10000;
    public int emptyAnalyticsFlushIntervalsBeforeKillingService = 0;
    public long flushTimeout = 1200000L;
    public int numberOfAnalyticsPartitions = 10;
    public int analyticsPartitionsStringLength = 5;
    public boolean compressAnalytics = true;
    public AnalyticsCloud analyticsCloud = AnalyticsCloud.Azure;
    public String azureAnalyticsEndpint = "https://aniways.blob.core.windows.net/aniways-analytics";
    public String azureAnalyticsStorageAccountName = "aniways";
    public String azureAnalyticsKey = "c17/s+EvRMmBSrgpvwTkmOAeYji25YrgAGI9+npsEKvxy3fmG1Sj5gUkHm/tFkzSr/hi8TbT1pBSdyH4eavMwA==";
    public String errorHandlingAPIKey = "b0012251b703bc5985b47b8f796d8062";
    public String errorHandlingEndpoint = "https://notify.bugsnag.com";
    public String s3StorageClass = "REDUCED_REDUNDANCY";
    public String analyticsS3Address = "https://s3-eu-west-1.amazonaws.com/aniways-analytics";
    public String s3Acl = "bucket-owner-full-control";
    public String baseAnalyticsUrl = "http://api.aniways.com/v2/events/android";
    public boolean isImeFlagNoExtractUiForced = true;
    public SuggestionMode suggestionMode = SuggestionMode.AutoDisplaySuggestions;
    public String leaveAutoPopupOpenCharacters = "?!.,";
    public static int smartUseMarkerTapCount = 3;
    public long popupDismissDelay = 3000L;
    public int maxNumberOfIconsInSuggestionPopup = 10;
    public int maxWordsInPhrase = 3;
    public long shortIntervalBetweenBackendSyncMillis = 10000L;
    public long longIntervalBetweenBackendSyncMillis = this.shortIntervalBetweenBackendSyncMillis * 60L;
    public long backendSyncRequestInterval = 300000L;
    public AniwaysConfiguration.Verbosity logsVerbosity = AniwaysConfiguration.Verbosity.Verbose;
    private static AniwaysConfiguration.Verbosity sLogsVerbosity = AniwaysConfiguration.Verbosity.Verbose;
    private String[] autoReplaceEmoticonShortcutsInTextView = new String[]{":)", "^_^", "3)", ":D", ":clap:", ":(", "/_\\", ">.<", "x_x", "D:", ";)", ":P", ":/", ":x", ";o", ":-*", "<3", "</3", "*_*", "6_9", "z_z", ":666:", ":poop:", ":'(", "o_O"};
    private String[] autoReplaceIgnoreWords = new String[]{"http://", "http:/", "https://", "https:/"};
    public HashSet<String> autoreplaceIgnorePhrases = new HashSet();
    public Pattern autoreplacePattern = Pattern.compile("");
    public String autoReplaceEmoticonsInTextViewDefaultIconsFamily = "Oldschool";
    public boolean autoReplaceKeyPhrasesInTextView = false;
    public boolean autoReplaceKeyPhrasesOnEncode = false;
    public String version = "0.0";
    public String versionName = "Default";
    public String baseApiUrl = "http://api.aniways.com/v2/";
    public long syncAlarmScheduleInterval = 43200000L;
    public long syncAlarmScheduleIntervalRestricted = 86400000L;
    public long minTimeBetweenSyncs = 86400000L;
    public long timeFromLastMessageBeforeStopSyncing = 259200000L;
    public int iconInTextViewHeight = 30;
    public int iconInTextViewWidth = 30;
    public int iconInEditTextHeight = 30;
    public int iconInEditTextWidth = 30;
    public int smallIconTextHeight = 20;
    public int smallIconTextWidth = 20;
    public int bigIconHeight = 120;
    public int bigIconWidth = 120;
    public int bannerHeight = 320;
    public int bannerWidth = 320;
    public int iconInSuggestionPopupHeight = 40;
    public int iconInSuggestionPopupWidth = 40;
    public int animatedGifInSuggestionPopupHeight = 60;
    public int animatedGifInSuggestionPopupWidth = 60;
    public int contextualGridRowHeight = 70;
    public int contextualCardHeightThreshold = 5;
    public int contextualGridAnimatedItemMinMargin = 4;
    public int contextualGridEmoticonItemMinMargin = 4;
    public boolean makeStandaloneIconsBigger = true;
    private Integer maxIconSize = 80;
    private int maxBigIconSize = 160;
    private int maxBannerSize = 320;
    public int maxInSampleSize = 2;
    public boolean useBlurEffect = true;
    public float blurBitmapScaleFactor = 0.25f;
    public int minBlurAndroidVersion = 15;
    public boolean restrictDataUsage = false;
    public boolean forceUpdate = false;
    public HashMap<Float, Integer> lowMemoryThreshold = new HashMap();
    public HashMap<Float, Integer> disableAniwaysExperianceMemoryThreshold = new HashMap();
    public int diskCacheSize = this.getDiskCacheSize();
    public boolean contextualIconSuggestionsEnabled = true;
    public boolean contextualAnimationsSuggestionsEnabled = true;
    public boolean contextualMusicSuggestionsEnabled = true;
    public boolean contextualLocationBasedSuggestionsEnabled = true;
    public boolean contextualContentSuggestionsEnabled = true;
    public boolean contextualSuggestionsEnabled = true;
    private boolean isLowMemoryDevice;
    private boolean isExtremeLowMemoryDevice;
    private static boolean sIsInitialized;
    private static volatile int sInstanceNumber;
    private int mInstanceNumber = 0;
    private static AniwaysPrivateConfig sInstance;
    private static Context sContext;
    public boolean sendHeartbeatEvent = true;
    private boolean useSmallEmoji = false;
    public Pattern decoderCodepointsPattern = Pattern.compile("");
    private int[] availableSizesOnServer = new int[]{60, 80, 120, 160, 240};
    private int[] availableBigIconSizesOnServer = new int[]{60, 80, 120, 160, 240};
    private int[] availableBannerSizesOnServer = new int[]{240, 320, 480, 640, 960, 1280};
    private String mAssetsUrlPrefix = "http://aniways.blob.core.windows.net/aniways-assets/";
    private String assetsUrl = this.mAssetsUrlPrefix + "160";
    private String emojiUrl = this.mAssetsUrlPrefix + "60";
    private String bigIconsUrl = this.mAssetsUrlPrefix + "320";
    private String bannerUrl = this.mAssetsUrlPrefix + "640";
    public boolean usePreInstalledIcons = true;
    public boolean usePreInstalledEmojis = true;
    public boolean usePreInstalledBigIcons = true;
    public boolean usePreInstalledBanners = true;
    private Integer preInstalledIconSize = 120;
    private Integer preInstalledEmojiSize = 60;
    private Integer preInstalledBigIconSize = 120;
    private Integer preInstalledBannerSize = 640;
    private int acceptableSizeDifference = 120;
    private int acceptableEmojiSizeDifference = 60;
    private int acceptableBigIconSizeDifference = 120;
    private int acceptableBannerSizeDifference = 120;
    protected boolean disableCreditStoreIcon = false;
    public boolean removePoweredByAniways = false;
    public boolean closeTutorialOnClickAnywhere = false;
    public boolean makeNonAniwaysIconsSmart = true;
    public boolean appIsCallingOnSendingMessage = false;
    public int pulsateAnimationFrom = 90;
    public int pulsateAnimationTo = 105;
    public long pulsateAnimationDuration = 500L;
    public int pulsateAnimationRepeatCount = -1;
    public boolean debugPerformance = false;
    public boolean useDefaultEmojiLookInIconsOnDemendPopup = true;
    public long noInternetPopupCloseDelay = 7000L;
    public boolean noInternetPopupClose = false;
    public boolean animateInImageView = true;
    public int bannerPaddingLeft = 0;
    public int bannerPaddingTop = 20;
    public int bannerPaddingRight = 0;
    public int bannerPaddingBottom = 0;

    static synchronized void forceInit(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (sIsInitialized) {
            Log.e(true, TAG, "Initializing Aniways private config after it has already been initialized");
        }
        sContext = context;
        AniwaysPrivateConfig cfg = AniwaysPrivateConfig.createNewInstance(null);
        AniwaysPrivateConfig.setNewInstance(cfg);
        AniwaysBackendSyncChecker.parseConfingAndKeywordsIfNecessary(sContext, true, false);
        sIsInitialized = true;
    }

    private int getDiskCacheSize() {
        Resources r = sContext.getResources();
        DisplayMetrics displayMetrics = r.getDisplayMetrics();
        float density = displayMetrics.density;
        return (int)((double)(this.minDiskCacheSize * 1024 * 1024) * Math.pow(density, 2.0));
    }

    public static AniwaysPrivateConfig getInstance() {
        if (sInstance == null) {
            Log.w(true, TAG, "Getting a null instance");
        }
        return sInstance;
    }

    public static synchronized AniwaysPrivateConfig createNewInstance(InputStream abTestConfigStream) {
        AniwaysPrivateConfig config = new AniwaysPrivateConfig(sInstanceNumber);
        ++sInstanceNumber;
        config.parseXmlConfiguration();
        config.parseServerConfiguration(abTestConfigStream);
        config.parseUserConfig();
        config.convertIconDimentionsToPixels();
        config.updateAssetsUrl();
        config.calculateEncodingParams();
        config.calculateIsExtremeLowMemoryDevice();
        config.calculateIsLowMemoryDevice();
        config.autoreplaceIgnorePhrases = new HashSet();
        if (config.autoReplaceIgnoreWords != null && config.autoReplaceIgnoreWords.length > 0) {
            config.autoreplaceIgnorePhrases.addAll(Arrays.asList(config.autoReplaceIgnoreWords));
        }
        if (config.autoReplaceEmoticonShortcutsInTextView != null && config.autoReplaceEmoticonShortcutsInTextView.length > 0) {
            ArrayList<String> phrases = new ArrayList<String>();
            phrases.addAll(Arrays.asList(config.autoReplaceEmoticonShortcutsInTextView));
            if (config.autoReplaceIgnoreWords != null && config.autoReplaceIgnoreWords.length > 0) {
                phrases.addAll(config.autoreplaceIgnorePhrases);
            }
            StringBuilder sb = new StringBuilder();
            for (String p : phrases) {
                sb.append(Pattern.quote(p));
                sb.append("|");
            }
            sb.deleteCharAt(sb.length() - 1);
            config.autoreplacePattern = Pattern.compile(sb.toString(), 2);
        }
        if (config.decoderCodepointStrings != null && config.decoderCodepointStrings.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String s : config.decoderCodepointStrings) {
                sb.append(Pattern.quote(s));
                sb.append("|");
            }
            sb.deleteCharAt(sb.length() - 1);
            config.decoderCodepointsPattern = Pattern.compile(sb.toString(), 2);
        }
        return config;
    }

    private void updateAssetsUrl() {
        int serverResolution = AniwaysPrivateConfig.getClosestValue(this.availableSizesOnServer, this.maxIconSize);
        int serverResolutionForEmojis = AniwaysPrivateConfig.getClosestValue(this.availableSizesOnServer, this.useSmallEmoji ? this.smallIconTextWidth : this.maxIconSize);
        int serverResolutionForBigIcons = AniwaysPrivateConfig.getClosestValue(this.availableBigIconSizesOnServer, this.maxBigIconSize);
        int serverResolutionForBanners = AniwaysPrivateConfig.getClosestValue(this.availableBannerSizesOnServer, this.maxBannerSize);
        boolean bl = this.usePreInstalledIcons = this.maxIconSize - this.acceptableSizeDifference <= this.preInstalledIconSize;
        this.usePreInstalledEmojis = this.useSmallEmoji ? this.smallIconTextWidth - this.acceptableEmojiSizeDifference <= this.preInstalledEmojiSize : this.usePreInstalledIcons;
        this.usePreInstalledBigIcons = this.maxBigIconSize - this.acceptableBigIconSizeDifference <= this.preInstalledBigIconSize;
        this.usePreInstalledBanners = this.maxBannerSize - this.acceptableBannerSizeDifference <= this.preInstalledBannerSize;
        this.assetsUrl = this.mAssetsUrlPrefix + serverResolution;
        this.emojiUrl = this.mAssetsUrlPrefix + serverResolutionForEmojis;
        this.bigIconsUrl = this.mAssetsUrlPrefix + serverResolutionForBigIcons;
        this.bannerUrl = this.mAssetsUrlPrefix + serverResolutionForBanners;
    }

    private static int getClosestValue(int[] availableSizes, int size) {
        int idx = 0;
        while (availableSizes[idx] < size) {
            if (++idx != availableSizes.length) continue;
            return availableSizes[idx - 1];
        }
        return availableSizes[idx];
    }

    private void parseUserConfig() {
        Aniways.Configuration.setPrivateConfigProperties(sContext, this);
    }

    AniwaysPrivateConfig(int instanceNumner) {
        this.mInstanceNumber = instanceNumner;
        this.lowMemoryThreshold.put(Float.valueOf(0.75f), 16);
        this.lowMemoryThreshold.put(Float.valueOf(1.0f), 16);
        this.lowMemoryThreshold.put(Float.valueOf(1.5f), 24);
        this.lowMemoryThreshold.put(Float.valueOf(2.0f), 32);
        this.lowMemoryThreshold.put(Float.valueOf(3.0f), 32);
        this.lowMemoryThreshold.put(Float.valueOf(4.0f), 32);
        this.lowMemoryThreshold.put(Float.valueOf(5.0f), 64);
        this.lowMemoryThreshold.put(Float.valueOf(6.0f), 64);
        this.lowMemoryThreshold.put(Float.valueOf(7.0f), 64);
        this.lowMemoryThreshold.put(Float.valueOf(8.0f), 64);
        this.lowMemoryThreshold.put(Float.valueOf(9.0f), 64);
        this.lowMemoryThreshold.put(Float.valueOf(10.0f), 64);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(0.75f), 12);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(1.0f), 12);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(1.5f), 16);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(2.0f), 24);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(3.0f), 24);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(4.0f), 24);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(5.0f), 32);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(6.0f), 32);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(7.0f), 32);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(8.0f), 32);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(9.0f), 32);
        this.disableAniwaysExperianceMemoryThreshold.put(Float.valueOf(10.0f), 32);
    }

    public static void setNewInstance(AniwaysPrivateConfig newConfig) {
        if (sInstance != null && newConfig.mInstanceNumber < AniwaysPrivateConfig.sInstance.mInstanceNumber) {
            Log.w(false, TAG, "Received config with lower instance number: " + newConfig.mInstanceNumber + ". Current number: " + AniwaysPrivateConfig.sInstance.mInstanceNumber + ". So, not setting it");
            return;
        }
        sInstance = newConfig;
        sLogsVerbosity = newConfig.logsVerbosity;
        if (!AniwaysStatics.isInitializing()) {
            GoogleAnalyticsReporter.onConfigChange(newConfig, sContext);
        }
        AniwaysPrivateConfig.setParsedConfigVersion(sContext, newConfig.version);
        String oldConfigVersion = AniwaysPrivateConfig.getParsedConfigVersion(sContext);
        Log.i(TAG, "Setting new config to version: " + newConfig.version + " Old config version: " + oldConfigVersion + "");
        VersionComparisonResult comparisonResult = null;
        try {
            comparisonResult = Utils.compareVersionStrings(newConfig.version, oldConfigVersion);
        }
        catch (IllegalArgumentException e) {
            Log.e(true, TAG, "Error parsing config version: " + oldConfigVersion, e);
        }
        if (comparisonResult != null) {
            if (comparisonResult.result == 1) {
                if (AnalyticsReporter.isInitialized()) {
                    Log.i(TAG, "Updated Config Version from: " + oldConfigVersion + ", to: " + newConfig.version);
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Updated Config Version", "from: " + oldConfigVersion + ", to: " + newConfig.version, 0L);
                    AnalyticsReporter.reportUpdatedConfigVersion(oldConfigVersion, newConfig.version);
                }
            } else if (comparisonResult.result == 0) {
                Log.i(TAG, "Setting new config to version which has already been parsed when the app was running at a previous time: " + newConfig.version);
            } else {
                Log.e(true, TAG, "Setting config for lower version than was parsed before. Old version: " + oldConfigVersion + " . New version:" + newConfig.version);
            }
        }
    }

    private void parseXmlConfiguration() {
        Pair<Boolean, String> appId = this.getResourceString("aniways_appId", true, sContext);
        Pair<Boolean, String> upgradeUrl = this.getResourceString("aniways_upgradeUrl", false, sContext);
        Pair<Boolean, String> upgradeMessage = this.getResourceString("aniways_upgradeMessage", false, sContext);
        Pair<Boolean, String> iconEncodingMethod = this.getResourceString("aniways_iconEncodingMethod", false, sContext);
        Pair<Boolean, Boolean> useOnlyConfiguredEncodingMethodForDecoding = this.getResourceBoolean("aniways_useOnlyConfiguredEncodingMethodForDecoding", false, sContext);
        Pair<Boolean, String> logsVerbosity = this.getResourceString("aniways_logsVerbosity", false, sContext);
        Pair<Boolean, Boolean> tryUsingExternalStorageForIconCaching = this.getResourceBoolean("aniways_try_using_external_storage_for_icon_caching", false, sContext);
        Pair<Boolean, Integer> smallIconSize = this.getResourceInt("aniways_smallIconSize", false, sContext);
        Pair<Boolean, Integer> bigIconSize = this.getResourceInt("aniways_bigIconSize", false, sContext);
        Pair<Boolean, Integer> bannerSize = this.getResourceInt("aniways_bannerSize", false, sContext);
        Pair<Boolean, Boolean> makeStandaloneIconsBigger = this.getResourceBoolean("aniways_makeStandaloneIconsBigger", false, sContext);
        Pair<Boolean, Integer> iconInEditTextSize = this.getResourceInt("aniways_iconInEditTextSize", false, sContext);
        Pair<Boolean, Integer> iconInTextViewSize = this.getResourceInt("aniways_iconInTextViewSize", false, sContext);
        Pair<Boolean, Integer> iconInSuggestionPopupSize = this.getResourceInt("aniways_iconInSuggestionPopupSize", false, sContext);
        Pair<Boolean, Integer> animatedGifInSuggestionPopupSize = this.getResourceInt("aniways_animatedGifInSuggestionPopupSize", false, sContext);
        Pair<Boolean, Boolean> useSmallerIconsInIconsOnDemendPopup = this.getResourceBoolean("aniways_useSmallerIconsInIconsOnDemendPopup", false, sContext);
        Pair<Boolean, Integer> numberOfWordsRequiredToShowTutorialAgain = this.getResourceInt("aniways_numberOfWordsRequiredToShowTutorialAgain", false, sContext);
        Pair<Boolean, Integer> maxTimesToShowTutorial = this.getResourceInt("aniways_maxTimesToShowTutorial", false, sContext);
        Pair<Boolean, Boolean> useEditTextTutorial = this.getResourceBoolean("aniways_useEditTextTutorial", false, sContext);
        Pair<Boolean, Boolean> disableCreditStoreBalanceButton = this.getResourceBoolean("aniways_disableCreditStoreBalanceButton", false, sContext);
        Pair<Boolean, Boolean> useTextViewTutorial = this.getResourceBoolean("aniways_useTextViewTutorial", false, sContext);
        Pair<Boolean, Integer> wordHighlightColor = this.getResourceInt("aniways_wordHighlightColor", false, sContext);
        Pair<Boolean, Boolean> creditsStoreEnabled = this.getResourceBoolean("aniways_enable_credits_store", false, sContext);
        Pair<Boolean, String> appPublicKeyForCreditsStore = this.getResourceString("aniways_app_public_key_for_credits_store", false, sContext);
        Pair<Boolean, Integer> creditsStoreInitialCredits = this.getResourceInt("aniways_store_initial_credits", false, sContext);
        Pair<Boolean, String> creditsSku100 = this.getResourceString("aniways_100_credits_sku", false, sContext);
        Pair<Boolean, String> creditsSku250 = this.getResourceString("aniways_250_credits_sku", false, sContext);
        Pair<Boolean, String> creditsSku500 = this.getResourceString("aniways_500_credits_sku", false, sContext);
        Pair<Boolean, String> creditsSku1000 = this.getResourceString("aniways_1000_credits_sku", false, sContext);
        Pair<Boolean, String> creditsSku2000 = this.getResourceString("aniways_2000_credits_sku", false, sContext);
        Pair<Boolean, String> creditsSku3000 = this.getResourceString("aniways_3000_credits_sku", false, sContext);
        Pair<Boolean, Boolean> removePoweredByAniways = this.getResourceBoolean("aniways_removePoweredByAniways", false, sContext);
        Pair<Boolean, Boolean> autoReplaceKeyPhrasesInTextView = this.getResourceBoolean("aniways_autoReplaceKeyPhrasesInTextView", false, sContext);
        Pair<Boolean, Boolean> autoreplaceKeyPhrasesOnEncode = this.getResourceBoolean("aniways_autoReplaceKeyPhrasesOnEncode", false, sContext);
        Pair<Boolean, Boolean> debugPerformance = this.getResourceBoolean("aniways_debugPerformance", false, sContext);
        this.appId = (String)appId.second;
        if (((Boolean)upgradeUrl.first).booleanValue()) {
            this.setUpgradeUrlInternal((String)upgradeUrl.second);
        }
        if (((Boolean)upgradeMessage.first).booleanValue()) {
            this.setUpgradeMessageInternal((String)upgradeMessage.second);
        }
        if (((Boolean)logsVerbosity.first).booleanValue()) {
            this.setLogsVerbosityInternal((String)logsVerbosity.second);
        }
        if (((Boolean)iconEncodingMethod.first).booleanValue()) {
            this.setIconEncodingMethodInternal((String)iconEncodingMethod.second);
        }
        if (((Boolean)useOnlyConfiguredEncodingMethodForDecoding.first).booleanValue()) {
            this.useOnlyConfiguredEncodingMethodForDecoding = (Boolean)useOnlyConfiguredEncodingMethodForDecoding.second;
        }
        if (((Boolean)tryUsingExternalStorageForIconCaching.first).booleanValue()) {
            this.tryUsingExternalStorageForIconCaching = (Boolean)tryUsingExternalStorageForIconCaching.second;
        }
        if (((Boolean)smallIconSize.first).booleanValue()) {
            this.setSmallIconSizeInternal((Integer)smallIconSize.second);
        }
        if (((Boolean)bigIconSize.first).booleanValue()) {
            this.setBigIconSizeInternal((Integer)bigIconSize.second);
        }
        if (((Boolean)bannerSize.first).booleanValue()) {
            this.setBannerSizeInternal((Integer)bannerSize.second);
        }
        if (((Boolean)makeStandaloneIconsBigger.first).booleanValue()) {
            this.makeStandaloneIconsBigger = (Boolean)makeStandaloneIconsBigger.second;
        }
        if (((Boolean)iconInEditTextSize.first).booleanValue()) {
            this.setIconInEditTextSizeInternal((Integer)iconInEditTextSize.second);
        }
        if (((Boolean)iconInSuggestionPopupSize.first).booleanValue()) {
            this.setIconInSuggestionPopupSizeInternal((Integer)iconInSuggestionPopupSize.second);
        }
        if (((Boolean)animatedGifInSuggestionPopupSize.first).booleanValue()) {
            this.setAnimatedGifInSuggestionPopupSizeInternal((Integer)animatedGifInSuggestionPopupSize.second);
        }
        if (((Boolean)iconInTextViewSize.first).booleanValue()) {
            this.setIconInTextViewSizeInternal((Integer)iconInTextViewSize.second);
        }
        if (((Boolean)useSmallerIconsInIconsOnDemendPopup.first).booleanValue()) {
            this.useSmallerIconsInIconsOnDemendPopup = (Boolean)useSmallerIconsInIconsOnDemendPopup.second;
        }
        if (((Boolean)numberOfWordsRequiredToShowTutorialAgain.first).booleanValue()) {
            this.setNumberOfWordsRequiredToShowTutorialAgainInternal((Integer)numberOfWordsRequiredToShowTutorialAgain.second);
        }
        if (((Boolean)maxTimesToShowTutorial.first).booleanValue()) {
            this.setMaxTimesToShowTutorialInternal((Integer)maxTimesToShowTutorial.second);
        }
        if (((Boolean)useEditTextTutorial.first).booleanValue()) {
            this.setUseEditTextTutorialInternal((Boolean)useEditTextTutorial.second);
        }
        if (((Boolean)disableCreditStoreBalanceButton.first).booleanValue()) {
            this.setDisableCreditStoreBalanceButton((Boolean)disableCreditStoreBalanceButton.second);
        }
        if (((Boolean)useTextViewTutorial.first).booleanValue()) {
            this.setUseTextViewTutorialInternal((Boolean)useTextViewTutorial.second);
        }
        if (((Boolean)wordHighlightColor.first).booleanValue()) {
            this.wordHighlightColor = (Integer)wordHighlightColor.second;
        }
        if (((Boolean)creditsStoreEnabled.first).booleanValue()) {
            this.creditsStoreEnabled = (Boolean)creditsStoreEnabled.second;
        }
        if (((Boolean)appPublicKeyForCreditsStore.first).booleanValue()) {
            this.setAppPublicKeyForCreditsStoreInternal((String)appPublicKeyForCreditsStore.second);
        }
        if (((Boolean)creditsStoreInitialCredits.first).booleanValue()) {
            this.setCreditsStoreInitialCreditsInternal((Integer)creditsStoreInitialCredits.second);
        }
        if (((Boolean)creditsSku100.first).booleanValue()) {
            this.setCreditsSkuInternal(100, (String)creditsSku100.second);
        }
        if (((Boolean)creditsSku250.first).booleanValue()) {
            this.setCreditsSkuInternal(250, (String)creditsSku250.second);
        }
        if (((Boolean)creditsSku500.first).booleanValue()) {
            this.setCreditsSkuInternal(500, (String)creditsSku500.second);
        }
        if (((Boolean)creditsSku1000.first).booleanValue()) {
            this.setCreditsSkuInternal(1000, (String)creditsSku1000.second);
        }
        if (((Boolean)creditsSku2000.first).booleanValue()) {
            this.setCreditsSkuInternal(2000, (String)creditsSku2000.second);
        }
        if (((Boolean)creditsSku3000.first).booleanValue()) {
            this.setCreditsSkuInternal(3000, (String)creditsSku3000.second);
        }
        if (((Boolean)removePoweredByAniways.first).booleanValue()) {
            this.setRemovePoweredByAniwaysInternal((Boolean)removePoweredByAniways.second);
        }
        if (((Boolean)autoReplaceKeyPhrasesInTextView.first).booleanValue()) {
            this.setAutoReplaceKeyPhrasesInTextView((Boolean)autoReplaceKeyPhrasesInTextView.second);
        }
        if (((Boolean)autoreplaceKeyPhrasesOnEncode.first).booleanValue()) {
            this.setAutoreplaceKeyPhrasesOnEncode((Boolean)autoreplaceKeyPhrasesOnEncode.second);
        }
        if (((Boolean)debugPerformance.first).booleanValue()) {
            this.debugPerformance = (Boolean)debugPerformance.second;
        }
    }

    private void parseServerConfiguration(InputStream abTestConfigStream) {
        if (abTestConfigStream == null) {
            if (!AniwaysStatics.isInitializing()) {
                Log.e(true, TAG, "Could not find a-b test config file, so running without");
            } else {
                Log.i(TAG, "Could not find pre-installed a-b test config file, so running without");
            }
            return;
        }
        String jsonText = null;
        try {
            byte[] buffer = null;
            buffer = new byte[4096];
            while (abTestConfigStream.read(buffer) != -1) {
            }
            abTestConfigStream.close();
            jsonText = new String(buffer, "UTF-8");
        }
        catch (FileNotFoundException e) {
            Log.e(true, TAG, "Caught FileNotFoundException while reading config Json", e);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(true, TAG, "Caught UnsupportedEncodingException while reading config Json", e);
        }
        catch (IOException e) {
            Log.e(true, TAG, "Caught IOException while reading config Json", e);
        }
        if (TextUtils.isEmpty(jsonText)) {
            Log.e(true, TAG, "a-b test config file empty, so running without");
            return;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonText);
        }
        catch (JSONException e) {
            Log.e(true, TAG, "Caught JSONException while creating object", e);
            return;
        }
        Iterator keys = jsonObject.keys();
        Class<?> configClass = this.getClass();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Field field = null;
            try {
                field = configClass.getDeclaredField(key);
            }
            catch (NoSuchFieldException e) {
                Log.i(TAG, "Could not find field with name: " + key);
                continue;
            }
            Class<?> fieldType = field.getType();
            try {
                JSONArray array;
                int length;
                int i;
                Object[] value;
                if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                    field.set(this, jsonObject.getInt(key));
                    continue;
                }
                if (fieldType == Long.TYPE || fieldType == Long.class) {
                    field.set(this, jsonObject.getLong(key));
                    continue;
                }
                if (fieldType == Double.TYPE || fieldType == Double.class) {
                    field.set(this, jsonObject.getDouble(key));
                    continue;
                }
                if (fieldType == String.class) {
                    field.set(this, jsonObject.getString(key));
                    continue;
                }
                if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                    field.set(this, jsonObject.getBoolean(key));
                    continue;
                }
                if (fieldType == AniwaysConfiguration.Verbosity.class) {
                    String verbosityString = "";
                    try {
                        verbosityString = jsonObject.getString(key);
                        AniwaysConfiguration.Verbosity verbosity = AniwaysConfiguration.Verbosity.valueOf(verbosityString);
                        field.set(this, (Object)verbosity);
                    }
                    catch (Throwable e) {
                        Log.e(true, TAG, "Could not parse verbosity: " + verbosityString, e);
                    }
                    continue;
                }
                if (fieldType == IconEncodingMethod.class) {
                    String methodString = "";
                    try {
                        methodString = jsonObject.getString(key);
                        IconEncodingMethod method = IconEncodingMethod.valueOf(methodString);
                        field.set(this, (Object)method);
                    }
                    catch (Throwable e) {
                        Log.e(true, TAG, "Could not parse icon encoding method: " + methodString, e);
                    }
                    continue;
                }
                if (fieldType == AnalyticsCloud.class) {
                    String cloudString = "";
                    try {
                        cloudString = jsonObject.getString(key);
                        AnalyticsCloud cloud = AnalyticsCloud.valueOf(cloudString);
                        field.set(this, (Object)cloud);
                    }
                    catch (Throwable e) {
                        Log.e(true, TAG, "Could not parse analytics cloud: " + cloudString, e);
                    }
                    continue;
                }
                if (fieldType == String[].class) {
                    JSONArray jsonArray = jsonObject.getJSONArray(key);
                    int length2 = jsonArray.length();
                    if (length2 <= 0) continue;
                    value = new String[length2];
                    for (i = 0; i < length2; ++i) {
                        value[i] = jsonArray.getString(i);
                    }
                    field.set(this, value);
                    continue;
                }
                if (fieldType == HashMap.class) {
                    try {
                        JSONObject map = jsonObject.getJSONObject(key);
                        HashMap hm = (HashMap)field.get(this);
                        Iterator iterator = map.keys();
                        while (iterator.hasNext()) {
                            String k = (String)iterator.next();
                            int v = map.getInt(k);
                            hm.put(Float.valueOf(Float.parseFloat(k)), v);
                        }
                        continue;
                    }
                    catch (Throwable e) {
                        Log.e(true, TAG, "Could not parse Hashmap: " + field == null ? "null" : field.toGenericString(), e);
                        continue;
                    }
                }
                if (fieldType != int[].class || (length = (array = jsonObject.optJSONArray(key)).length()) <= 0) continue;
                value = new int[length];
                for (i = 0; i < length; ++i) {
                    value[i] = (String)array.getInt(i);
                }
                field.set(this, value);
            }
            catch (IllegalArgumentException e) {
                Log.e(true, TAG, "Could not parse field: " + key, e);
            }
            catch (IllegalAccessException e) {
                Log.e(true, TAG, "Could not parse field: " + key, e);
            }
            catch (JSONException e) {
                Log.e(true, TAG, "Could not parse field: " + key, e);
            }
        }
    }

    private void convertIconDimentionsToPixels() {
        this.iconInSuggestionPopupWidth = AniwaysUiUtil.convertDipsToPixels(this.iconInSuggestionPopupWidth);
        this.iconInSuggestionPopupHeight = AniwaysUiUtil.convertDipsToPixels(this.iconInSuggestionPopupHeight);
        this.animatedGifInSuggestionPopupWidth = AniwaysUiUtil.convertDipsToPixels(this.animatedGifInSuggestionPopupWidth);
        this.animatedGifInSuggestionPopupHeight = AniwaysUiUtil.convertDipsToPixels(this.animatedGifInSuggestionPopupHeight);
        this.contextualGridRowHeight = AniwaysUiUtil.convertDipsToPixels(this.contextualGridRowHeight);
        this.contextualGridAnimatedItemMinMargin = AniwaysUiUtil.convertDipsToPixels(this.contextualGridAnimatedItemMinMargin);
        this.contextualGridEmoticonItemMinMargin = AniwaysUiUtil.convertDipsToPixels(this.contextualGridEmoticonItemMinMargin);
        this.iconInEditTextWidth = AniwaysUiUtil.convertDipsToPixels(this.iconInEditTextWidth);
        this.iconInEditTextHeight = AniwaysUiUtil.convertDipsToPixels(this.iconInEditTextHeight);
        this.iconInTextViewWidth = AniwaysUiUtil.convertDipsToPixels(this.iconInTextViewWidth);
        this.iconInTextViewHeight = AniwaysUiUtil.convertDipsToPixels(this.iconInTextViewHeight);
        this.smallIconTextWidth = AniwaysUiUtil.convertDipsToPixels(this.smallIconTextWidth);
        this.smallIconTextHeight = AniwaysUiUtil.convertDipsToPixels(this.smallIconTextHeight);
        this.bigIconWidth = AniwaysUiUtil.convertDipsToPixels(this.bigIconWidth);
        this.bigIconHeight = AniwaysUiUtil.convertDipsToPixels(this.bigIconHeight);
        this.bannerWidth = AniwaysUiUtil.convertDipsToPixels(this.bannerWidth);
        this.bannerHeight = AniwaysUiUtil.convertDipsToPixels(this.bannerHeight);
        this.bannerPaddingLeft = AniwaysUiUtil.convertDipsToPixels(this.bannerPaddingLeft);
        this.bannerPaddingTop = AniwaysUiUtil.convertDipsToPixels(this.bannerPaddingTop);
        this.bannerPaddingRight = AniwaysUiUtil.convertDipsToPixels(this.bannerPaddingRight);
        this.bannerPaddingBottom = AniwaysUiUtil.convertDipsToPixels(this.bannerPaddingBottom);
        int onDemandSize = this.useSmallerIconsInIconsOnDemendPopup ? 47 : 70;
        Integer[] sizes = new Integer[]{this.iconInSuggestionPopupWidth, this.iconInSuggestionPopupHeight, this.iconInEditTextWidth, this.iconInEditTextHeight, this.iconInTextViewWidth, this.iconInTextViewHeight, this.smallIconTextWidth, this.smallIconTextHeight, AniwaysUiUtil.convertDipsToPixels(onDemandSize)};
        this.maxIconSize = Collections.max(Arrays.asList(sizes));
        Integer[] sizes2 = new Integer[]{this.bigIconWidth, this.bigIconHeight};
        this.maxBigIconSize = Collections.max(Arrays.asList(sizes2));
        Integer[] sizes3 = new Integer[]{this.bannerWidth, this.bannerHeight};
        this.maxBannerSize = Collections.max(Arrays.asList(sizes3));
    }

    private Pair<Boolean, String> getResourceString(String name, boolean mandatory, Context context) {
        int resId = this.getResourceId(name, "string", context);
        if (mandatory) {
            this.verifyMandatoryResourceId(name, resId);
        }
        if (resId != 0) {
            String result = context.getResources().getString(resId);
            Log.i(TAG, "Found config value for " + name + " in Aniways.xml config file. Value is: " + result);
            return new Pair((Object)true, (Object)result);
        }
        Log.i(TAG, "Did not find config value for " + name + " in Aniways.xml config file. Using default value");
        return new Pair((Object)false, (Object)"");
    }

    private Pair<Boolean, Integer> getResourceInt(String name, boolean mandatory, Context context) {
        int resId = this.getResourceId(name, "integer", context);
        if (mandatory) {
            this.verifyMandatoryResourceId(name, resId);
        }
        if (resId != 0) {
            int result = context.getResources().getInteger(resId);
            Log.i(TAG, "Found config value for " + name + " in Aniways.xml config file. Value is: " + result);
            return new Pair((Object)true, (Object)result);
        }
        Log.i(TAG, "Did not find config value for " + name + " in Aniways.xml config file. Using default value");
        return new Pair((Object)false, (Object)-1);
    }

    private Pair<Boolean, Boolean> getResourceBoolean(String name, boolean mandatory, Context context) {
        int resId = this.getResourceId(name, "bool", context);
        if (mandatory) {
            this.verifyMandatoryResourceId(name, resId);
        }
        if (resId != 0) {
            boolean result = context.getResources().getBoolean(resId);
            Log.i(TAG, "Found config value for " + name + " in Aniways.xml config file. Value is: " + result);
            return new Pair((Object)true, (Object)result);
        }
        Log.i(TAG, "Did not find config value for " + name + " in Aniways.xml config file. Using default value");
        return new Pair((Object)false, (Object)false);
    }

    private int getResourceId(String name, String type, Context context) {
        int result = context.getResources().getIdentifier(name, type, context.getPackageName());
        return result;
    }

    private void verifyMandatoryResourceId(String name, int id2) {
        if (id2 == 0) {
            String errorMessage = "Missing mandatory config value from aniways xml: " + name;
            Log.e(false, TAG, errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static synchronized String getParsedConfigVersion(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        String result = prefs.getString(KEY_PARSED_CONFIG_VERSION, "0.0");
        return result;
    }

    private static synchronized void setParsedConfigVersion(Context context, String version) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString(KEY_PARSED_CONFIG_VERSION, version);
        edit.commit();
    }

    private void setIconInSuggestionPopupSizeInternal(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("received size < 1 for suggestion popup icon. Size was: " + size);
        }
        this.iconInSuggestionPopupWidth = size;
        this.iconInSuggestionPopupHeight = size;
    }

    private void setAnimatedGifInSuggestionPopupSizeInternal(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("received size < 1 for suggestion popup animated gif. Size was: " + size);
        }
        this.animatedGifInSuggestionPopupWidth = size;
        this.animatedGifInSuggestionPopupHeight = size;
    }

    private void setIconInEditTextSizeInternal(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("received size < 1 for edit text icon. Size was: " + size);
        }
        this.iconInEditTextWidth = size;
        this.iconInEditTextHeight = size;
    }

    private void setSmallIconSizeInternal(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("received size < 1 for small icon. Size was: " + size);
        }
        this.smallIconTextWidth = size;
        this.smallIconTextHeight = size;
    }

    private void setBigIconSizeInternal(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("received size < 1 for big icon. Size was: " + size);
        }
        this.bigIconWidth = size;
        this.bigIconHeight = size;
    }

    private void setBannerSizeInternal(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("received size < 1 for banner. Size was: " + size);
        }
        this.bannerWidth = size;
        this.bannerHeight = size;
    }

    void setIconInTextViewSizeInternal(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("received size < 1 for text view icon. Size was: " + size);
        }
        this.iconInTextViewWidth = size;
        this.iconInTextViewHeight = size;
    }

    private void setUseEditTextTutorialInternal(boolean useIt) {
        if (!useIt) {
            Log.w(false, TAG, "Turning off EditText tutorial. This means that the users will not learn to click on highlighted words.");
        }
        this.useEditTextTutorial = useIt;
    }

    private void setDisableCreditStoreBalanceButton(boolean disable) {
        this.disableCreditStoreIcon = disable;
    }

    private void setUseTextViewTutorialInternal(boolean useIt) {
        if (!useIt) {
            // empty if block
        }
        this.useTextViewTutorial = useIt;
    }

    private void setMaxTimesToShowTutorialInternal(int times) {
        if (times < 0) {
            throw new IllegalArgumentException("received times to show tutorial < 0. Times was: " + times);
        }
        if (times < 1) {
            Log.w(false, TAG, "Received max time to show tutorial < 1 ( " + times + "). If your intention is to turn off the tutorial then set useTextViewTutorial and useEditTextTutorial properties to false");
        }
        this.maxTimesToShowTutorial = times;
    }

    private void setAppPublicKeyForCreditsStoreInternal(String key) {
        if (key == null || Utils.isStringEmpty(key) || key.equalsIgnoreCase(DEFAULT_PUBLIC_KEY)) {
            Log.e(false, TAG, "Illegal app public key!! You must supply the application's public key. If the store is not enabled then remove this config value. If you would like to set it in code and not in the XML config then remove it from the XML");
            throw new IllegalArgumentException("Illegal app public key!! You must supply the application's public key. If the store is not enabled then remove this config value. If you would like to set it in code and not in the XML config then remove it from the XML");
        }
        this.appPublicKeyForCreditsStore = key;
    }

    private void setCreditsStoreInitialCreditsInternal(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("received initial store credits amount < 0. Amount was: " + amount);
        }
        if (amount < 10) {
            Log.w(false, TAG, "Received initial store credits of " + amount + " which is smaller than 10 (the minimum amount to unlock one icon). \nWe recommend to set it to something like 100 to get the user used to using credits to unlocking icons and increase the chances that he she would buy credits later.");
        }
        this.creditsStoreInitialCredits = amount;
    }

    private void setCreditsSkuInternal(int amount, String sku) {
        if (sku == null || Utils.isStringEmpty(sku)) {
            throw new IllegalArgumentException("Received sku that is null or empty");
        }
        switch (amount) {
            case 100: {
                this.creditsSku100 = sku;
                break;
            }
            case 250: {
                this.creditsSku250 = sku;
                break;
            }
            case 500: {
                this.creditsSku500 = sku;
                break;
            }
            case 1000: {
                this.creditsSku1000 = sku;
                break;
            }
            case 2000: {
                this.creditsSku2000 = sku;
                break;
            }
            case 3000: {
                this.creditsSku3000 = sku;
            }
        }
    }

    private void setUpgradeMessageInternal(String upgradeMessage) {
        if (upgradeMessage == null) {
            upgradeMessage = "";
        }
        if (upgradeMessage.length() == 0) {
            Log.w(false, TAG, "The upgrade message is empty. This means that users without a version with Aniways SDK will receive messages with the upgrade url as their suffix without an explenation");
        }
        upgradeMessage = "\n\n" + upgradeMessage + " ";
    }

    private void setUpgradeUrlInternal(String url) {
    }

    private void setNumberOfWordsRequiredToShowTutorialAgainInternal(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("received number to show tutorial again < 0. Number was: " + number);
        }
        this.numberOfWordsRequiredToShowTutorialAgain = number;
    }

    private void setLogsVerbosityInternal(String verbosity) {
        try {
            this.logsVerbosity = AniwaysConfiguration.Verbosity.valueOf(verbosity);
        }
        catch (Throwable e) {
            String enums = "";
            for (AniwaysConfiguration.Verbosity v : AniwaysConfiguration.Verbosity.values()) {
                String name = v.name();
                enums = enums + ", " + name;
            }
            if (enums.length() > 2) {
                enums = enums.substring(2);
            }
            String errorMessage = "Error parsing verbosity from configuration. Value was: " + verbosity + ". The value needs to be one of the following: " + enums;
            Log.e(true, TAG, errorMessage);
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    private void setIconEncodingMethodInternal(String method) {
        try {
            this.iconEncodingMethod = IconEncodingMethod.valueOf(method);
        }
        catch (Throwable e) {
            String enums = "";
            for (IconEncodingMethod v : IconEncodingMethod.values()) {
                String name = v.name();
                enums = enums + ", " + name;
            }
            if (enums.length() > 2) {
                enums = enums.substring(2);
            }
            String errorMessage = "Error parsing IconEncodingMethod from configuration. Value was: " + method + ". The value needs to be one of the following: " + enums;
            Log.e(true, TAG, errorMessage);
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    private void setRemovePoweredByAniwaysInternal(Boolean remove) {
        this.removePoweredByAniways = remove;
    }

    private void setAutoReplaceKeyPhrasesInTextView(Boolean replace) {
        this.autoReplaceKeyPhrasesInTextView = replace;
    }

    private void setAutoreplaceKeyPhrasesOnEncode(Boolean replace) {
        this.autoReplaceKeyPhrasesOnEncode = replace;
    }

    public boolean isGoogleAnalyticsDisabled() {
        return this.googleAnalyticsEventsVerbosity == AniwaysConfiguration.Verbosity.Off && this.gaTimingEventsVerbosity == AniwaysConfiguration.Verbosity.Off && this.gaScreenEventsVerbosity == AniwaysConfiguration.Verbosity.Off;
    }

    public boolean isAnalyticsDisabled() {
        return this.analyticsEventsVerbosity == AniwaysConfiguration.Verbosity.Off && this.timingEventsVerbosity == AniwaysConfiguration.Verbosity.Off && this.screenEventsVerbosity == AniwaysConfiguration.Verbosity.Off;
    }

    public int getIconPriceInCredits(IconData icon) {
        return this.defalutLockedIconPrice;
    }

    public static AniwaysConfiguration.Verbosity getLogsVerbosity() {
        return sLogsVerbosity;
    }

    public boolean isLowMemoryDevice() {
        return this.isLowMemoryDevice;
    }

    public boolean isExtremeLowMemoryDevice() {
        return this.isExtremeLowMemoryDevice;
    }

    private void calculateIsLowMemoryDevice() {
        this.isLowMemoryDevice = this.calculateIsDeviceMemoryBelowThrwshold(this.lowMemoryThreshold);
    }

    private void calculateIsExtremeLowMemoryDevice() {
        this.isExtremeLowMemoryDevice = this.calculateIsDeviceMemoryBelowThrwshold(this.disableAniwaysExperianceMemoryThreshold);
    }

    private boolean calculateIsDeviceMemoryBelowThrwshold(HashMap<Float, Integer> thresholds) {
        float density = this.calculateDisplayDensity(sContext);
        Object[] arr = new Float[thresholds.keySet().size()];
        int maxMem = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        thresholds.keySet().toArray(arr);
        Arrays.sort(arr);
        for (int i = 0; i < arr.length; ++i) {
            float den = ((Float)arr[i]).floatValue();
            if (!(density <= den)) continue;
            int threshold = thresholds.get(Float.valueOf(den));
            return maxMem <= threshold;
        }
        return false;
    }

    private float calculateDisplayDensity(Context context) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        if (manager != null) {
            DisplayMetrics metrics = new DisplayMetrics();
            Display display = manager.getDefaultDisplay();
            display.getMetrics(metrics);
            return metrics.density;
        }
        return 1.0f;
    }

    private void calculateEncodingParams() {
        int i;
        this.delimiterString = new String(new int[]{Integer.parseInt(this.delimiter, 16)}, 0, 1);
        String[] decoderCodes = this.decoderCodepointsString.split("-");
        this.decoderRadix = decoderCodes.length;
        int[] decoderCodepoints = new int[this.decoderRadix];
        for (i = 0; i < this.decoderRadix; ++i) {
            decoderCodepoints[i] = Integer.parseInt(decoderCodes[i], 16);
        }
        this.decoderCodepointStrings = new String[this.decoderRadix];
        for (i = 0; i < this.decoderRadix; ++i) {
            this.decoderCodepointStrings[i] = new String(decoderCodepoints, i, 1);
        }
    }

    public boolean getUseBlurEffect() {
        Log.i(TAG, "Min blur android version: " + this.minBlurAndroidVersion + ". CPU: " + Build.CPU_ABI);
        Log.i(TAG, "height: " + this.iconInEditTextHeight + ". Width: " + this.iconInEditTextWidth + " Size: " + this.iconInEditTextSize);
        if (!Utils.isAndroidVersionAtLeast(this.minBlurAndroidVersion)) {
            return false;
        }
        if (!Build.CPU_ABI.equalsIgnoreCase("armeabi-v7a") && !Build.CPU_ABI.equalsIgnoreCase("mips-r2")) {
            return false;
        }
        Log.i(TAG, "Using blur effecr");
        return this.useBlurEffect;
    }

    public int getMaxWidthForCache(IconData icon) {
        if (icon.isEmoji() && this.useSmallEmoji) {
            return this.smallIconTextWidth;
        }
        return this.maxIconSize;
    }

    public int getMaxHeightForCache(IconData icon) {
        if (icon.isEmoji() && this.useSmallEmoji) {
            return this.smallIconTextHeight;
        }
        return this.maxIconSize;
    }

    public String getIconUrl(IconData icon, boolean displayBig, boolean displayBanner) {
        String url = icon.getUrl(this.useSmallEmoji, displayBig, displayBanner);
        if (url != null) {
            return url;
        }
        if (icon.isEmoji() && this.useSmallEmoji) {
            return this.emojiUrl + "/" + icon.getFileName();
        }
        if (displayBig) {
            return this.bigIconsUrl + "/" + icon.getFileName();
        }
        if (displayBanner) {
            return this.bannerUrl + "/" + icon.getFileName();
        }
        return this.assetsUrl + "/" + icon.getFileName();
    }

    public boolean useSmallIcon(IconData icon) {
        return icon.isEmoji() && this.useSmallEmoji;
    }

    public boolean canBeDisplayedBig(IconData icon) {
        return !this.useSmallIcon(icon);
    }

    static {
        sInstanceNumber = 0;
    }

    public static enum AnalyticsCloud {
        Amazon,
        Aniways,
        Azure;

    }

    public static enum SuggestionMode {
        Manual,
        AutoDisplaySuggestions,
        AutoReplacePhrases;

    }

    public static enum IconLocation {
        EditText,
        TextView,
        SuggestionPopup;

    }

    public static enum IconEncodingMethod {
        Invisible,
        ViralLink;

    }
}

