/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.VersionComparisonResult;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.JsonParser;
import java.util.ArrayList;
import java.util.List;

public class AniwaysPhraseReplacementData {
    private static JsonParser sParser;
    private static boolean sInitCalled;
    private static final String TAG = "AniwaysPhraseReplacementData";
    public static final String EMPTY_PARSER_VERSION = "0.0";
    private static Context sContext;
    private static List<IOnNonEmptyParserSetListener> sOnNonEmptyParserSetListeners;

    static void forceInit(Context context) {
        if (sParser != null) {
            Log.w(true, TAG, "Calling init of AniwaysWordReplacementData more than once");
        }
        sInitCalled = true;
        sContext = context;
        sOnNonEmptyParserSetListeners = new ArrayList<IOnNonEmptyParserSetListener>();
        sParser = new JsonParser();
    }

    static JsonParser parseData(JsonParser.InputStreamProvider inputStreamProvider) {
        if (!sInitCalled) {
            Log.e(true, TAG, "ParseData called b4 init");
        }
        Log.i(TAG, "Parsing Keywords Json");
        try {
            JsonParser parser = new JsonParser();
            parser.parseDataFile(inputStreamProvider);
            return parser;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Error parsing json", ex);
            return JsonParser.emptyInstance;
        }
    }

    static synchronized void setNewParser(JsonParser parser, String expectedVersion) {
        if (!sInitCalled) {
            Log.e(true, TAG, "setNewParser called b4 init");
        }
        Log.i(TAG, "Setting new parser");
        if (parser.isEmpty()) {
            if (!Utils.isVersionLegal(expectedVersion)) {
                Log.e(true, TAG, "Received illegel expected version, so not setting new parser: " + expectedVersion);
                if (sParser.isEmpty()) {
                    sParser.setKeywordsVersion("0.1");
                }
                return;
            }
            Log.w(true, TAG, "Got an empty new parser, so sticking with the old one, with version: " + sParser.getKeywordsVersion() + ". Setting its version to the expected version of the new one in order not to try and parse over and over again: " + expectedVersion);
            parser = sParser;
            parser.setKeywordsVersion(expectedVersion);
        }
        sParser = parser;
        String oldKeywordsVersion = AniwaysPhraseReplacementData.getParsedKeywordsVersion();
        AniwaysPhraseReplacementData.setParsedKeywordsVersion(parser.getKeywordsVersion());
        VersionComparisonResult keywordsResult = null;
        try {
            keywordsResult = Utils.compareVersionStrings(parser.getKeywordsVersion(), oldKeywordsVersion);
        }
        catch (IllegalArgumentException e) {
            Log.e(true, TAG, "Error parsing keywords version: " + oldKeywordsVersion, e);
        }
        if (keywordsResult != null) {
            if (keywordsResult.result == 1) {
                if (AnalyticsReporter.isInitialized()) {
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Updated Keywords Version", "from: " + oldKeywordsVersion + ", to: " + parser.getKeywordsVersion(), 0L);
                    AnalyticsReporter.reportUpdatedKeywordsVersion(oldKeywordsVersion, parser.getKeywordsVersion());
                }
            } else if (keywordsResult.result == 0) {
                Log.i(TAG, "Setting new keywords parser to version which has already been parsed when the app was running at a previous time: " + parser.getKeywordsVersion());
            } else {
                Log.e(true, TAG, "Setting parser for lower version than was parsed before. Old version: " + oldKeywordsVersion + " . New version:" + parser.getKeywordsVersion());
            }
        }
        if (AnalyticsReporter.isInitialized()) {
            GoogleAnalyticsReporter.reportCustomDimention(4, parser.getKeywordsVersion());
        }
        if (!sParser.isEmpty()) {
            Log.d(TAG, "Setting non empty parser and calling all the listeners on the UI thread: " + sOnNonEmptyParserSetListeners.size());
            Handler h = new Handler(Looper.getMainLooper());
            int i = 0;
            for (final IOnNonEmptyParserSetListener listener : sOnNonEmptyParserSetListeners) {
                final int counter = ++i;
                h.post((Runnable)new NonThrowingRunnable(TAG, "Calling on set non empty parser listener", ""){

                    @Override
                    public void innerRun() {
                        Log.d(AniwaysPhraseReplacementData.TAG, "Start onNonEmptyParserSet listener number: " + counter);
                        listener.onNonEmptyParserSet(sParser);
                        Log.d(AniwaysPhraseReplacementData.TAG, "End onNonEmptyParserSet listener number: " + counter);
                    }
                });
            }
            sOnNonEmptyParserSetListeners.clear();
        } else {
            Log.w(false, TAG, "Setting an empty parser");
        }
    }

    public static synchronized void addOnNonEmptyParserSetListener(IOnNonEmptyParserSetListener listener) {
        sOnNonEmptyParserSetListeners.add(listener);
    }

    public static JsonParser getDataParser() {
        return sParser;
    }

    private static synchronized String getParsedKeywordsVersion() {
        return AniwaysPhraseReplacementData.getParsedKeywordsVersion(sContext);
    }

    public static synchronized String getParsedKeywordsVersion(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        return prefs.getString("com.aniways.PARSED_KEYWORDS_VERSION", EMPTY_PARSER_VERSION);
    }

    public static synchronized void setParsedKeywordsVersion(String version) {
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString("com.aniways.PARSED_KEYWORDS_VERSION", version);
        edit.commit();
    }

    public static boolean isInit() {
        return sParser != null;
    }

    static {
        sInitCalled = false;
    }

    public static interface IOnNonEmptyParserSetListener {
        public void onNonEmptyParserSet(JsonParser var1);
    }
}

