/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.media.MediaPlayer;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.billing.AniwaysCreditsStoreActivity;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.data.JsonParser;
import java.util.UUID;

public class AniwaysLockedIconHelper {
    private static final int CREDITS_CHANGE_ANIMATION_TIME = 600;
    private static final String TAG = "AniwaysLockedIconHelper";
    protected static final long CHECK_RETURN_FROM_STORE_INTERVAL = 100L;
    private JsonParser mParser;
    private boolean launchedStoreFromTryingToUnlockIcon = false;
    private boolean launchedStoreFromButton = false;
    private int verticalLocationOfAnchorOnScreenBeforeStoreLaunched = 0;
    private CompleteIconUnlockSequenceData lastCompleteIconUnlockSequenceData = null;
    private OnItemContainingLockedIconClickListener mOnItemContainingLockedIconClickListener = null;
    private PopupWindow mPopup;
    private TextView mCreditsBalanceButton;
    private OnStoreAboutToLaunchListener mStoreLaunchListener;
    private Context mContext;
    private String mSourceScreen;
    private View mAnchorView;
    private NonThrowingRunnable mCheckReturnFromStoreRunnable;
    private boolean mDetectedStoreOpened = false;

    public AniwaysLockedIconHelper(JsonParser parser, OnItemContainingLockedIconClickListener clickListener, OnStoreAboutToLaunchListener storeLauchListener, TextView creditsBalanceButton, PopupWindow popup, View anchorView, boolean showCreditsIfStoreIsEnabled, Context context, String sourceScreen) {
        this.validateConstructorParam(clickListener, "clickListener");
        this.validateConstructorParam(popup, "popup");
        this.validateConstructorParam(creditsBalanceButton, "creditsBalanceButton");
        this.mParser = parser;
        this.mOnItemContainingLockedIconClickListener = clickListener;
        this.mPopup = popup;
        this.mCreditsBalanceButton = creditsBalanceButton;
        this.mStoreLaunchListener = storeLauchListener;
        this.mContext = context;
        this.mSourceScreen = sourceScreen;
        this.mAnchorView = anchorView;
        this.setupCreditsBalanceButton(showCreditsIfStoreIsEnabled);
        this.setupCheckReturnedFromStore();
    }

    @SuppressLint(value={"NewApi"})
    public void setIconAndLockVisibility(ImageView img, ImageView lock, IconData icon) {
        if (this.mParser != null && icon != null && AniwaysStoreManager.isIconLocked(icon)) {
            lock.setVisibility(0);
            if (Utils.isAndroidVersionAtLeast(11)) {
                img.setAlpha(AniwaysPrivateConfig.getInstance().lockedIconAlpha);
            } else {
                img.setAlpha((int)(AniwaysPrivateConfig.getInstance().lockedIconAlpha * 255.0f));
            }
        } else {
            lock.setVisibility(8);
        }
    }

    public void onIconClicked(ImageView img, ImageView lock, IconData icon, Object iconClickContext, OnItemContainingLockedIconClickListener iconClickListener) {
        this.mOnItemContainingLockedIconClickListener = iconClickListener;
        this.onIconClicked(img, lock, icon, iconClickContext);
    }

    public void onIconClicked(ImageView img, ImageView lock, IconData icon, Object iconClickContext) {
        if (this.mParser != null && icon != null && AniwaysStoreManager.isIconLocked(icon)) {
            CompleteIconUnlockSequenceData completeUnlockData = new CompleteIconUnlockSequenceData(icon, lock, img, iconClickContext);
            if (AniwaysStoreManager.canUserBuyIcon(icon)) {
                this.resetLaunchedStoreParams();
                this.completeUnlockIconSequence(completeUnlockData);
            } else {
                try {
                    this.launchCreditsStore(completeUnlockData);
                }
                catch (Throwable ex) {
                    Log.e(true, TAG, "Error starting Store activity folowing trying to unlock icon", ex);
                }
            }
        } else {
            this.callOnItemClickedListener(iconClickContext);
        }
    }

    public JsonParser getDataParser() {
        return this.mParser;
    }

    public Context getContext() {
        return this.mContext;
    }

    private void setupCheckReturnedFromStore() {
        this.mCheckReturnFromStoreRunnable = new NonThrowingRunnable(TAG, "while checking if returned from store", ""){

            @Override
            public void innerRun() {
                if (AniwaysCreditsStoreActivity.sIsRunning) {
                    AniwaysLockedIconHelper.this.mDetectedStoreOpened = true;
                    AniwaysLockedIconHelper.this.mAnchorView.postDelayed((Runnable)AniwaysLockedIconHelper.this.mCheckReturnFromStoreRunnable, 100L);
                    return;
                }
                if (!AniwaysLockedIconHelper.this.mDetectedStoreOpened) {
                    AniwaysLockedIconHelper.this.mAnchorView.postDelayed((Runnable)AniwaysLockedIconHelper.this.mCheckReturnFromStoreRunnable, 100L);
                    return;
                }
                AniwaysLockedIconHelper.this.mDetectedStoreOpened = false;
                AniwaysLockedIconHelper.this.onReturnFromStore();
            }
        };
    }

    private void onReturnFromStore() {
        block7: {
            try {
                InputMethodManager inputMethodManager;
                Log.i(TAG, "Returning from store..");
                if (this.verticalLocationOfAnchorOnScreenBeforeStoreLaunched != this.getAnchorViewLocationOnScreen() && (inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method")) != null) {
                    inputMethodManager.toggleSoftInputFromWindow(this.mAnchorView.getApplicationWindowToken(), 1, 0);
                }
                if (this.mStoreLaunchListener != null) {
                    this.mStoreLaunchListener.onStoreClosing();
                }
                final boolean wasLaunchedStoreFromTryingToUnlockIcon = this.launchedStoreFromTryingToUnlockIcon;
                final CompleteIconUnlockSequenceData completeIconUnlockSequenceDataLocal = this.lastCompleteIconUnlockSequenceData;
                this.resetLaunchedStoreParams();
                if (!wasLaunchedStoreFromTryingToUnlockIcon && !this.launchedStoreFromButton) break block7;
                int lastCreditsBalance = 0;
                try {
                    lastCreditsBalance = Integer.parseInt(this.mCreditsBalanceButton.getText().toString());
                }
                catch (NumberFormatException e) {
                    Log.e(true, TAG, "Could not convert the credits balance in the popup to an integer", e);
                }
                if (lastCreditsBalance != AniwaysStoreManager.getUserCreditsLeft()) {
                    this.mAnchorView.post((Runnable)new NonThrowingRunnable(TAG, "changing credits value", ""){

                        @Override
                        public void innerRun() {
                            if (!AniwaysLockedIconHelper.this.mCreditsBalanceButton.isShown()) {
                                // empty if block
                            }
                            AnimationSet creditsChangeAnimation = AniwaysLockedIconHelper.this.getCreditsChangeAnimation();
                            int creditsChangeDuration = 600;
                            AniwaysLockedIconHelper.this.mCreditsBalanceButton.startAnimation((Animation)creditsChangeAnimation);
                            if (wasLaunchedStoreFromTryingToUnlockIcon) {
                                if (AniwaysStoreManager.canUserBuyIcon(completeIconUnlockSequenceDataLocal.icon)) {
                                    AniwaysLockedIconHelper.this.mAnchorView.postDelayed((Runnable)new NonThrowingRunnable(AniwaysLockedIconHelper.TAG, "completing unlock sequence", ""){

                                        @Override
                                        public void innerRun() {
                                            AniwaysLockedIconHelper.this.completeUnlockIconSequence(completeIconUnlockSequenceDataLocal);
                                        }
                                    }, (long)creditsChangeDuration);
                                } else {
                                    Log.w(true, AniwaysLockedIconHelper.TAG, "Returning from store, credits amount changed, but still cannot unlock icon: " + completeIconUnlockSequenceDataLocal.icon.getFileName() + " . Available credits: " + AniwaysStoreManager.getUserCreditsLeft());
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                Log.e(true, TAG, "Error in global layout change", e);
            }
        }
    }

    private void setupCreditsBalanceButton(boolean showCreditsIfStoreIsEnabled) {
        if (showCreditsIfStoreIsEnabled && AniwaysStoreManager.isStoreEnabled()) {
            this.mCreditsBalanceButton.setVisibility(0);
            this.mCreditsBalanceButton.setText((CharSequence)Integer.toString(AniwaysStoreManager.getUserCreditsLeft()));
            this.mCreditsBalanceButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        if (AniwaysPrivateConfig.getInstance().disableCreditStoreIcon) {
                            Log.v(AniwaysLockedIconHelper.TAG, "Credit store balance button is disabled");
                            return;
                        }
                        AniwaysLockedIconHelper.this.launchCreditsStore(null);
                    }
                    catch (Throwable ex) {
                        Log.e(true, AniwaysLockedIconHelper.TAG, "Error starting Store activity following a click on the store balance", ex);
                    }
                }
            });
            this.mCreditsBalanceButton.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    try {
                        if (AniwaysPrivateConfig.getInstance().disableCreditStoreIcon) {
                            AniwaysLockedIconHelper.this.launchCreditsStore(null);
                            return true;
                        }
                    }
                    catch (Throwable ex) {
                        Log.e(true, AniwaysLockedIconHelper.TAG, "Error starting Store activity following a long click on the store balance", ex);
                    }
                    return false;
                }
            });
        } else {
            this.mCreditsBalanceButton.setVisibility(8);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void completeUnlockIconSequence(final CompleteIconUnlockSequenceData completeIconUnlockSequenceData) throws IllegalStateException {
        if (this.mPopup != null && !this.mPopup.isShowing()) {
            Log.w(true, TAG, "Received request to complete unlock sequence, but the popup is no longer showing");
            return;
        }
        AniwaysStoreManager.unlockIconAndDecreaseCredits(this.mSourceScreen, completeIconUnlockSequenceData.icon);
        if (!this.mCreditsBalanceButton.isShown()) {
            // empty if block
        }
        AnimationSet creditsChangeAnimation = this.getCreditsChangeAnimation();
        if (Utils.isAndroidVersionAtLeast(11)) {
            completeIconUnlockSequenceData.img.setAlpha(1.0f);
        } else {
            completeIconUnlockSequenceData.img.setAlpha(255);
        }
        AlphaAnimation fadeInAnimation = new AlphaAnimation(AniwaysPrivateConfig.getInstance().lockedIconAlpha, 1.0f);
        fadeInAnimation.setDuration(1200L);
        fadeInAnimation.setStartOffset(0L);
        fadeInAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        AlphaAnimation fadeOutAnimation = new AlphaAnimation(1.0f, 0.0f);
        fadeOutAnimation.setDuration(1200L);
        fadeOutAnimation.setStartOffset(0L);
        fadeOutAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
        completeIconUnlockSequenceData.img.startAnimation((Animation)fadeInAnimation);
        completeIconUnlockSequenceData.lock.startAnimation((Animation)fadeOutAnimation);
        this.mCreditsBalanceButton.startAnimation((Animation)creditsChangeAnimation);
        try {
            MediaPlayer mp = MediaPlayer.create((Context)completeIconUnlockSequenceData.img.getContext(), (int)R.raw.aniways_unlock_icon_sound);
            if (mp == null) {
                Log.e(true, TAG, "Failed to create media player for the unlock icon");
            } else {
                mp.start();
                mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        try {
                            mp.release();
                        }
                        catch (Throwable ex) {
                            Log.e(true, AniwaysLockedIconHelper.TAG, "Caught Exception while completing playing a sound");
                        }
                    }
                });
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught exception while creating media player for the unlock icon");
        }
        completeIconUnlockSequenceData.img.postDelayed((Runnable)new NonThrowingRunnable(TAG, "conmpleting unlock icon sequence after animations finish", ""){

            @Override
            public void innerRun() {
                completeIconUnlockSequenceData.lock.setVisibility(8);
                AniwaysLockedIconHelper.this.callOnItemClickedListener(completeIconUnlockSequenceData.iconClickedContext);
            }
        }, 1200L);
    }

    private AnimationSet getCreditsChangeAnimation() {
        AnimationSet s = new AnimationSet(false);
        AlphaAnimation creditsBalancefadeInAnimation = new AlphaAnimation(0.0f, 1.0f);
        creditsBalancefadeInAnimation.setDuration(300L);
        creditsBalancefadeInAnimation.setStartOffset(0L);
        creditsBalancefadeInAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        AlphaAnimation creditsBalanceFadeOutAnimation = new AlphaAnimation(1.0f, 0.0f);
        creditsBalanceFadeOutAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                try {
                    AniwaysLockedIconHelper.this.mCreditsBalanceButton.setText((CharSequence)Integer.toString(AniwaysStoreManager.getUserCreditsLeft()));
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysLockedIconHelper.TAG, "Caught an Exception in onAnimationEnd", ex);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        creditsBalanceFadeOutAnimation.setDuration(300L);
        creditsBalanceFadeOutAnimation.setStartOffset(0L);
        creditsBalanceFadeOutAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
        s.addAnimation((Animation)creditsBalanceFadeOutAnimation);
        s.addAnimation((Animation)creditsBalancefadeInAnimation);
        s.setRepeatCount(0);
        return s;
    }

    private void callOnItemClickedListener(Object iconClickContext) {
        if (this.mOnItemContainingLockedIconClickListener != null) {
            this.mOnItemContainingLockedIconClickListener.onItemClick(iconClickContext);
        }
    }

    private void launchCreditsStore(CompleteIconUnlockSequenceData completeUnlockData) {
        boolean followingClickOnStoreBalance = completeUnlockData == null;
        Intent creditsStoreIntent = new Intent(this.mCreditsBalanceButton.getContext(), AniwaysCreditsStoreActivity.class);
        creditsStoreIntent.addFlags(0x20000000);
        creditsStoreIntent.putExtra("com.aniways.GENERATED_BY_TRYING_TO_UNLOCK_ICON", !followingClickOnStoreBalance);
        String iconPath = null;
        if (!followingClickOnStoreBalance) {
            iconPath = completeUnlockData.icon.getFileName();
            creditsStoreIntent.putExtra("com.aniways.ICON_TRYING_TO_UNLOCK", iconPath);
        }
        String id2 = UUID.randomUUID().toString();
        creditsStoreIntent.putExtra("com.aniways.ID", id2);
        creditsStoreIntent.putExtra("com.aniways.SOURCE_SCREEN", this.mSourceScreen);
        int creditsBalance = AniwaysStoreManager.getUserCreditsLeft();
        GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Store", "Open Store", followingClickOnStoreBalance ? "clicked on store balance" : iconPath, creditsBalance);
        AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.launchingStore, id2, creditsBalance, 0, 0, !followingClickOnStoreBalance, !followingClickOnStoreBalance ? iconPath : null, this.mSourceScreen, null, null, null);
        if (this.mStoreLaunchListener != null) {
            this.mStoreLaunchListener.onStoreAboutToLaunch();
        }
        this.setLaunchedStoreParams(completeUnlockData);
        InputMethodManager inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(this.mAnchorView.getApplicationWindowToken(), 0);
        }
        Context context = followingClickOnStoreBalance ? this.mCreditsBalanceButton.getContext() : completeUnlockData.img.getContext();
        context.startActivity(creditsStoreIntent);
        try {
            this.mAnchorView.post((Runnable)this.mCheckReturnFromStoreRunnable);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in posting mCheckReturnFromStoreRunnable", ex);
        }
        Log.i(TAG, "Starting the credits store " + (followingClickOnStoreBalance ? "following a click on the store balance" : ""));
    }

    private void setLaunchedStoreParams(CompleteIconUnlockSequenceData completeUnlockData) {
        boolean followingClickOnStoreBalance = completeUnlockData == null;
        this.launchedStoreFromTryingToUnlockIcon = !followingClickOnStoreBalance;
        this.launchedStoreFromButton = followingClickOnStoreBalance;
        this.lastCompleteIconUnlockSequenceData = completeUnlockData;
        this.verticalLocationOfAnchorOnScreenBeforeStoreLaunched = this.getAnchorViewLocationOnScreen();
    }

    private void resetLaunchedStoreParams() {
        this.launchedStoreFromTryingToUnlockIcon = false;
        this.launchedStoreFromButton = false;
        this.lastCompleteIconUnlockSequenceData = null;
    }

    private void validateConstructorParam(Object param, String paramName) {
        if (param == null) {
            throw new IllegalArgumentException("Null param: " + paramName);
        }
    }

    private int getAnchorViewLocationOnScreen() {
        Rect r = new Rect();
        this.mAnchorView.getWindowVisibleDisplayFrame(r);
        int[] loc = new int[2];
        this.mAnchorView.getLocationOnScreen(loc);
        return loc[1] + r.bottom;
    }

    private class CompleteIconUnlockSequenceData {
        final ImageView lock;
        final ImageView img;
        final Object iconClickedContext;
        final IconData icon;

        public CompleteIconUnlockSequenceData(IconData icon, ImageView lock, ImageView img, Object iconClickedContext) {
            this.iconClickedContext = iconClickedContext;
            this.img = img;
            this.lock = lock;
            this.icon = icon;
        }
    }

    public static interface OnStoreAboutToLaunchListener {
        public void onStoreAboutToLaunch();

        public void onStoreClosing();
    }

    public static interface OnItemContainingLockedIconClickListener {
        public void onItemClick(Object var1);
    }
}

