/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Process;
import aniways.com.google.gson.stream.JsonReader;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.VersionComparisonResult;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStatics;
import com.aniways.data.AniwaysStorageManager;
import com.aniways.data.JsonParser;
import com.aniways.service.AniwaysAlarmListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class AniwaysBackendSyncChecker
extends NonThrowingRunnable {
    private static final String TAG = "AniwaysBackendSyncChecker";
    private static final String THREAD_NAME = "AniwaysBackendSyncChecker";
    static final String BACKEND_SYNC_CHECKER_KEY = "AniwaysBackendSyncChecker";
    private static AniwaysBackendSyncChecker sInstance;
    private Thread mThread;
    private static volatile long sLastBackendSyncRequest;
    private static volatile long sLastBackendSyncThreadRunningCheck;
    private static Context sContext;
    private static Handler sHandler;

    public static void forceInit(Context applicationContext) {
        if (sInstance != null) {
            Log.e(true, "AniwaysBackendSyncChecker", "Calling init of Backend Sync Checker more than once");
        }
        sContext = applicationContext;
        sHandler = new Handler(sContext.getMainLooper());
        AniwaysBackendSyncChecker instance = new AniwaysBackendSyncChecker(applicationContext);
        Thread thread = new Thread(instance);
        thread.setName("AniwaysBackendSyncChecker");
        instance.setThread(thread);
        if (sInstance != null) {
            Log.i("AniwaysBackendSyncChecker", "There is already a backend sync thread running, so interrupting it");
            Thread oldThread = sInstance.getThread();
            oldThread.interrupt();
        }
        Log.i("AniwaysBackendSyncChecker", "Starting the backend sync thread..");
        thread.start();
        sInstance = instance;
    }

    private Thread getThread() {
        return this.mThread;
    }

    private void setThread(Thread thread) {
        this.mThread = thread;
    }

    public AniwaysBackendSyncChecker(Context context) {
        super("AniwaysBackendSyncChecker", "run", "");
    }

    @Override
    public void innerRun() {
        try {
            Process.setThreadPriority((int)9);
        }
        catch (Throwable ex) {
            Log.e(true, "AniwaysBackendSyncChecker", "Could not set thead priority");
        }
        while (true) {
            Log.i("AniwaysBackendSyncChecker", "Backend sync calling parseConfingAndKeywordsIfNecessary..");
            AniwaysBackendSyncChecker.parseConfingAndKeywordsIfNecessary(sContext, false, false);
            try {
                boolean keywordsVersionZero = AniwaysPhraseReplacementData.getDataParser().isEmpty();
                long sleepTime = keywordsVersionZero ? AniwaysPrivateConfig.getInstance().shortIntervalBetweenBackendSyncMillis : AniwaysPrivateConfig.getInstance().longIntervalBetweenBackendSyncMillis;
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e1) {
                Log.w(true, "AniwaysBackendSyncChecker", "Thread interrupted while waiting for next backend sync cycle", e1);
                return;
            }
        }
    }

    static void makeSureRunning() {
        Log.d("AniwaysBackendSyncChecker", "Checking if the backend sync thread is running");
        Thread thread = sInstance.getThread();
        if (!thread.isAlive()) {
            Log.w(true, "AniwaysBackendSyncChecker", "Backend Sync thread was not running. Restarting it..");
            thread = new Thread(sInstance);
            thread.setName("AniwaysBackendSyncChecker");
            thread.start();
        }
    }

    public static void requestSyncWithServerIfNecessary() {
        long now = System.currentTimeMillis();
        boolean keywordsVersionIsZero = AniwaysPhraseReplacementData.getDataParser().getKeywordsVersion().equalsIgnoreCase("0.0");
        if (now - sLastBackendSyncRequest > AniwaysPrivateConfig.getInstance().backendSyncRequestInterval || keywordsVersionIsZero) {
            Context context = sContext.getApplicationContext();
            AniwaysAlarmListener alarmListener = new AniwaysAlarmListener();
            alarmListener.sendWakefulWork(context, false);
            sLastBackendSyncRequest = now;
        }
        if (now - sLastBackendSyncThreadRunningCheck > 300000L) {
            AniwaysStatics.makeSureBackendSyncThreadIsRunning();
            sLastBackendSyncThreadRunningCheck = now;
        }
    }

    public static synchronized void parseConfingAndKeywordsIfNecessary(Context context, boolean isConfigInit, boolean isConfigRefresh) {
        try {
            sContext = context;
            Log.i("AniwaysBackendSyncChecker", "parseConfingAndKeywordsIfNecessary called. Is config init: " + isConfigInit + " . Is config refresh: " + isConfigRefresh);
            AniwaysBackendSyncChecker.parseIfNecessaryInner(true, isConfigInit || isConfigRefresh, isConfigRefresh);
            if (!isConfigInit && !isConfigRefresh) {
                AniwaysBackendSyncChecker.parseIfNecessaryInner(false, false, false);
            }
        }
        catch (Throwable ex) {
            Log.e(true, "AniwaysBackendSyncChecker", "Caught Exception in parseConfingAndKeywordsIfNecessary", ex);
        }
    }

    private static synchronized void parseIfNecessaryInner(boolean isConfig, boolean setNewVersionOnCallingThread, boolean forceConfigUpdate) {
        try {
            InputStream tempStream;
            JsonParser.InputStreamProvider serverFileStream;
            JsonParser.InputStreamProvider preInstalledFileStream;
            String preInstalledVersion;
            String serverVersion;
            String jsonSupplier;
            block27: {
                jsonSupplier = isConfig ? "config" : "keywords";
                Log.i("AniwaysBackendSyncChecker", "parsing " + jsonSupplier + " if necessary. setNewVersionOnCallingThreadt: " + setNewVersionOnCallingThread + ". forceConfigUpdate: " + forceConfigUpdate);
                serverVersion = "0.0";
                preInstalledVersion = "0.0";
                preInstalledFileStream = null;
                serverFileStream = null;
                try {
                    String packageName = sContext.getPackageName();
                    if (packageName == null) {
                        Log.e(true, "AniwaysBackendSyncChecker", "package Name is null");
                        break block27;
                    }
                    final int id2 = sContext.getResources().getIdentifier("aniways_" + jsonSupplier, "raw", packageName);
                    if (id2 <= 0) {
                        Log.w(false, "AniwaysBackendSyncChecker", jsonSupplier + " file doesn't exist in raw assets");
                        break block27;
                    }
                    try {
                        preInstalledFileStream = new JsonParser.InputStreamProvider(){

                            @Override
                            public InputStream getStream() {
                                return sContext.getResources().openRawResource(id2);
                            }
                        };
                        tempStream = preInstalledFileStream.getStream();
                        if (preInstalledFileStream != null && !Utils.isVersionLegal(preInstalledVersion = AniwaysBackendSyncChecker.getVersionFromStream(tempStream))) {
                            Log.e(true, "AniwaysBackendSyncChecker", "Illegel pre-installed keywords version: " + preInstalledVersion);
                            preInstalledVersion = "0.0";
                        }
                    }
                    catch (Resources.NotFoundException ex) {
                        Log.w(true, "AniwaysBackendSyncChecker", jsonSupplier + " file doesn't exist in raw assets");
                    }
                }
                catch (Throwable ex) {
                    Log.e(true, "AniwaysBackendSyncChecker", "Caught Exception while trying to get pre-installed " + jsonSupplier + " version", ex);
                    preInstalledVersion = "0.0";
                }
            }
            Log.i("AniwaysBackendSyncChecker", String.format("Pre-installed %s version: %s", jsonSupplier, preInstalledVersion));
            try {
                File serverFile = null;
                if (isConfig) {
                    serverFile = new File(AniwaysStorageManager.getConfigFilePath(sContext));
                } else {
                    AniwaysStorageManager storageManager = AniwaysStorageManager.getInstance(sContext);
                    serverFile = new File(storageManager.getKeywordsDir().getAbsolutePath() + "/" + "keywords");
                }
                final File serverFileFinal = serverFile;
                if (!serverFile.exists()) {
                    Log.w(false, "AniwaysBackendSyncChecker", "Server " + jsonSupplier + " file could not be found in: " + serverFile.getAbsolutePath());
                } else {
                    try {
                        serverFileStream = new JsonParser.InputStreamProvider(){

                            @Override
                            public InputStream getStream() throws FileNotFoundException {
                                return new FileInputStream(serverFileFinal);
                            }
                        };
                        tempStream = serverFileStream.getStream();
                        serverVersion = AniwaysBackendSyncChecker.getVersionFromStream(tempStream);
                    }
                    catch (FileNotFoundException e) {
                        Log.e(true, "AniwaysBackendSyncChecker", "Caught FileNotFoundException while reading " + jsonSupplier + " server Json", e);
                        serverVersion = "0.0";
                    }
                }
            }
            catch (Throwable ex) {
                Log.e(true, "AniwaysBackendSyncChecker", "Caught Exception while trying to get server " + jsonSupplier + " version", ex);
                serverVersion = "0.0";
            }
            Log.i("AniwaysBackendSyncChecker", String.format("Server %s version: %s", jsonSupplier, serverVersion));
            String existingVersion = "0.0";
            existingVersion = isConfig ? AniwaysPrivateConfig.getInstance().version : AniwaysPhraseReplacementData.getDataParser().getKeywordsVersion();
            Log.i("AniwaysBackendSyncChecker", String.format("Pre-existing %s version: %s", jsonSupplier, existingVersion));
            if (isConfig && forceConfigUpdate) {
                existingVersion = "0.0";
            }
            JsonSupplier supplier = AniwaysBackendSyncChecker.whichOneToTake(existingVersion, preInstalledVersion, serverVersion, jsonSupplier);
            Log.i("AniwaysBackendSyncChecker", "Going with config supplier: " + (Object)((Object)supplier));
            if (supplier != JsonSupplier.existing) {
                String expectedVersion = null;
                JsonParser.InputStreamProvider stream = null;
                if (supplier == JsonSupplier.preInstalled) {
                    expectedVersion = preInstalledVersion;
                    stream = preInstalledFileStream;
                } else if (supplier == JsonSupplier.server) {
                    expectedVersion = serverVersion;
                    stream = serverFileStream;
                } else {
                    Log.e(true, "AniwaysBackendSyncChecker", "Unknown json supplier: " + (Object)((Object)supplier));
                }
                if (isConfig) {
                    final AniwaysPrivateConfig newConfig = AniwaysPrivateConfig.createNewInstance(stream.getStream());
                    if (setNewVersionOnCallingThread) {
                        AniwaysPrivateConfig.setNewInstance(newConfig);
                    } else {
                        sHandler.post((Runnable)new NonThrowingRunnable("AniwaysBackendSyncChecker", "parse if necessary", jsonSupplier){

                            @Override
                            @SuppressLint(value={"NewApi"})
                            public void innerRun() {
                                AniwaysPrivateConfig.setNewInstance(newConfig);
                            }
                        });
                    }
                } else {
                    final String expectedKeywordsVersion = expectedVersion;
                    final JsonParser newParser = AniwaysPhraseReplacementData.parseData(stream);
                    sHandler.post((Runnable)new NonThrowingRunnable("AniwaysBackendSyncChecker", "parse if necessary", jsonSupplier){

                        @Override
                        @SuppressLint(value={"NewApi"})
                        public void innerRun() {
                            AniwaysPhraseReplacementData.setNewParser(newParser, expectedKeywordsVersion);
                        }
                    });
                }
            }
        }
        catch (Throwable ex) {
            Log.e(true, "AniwaysBackendSyncChecker", "Caught an Exception in parseIfNecessaryInner", ex);
        }
    }

    private static JsonSupplier whichOneToTake(String existingVersion, String preInstalledVersion, String serverVersion, String jsonName) {
        VersionComparisonResult compareResult = null;
        try {
            compareResult = !Utils.isVersionLegal(preInstalledVersion) || !Utils.isVersionLegal(existingVersion) ? (Utils.isVersionLegal(preInstalledVersion) ? new VersionComparisonResult(1) : (Utils.isVersionLegal(existingVersion) ? new VersionComparisonResult(-1) : null)) : Utils.compareVersionStrings(preInstalledVersion, existingVersion);
        }
        catch (IllegalArgumentException e) {
            Log.e(true, "AniwaysBackendSyncChecker", "Error comparing versions of " + jsonName + " version. pre-installed verison:" + preInstalledVersion + ". Esisting: " + existingVersion);
        }
        if (compareResult == null) {
            if (Utils.isVersionLegal(serverVersion)) {
                return JsonSupplier.server;
            }
            return JsonSupplier.existing;
        }
        if (!Utils.isVersionLegal(serverVersion)) {
            if (compareResult.result == 1) {
                return JsonSupplier.preInstalled;
            }
            return JsonSupplier.existing;
        }
        if (compareResult.result == 1) {
            try {
                compareResult = Utils.compareVersionStrings(preInstalledVersion, serverVersion);
            }
            catch (IllegalArgumentException e) {
                Log.e(true, "AniwaysBackendSyncChecker", "Error comparing versions of " + jsonName + " version. pre-installed verison:" + preInstalledVersion + ". Server: " + serverVersion);
                return JsonSupplier.preInstalled;
            }
            if (compareResult.result >= 0) {
                return JsonSupplier.preInstalled;
            }
            return JsonSupplier.server;
        }
        try {
            compareResult = Utils.compareVersionStrings(existingVersion, serverVersion);
        }
        catch (IllegalArgumentException e) {
            Log.e(true, "AniwaysBackendSyncChecker", "Error comparing version of " + jsonName + " version. existing verison:" + existingVersion + ". Server: " + serverVersion);
            return JsonSupplier.existing;
        }
        if (compareResult.result >= 0) {
            return JsonSupplier.existing;
        }
        return JsonSupplier.server;
    }

    static String getVersionFromStream(InputStream stream) {
        String result = null;
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream, "UTF-8"));
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (name.equals("version")) {
                    result = jsonReader.nextString();
                    Log.d("AniwaysBackendSyncChecker", "Discovered version: " + result);
                    break;
                }
                jsonReader.skipValue();
            }
            jsonReader.close();
        }
        catch (Throwable ex) {
            Log.e(true, "AniwaysBackendSyncChecker", "Caught exception while trying to get version from stream", ex);
        }
        try {
            stream.close();
        }
        catch (Throwable tr) {
            Log.w(false, "AniwaysBackendSyncChecker", "Caught Exception while closing stream");
        }
        return result;
    }

    static {
        sLastBackendSyncRequest = 0L;
        sLastBackendSyncThreadRunningCheck = 0L;
    }

    public static enum JsonSupplier {
        existing,
        server,
        preInstalled;

    }
}

