/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    public static void safePut(JSONObject obj, String key, Object val) {
        try {
            obj.put(key, JSONUtils.objectForJSON(val));
        }
        catch (JSONException e) {
            e.printStackTrace(System.err);
        }
    }

    public static void safePutOpt(JSONObject obj, String key, Object val) {
        if (val != null) {
            JSONUtils.safePut(obj, key, val);
        } else {
            obj.remove(key);
        }
    }

    public static void filter(JSONObject object, String[] filters) {
        if (object == null) {
            return;
        }
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (JSONUtils.matchesFilter(key, filters)) {
                JSONUtils.safePut(object, key, "[FILTERED]");
                continue;
            }
            Object value = object.opt(key);
            if (value == null || !(value instanceof JSONObject)) continue;
            JSONUtils.filter((JSONObject)value, filters);
        }
    }

    public static JSONObject deepClone(JSONObject source) {
        if (source == null) {
            return null;
        }
        JSONObject dest = new JSONObject();
        Iterator keys = source.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = source.opt(key);
            if (value == null) continue;
            if (value instanceof JSONObject) {
                value = JSONUtils.deepClone((JSONObject)value);
            }
            JSONUtils.safePut(dest, key, value);
        }
        return dest;
    }

    public static void merge(JSONObject dest, JSONObject source) {
        if (dest == null || source == null) {
            return;
        }
        Iterator keys = source.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object sourceValue = source.opt(key);
            if (sourceValue == null) continue;
            Object destValue = dest.opt(key);
            if (destValue != null && sourceValue instanceof JSONObject && destValue instanceof JSONObject) {
                JSONUtils.merge((JSONObject)destValue, (JSONObject)sourceValue);
                continue;
            }
            JSONUtils.safePut(dest, key, sourceValue);
        }
    }

    static boolean matchesFilter(String key, String[] filters) {
        if (filters == null || key == null) {
            return false;
        }
        for (String filter : filters) {
            if (!key.contains(filter)) continue;
            return true;
        }
        return false;
    }

    static Object objectForJSON(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            JSONObject dest = new JSONObject();
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                JSONUtils.safePut(dest, (String)entry.getKey(), JSONUtils.objectForJSON(entry.getValue()));
            }
            return dest;
        }
        if (value instanceof Object[]) {
            Object[] array;
            JSONArray dest = new JSONArray();
            for (Object val : array = (Object[])value) {
                dest.put(JSONUtils.objectForJSON(val));
            }
            return dest;
        }
        if (value instanceof List) {
            JSONArray dest = new JSONArray();
            List list = (List)value;
            for (Object val : list) {
                dest.put(JSONUtils.objectForJSON(val));
            }
            return dest;
        }
        return value;
    }
}

