/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.aniways.analytics.service.AniwaysAnalyticsService;
import com.aniways.bugsnag.Error;
import com.aniways.bugsnag.MetaData;
import com.aniways.bugsnag.Notification;
import com.aniways.bugsnag.android.ActivityStack;
import com.aniways.bugsnag.android.Diagnostics;
import com.aniways.bugsnag.android.Logger;
import com.aniways.bugsnag.android.utils.Async;
import java.io.File;

public class Client
extends com.aniways.bugsnag.Client {
    private static final String NOTIFIER_NAME = "Android Bugsnag Notifier";
    private static final String NOTIFIER_VERSION = "2.2.0";
    private Logger logger = new Logger();
    private Context applicationContext;
    private String cachePath;

    public Client(Context androidContext, String apiKey, boolean enableMetrics) {
        super(apiKey);
        this.setLogger(this.logger);
        this.applicationContext = androidContext.getApplicationContext();
        this.diagnostics = new Diagnostics(this.config, this.applicationContext, this);
        this.setNotifierName(NOTIFIER_NAME);
        this.setNotifierVersion(NOTIFIER_VERSION);
        this.flushErrors();
        this.logger.info("Bugsnag is loaded and ready to handle exceptions");
    }

    @Override
    public void notify(Throwable e, String severity, MetaData overrides) {
        try {
            if (!this.config.shouldNotify()) {
                return;
            }
            if (this.config.shouldIgnore(e.getClass().getName())) {
                return;
            }
            final Error error = this.createError(e, severity, overrides);
            Async.safeAsync(new Runnable(){

                @Override
                public void run() {
                    Notification notif = Client.this.createNotification(error);
                    StringBuilder deliver = notif.getPayload();
                    Client.this.queuePayload(deliver);
                }
            });
        }
        catch (Throwable t) {
            this.logger.warn("Error notifying Bugsnag", t);
        }
    }

    private void queuePayload(StringBuilder deliver) {
        Intent intent = new Intent(this.applicationContext, AniwaysAnalyticsService.class);
        intent.setAction("Enqueue_Error");
        intent.putExtra("event", deliver.toString());
        this.applicationContext.startService(intent);
    }

    private void flushErrors() {
        if (this.cachePath == null) {
            return;
        }
        Async.safeAsync(new Runnable(){

            @Override
            public void run() {
                File exceptionDir = new File(Client.this.cachePath);
                if (exceptionDir.exists() && exceptionDir.isDirectory()) {
                    Notification notif = null;
                    for (File errorFile : exceptionDir.listFiles()) {
                        try {
                            if (notif == null) {
                                notif = Client.this.createNotification();
                            }
                            notif.setError(errorFile);
                            StringBuilder deliver = notif.getPayload();
                            Client.this.queuePayload(deliver);
                            Client.this.logger.debug("Deleting sent error file " + errorFile.getName());
                            errorFile.delete();
                        }
                        catch (Throwable t) {
                            Client.this.logger.warn("Problem sending unsent error from disk", t);
                            errorFile.delete();
                        }
                    }
                }
            }
        });
    }

    public void setContext(Activity context) {
        String contextString = ActivityStack.getContextName((Context)context);
        this.setContext(contextString);
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        Async.logger = logger;
    }
}

