/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag;

import com.aniways.bugsnag.Client;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler originalHandler;
    private Client client;

    public static void install(Client client) {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof ExceptionHandler) {
            currentHandler = ((ExceptionHandler)currentHandler).originalHandler;
        }
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(currentHandler, client));
    }

    public static void remove() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof ExceptionHandler) {
            Thread.setDefaultUncaughtExceptionHandler(((ExceptionHandler)currentHandler).originalHandler);
        }
    }

    public ExceptionHandler(Thread.UncaughtExceptionHandler originalHandler, Client client) {
        this.originalHandler = originalHandler;
        this.client = client;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.client.autoNotify(e);
        if (this.originalHandler != null) {
            this.originalHandler.uncaughtException(t, e);
        } else {
            System.err.printf("Exception in thread \"%s\" ", t.getName());
            e.printStackTrace(System.err);
        }
    }
}

