/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag;

import com.aniways.Log;
import com.aniways.bugsnag.Configuration;
import com.aniways.bugsnag.Diagnostics;
import com.aniways.bugsnag.MetaData;
import com.aniways.bugsnag.utils.JSONUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Error {
    private static final List<String> ALLOWED_SEVERITIES = Arrays.asList("error", "warning", "info");
    private Throwable exception;
    private Configuration config;
    private MetaData metaData;
    private Diagnostics diagnostics;
    private String severity;
    private String payloadVersion = "2";
    private String groupingHash;

    public Error(Throwable exception, String severity, MetaData metaData, Configuration config, Diagnostics diagnostics) {
        this.exception = exception;
        this.config = config;
        this.metaData = metaData;
        this.diagnostics = diagnostics;
        this.setSeverity(severity);
        if (this.metaData == null) {
            this.metaData = new MetaData();
        }
    }

    public JSONObject toJSON() {
        JSONObject error = new JSONObject();
        JSONUtils.safePut(error, "user", this.diagnostics.getUser());
        JSONUtils.safePutOpt(error, "app", this.diagnostics.getAppData());
        JSONUtils.safePutOpt(error, "appState", this.diagnostics.getAppState());
        JSONUtils.safePutOpt(error, "device", this.diagnostics.getDeviceData());
        JSONUtils.safePutOpt(error, "deviceState", this.diagnostics.getDeviceState());
        JSONUtils.safePut(error, "context", this.diagnostics.getContext());
        JSONUtils.safePut(error, "severity", this.severity);
        JSONUtils.safePut(error, "payloadVersion", this.payloadVersion);
        if (this.groupingHash != null) {
            JSONUtils.safePut(error, "groupingHash", this.groupingHash);
        }
        JSONArray exceptions = new JSONArray();
        for (Throwable currentEx = this.exception; currentEx != null; currentEx = currentEx.getCause()) {
            StackTraceElement[] stackTrace;
            JSONObject exception = new JSONObject();
            JSONUtils.safePut(exception, "errorClass", currentEx.getClass().getName());
            JSONUtils.safePut(exception, "message", currentEx.getLocalizedMessage());
            JSONArray stacktrace = new JSONArray();
            for (StackTraceElement el : stackTrace = currentEx.getStackTrace()) {
                try {
                    JSONObject line = new JSONObject();
                    JSONUtils.safePut(line, "method", el.getClassName() + "." + el.getMethodName());
                    JSONUtils.safePut(line, "file", el.getFileName() == null ? "Unknown" : el.getFileName());
                    JSONUtils.safePut(line, "lineNumber", el.getLineNumber());
                    if (this.config.projectPackages != null) {
                        for (String packageName : this.config.projectPackages) {
                            if (packageName == null || !el.getClassName().startsWith(packageName)) continue;
                            line.put("inProject", true);
                            break;
                        }
                    }
                    stacktrace.put((Object)line);
                }
                catch (Exception lineEx) {
                    Log.eToGaOnly(true, "BugsnagError", "Error in creating Bugsnag Error", lineEx);
                }
            }
            JSONUtils.safePut(exception, "stacktrace", stacktrace);
            exceptions.put((Object)exception);
        }
        JSONUtils.safePut(error, "exceptions", exceptions);
        MetaData errorMetaData = this.config.getMetaData().merge(this.metaData).filter(this.config.filters);
        JSONUtils.safePut(error, "metaData", (Object)errorMetaData);
        return error;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public void addToTab(String tabName, String key, Object value) {
        this.metaData.addToTab(tabName, key, value);
    }

    public boolean shouldIgnore() {
        return this.config.shouldIgnore(this.getExceptionName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(String filename) throws IOException {
        String errorString = this.toString();
        if (errorString.length() > 0) {
            try (FileWriter writer = null;){
                writer = new FileWriter(filename);
                writer.write(errorString);
                writer.flush();
                this.config.logger.debug(String.format("Saved unsent error to disk (%s) ", filename));
            }
        }
    }

    public void setSeverity(String severity) {
        this.severity = severity == null || !ALLOWED_SEVERITIES.contains(severity) ? "warning" : severity;
    }

    public void setGroupingHash(String groupingHash) {
        this.groupingHash = groupingHash;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getExceptionName() {
        return this.exception.getClass().getName();
    }

    public StackTraceElement[] getStackTrace() {
        return this.exception.getStackTrace();
    }

    public MetaData getMetaData() {
        return this.metaData;
    }
}

