/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag;

import com.aniways.bugsnag.Configuration;
import com.aniways.bugsnag.utils.JSONUtils;
import org.json.JSONObject;

public class Diagnostics {
    protected Configuration config;
    protected JSONObject deviceData = new JSONObject();
    protected JSONObject appData = new JSONObject();

    public Diagnostics(Configuration config) {
        this.config = config;
        JSONUtils.safePutOpt(this.deviceData, "osName", System.getProperty("os.name"));
    }

    public JSONObject getAppData() {
        JSONUtils.safePutOpt(this.appData, "version", this.config.appVersion.get());
        JSONUtils.safePutOpt(this.appData, "releaseStage", this.config.releaseStage.get());
        return this.appData;
    }

    public JSONObject getAppState() {
        return new JSONObject();
    }

    public JSONObject getDeviceData() {
        JSONUtils.safePutOpt(this.deviceData, "osVersion", this.config.osVersion.get());
        return this.deviceData;
    }

    public JSONObject getDeviceState() {
        return new JSONObject();
    }

    public String getContext() {
        return this.config.context.get();
    }

    public JSONObject getUser() {
        return this.config.user;
    }

    public JSONObject getMetrics() {
        JSONObject metrics = new JSONObject();
        JSONUtils.safePutOpt(metrics, "user", this.getUser());
        JSONUtils.safePutOpt(metrics, "app", this.getAppData());
        JSONUtils.safePutOpt(metrics, "device", this.getDeviceData());
        return metrics;
    }
}

