/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag;

import com.aniways.bugsnag.BeforeNotify;
import com.aniways.bugsnag.Logger;
import com.aniways.bugsnag.MetaData;
import com.aniways.bugsnag.utils.JSONUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public class Configuration {
    protected static final String DEFAULT_ENDPOINT = "notify.bugsnag.com";
    private static final String NOTIFIER_NAME = "Java Bugsnag Notifier";
    private static final String NOTIFIER_VERSION = "1.2.5";
    private static final String NOTIFIER_URL = "https://bugsnag.com";
    String notifierName = "Java Bugsnag Notifier";
    String notifierVersion = "1.2.5";
    String notifierUrl = "https://bugsnag.com";
    String apiKey;
    boolean autoNotify = true;
    boolean useSSL = false;
    String endpoint = "notify.bugsnag.com";
    String[] notifyReleaseStages = null;
    String[] filters = new String[]{"password"};
    String[] projectPackages;
    String[] ignoreClasses;
    List<BeforeNotify> beforeNotify = new LinkedList<BeforeNotify>();
    LockableValue<String> context = new LockableValue();
    LockableValue<String> releaseStage = new LockableValue<String>("production");
    LockableValue<String> appVersion = new LockableValue();
    LockableValue<String> osVersion = new LockableValue();
    MetaData metaData = new MetaData();
    public JSONObject user = new JSONObject();
    public Logger logger = new Logger();

    public String getNotifyEndpoint() {
        return String.format("%s://%s", this.getProtocol(), this.endpoint);
    }

    public String getMetricsEndpoint() {
        return String.format("%s://%s/metrics", this.getProtocol(), this.endpoint);
    }

    public void addToTab(String tabName, String key, Object value) {
        this.metaData.addToTab(tabName, key, value);
    }

    public void clearTab(String tabName) {
        this.metaData.clearTab(tabName);
    }

    public MetaData getMetaData() {
        return this.metaData.duplicate();
    }

    public boolean shouldNotify() {
        if (this.notifyReleaseStages == null) {
            return true;
        }
        List<String> stages = Arrays.asList(this.notifyReleaseStages);
        return stages.contains(this.releaseStage.get());
    }

    public boolean shouldIgnore(String className) {
        if (this.ignoreClasses == null) {
            return false;
        }
        List<String> classes = Arrays.asList(this.ignoreClasses);
        return classes.contains(className);
    }

    private String getProtocol() {
        return this.useSSL ? "https" : "http";
    }

    public void setUser(String id2, String email, String name) {
        JSONUtils.safePutOpt(this.user, "id", id2);
        JSONUtils.safePutOpt(this.user, "email", email);
        JSONUtils.safePutOpt(this.user, "name", name);
    }

    public LockableValue<String> getContext() {
        return this.context;
    }

    public LockableValue<String> getOsVersion() {
        return this.osVersion;
    }

    public LockableValue<String> getAppVersion() {
        return this.appVersion;
    }

    public LockableValue<String> getReleaseStage() {
        return this.releaseStage;
    }

    public void setNotifyReleaseStages(String ... notifyReleaseStages) {
        this.notifyReleaseStages = notifyReleaseStages;
    }

    public void setAutoNotify(boolean autoNotify) {
        this.autoNotify = autoNotify;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setFilters(String ... filters) {
        this.filters = filters;
    }

    public void setProjectPackages(String ... projectPackages) {
        this.projectPackages = projectPackages;
    }

    public void setNotifierName(String notifierName) {
        this.notifierName = notifierName;
    }

    public void setNotifierVersion(String notifierVersion) {
        this.notifierVersion = notifierVersion;
    }

    public void setNotifierUrl(String notifierUrl) {
        this.notifierUrl = notifierUrl;
    }

    public void setIgnoreClasses(String ... ignoreClasses) {
        this.ignoreClasses = ignoreClasses;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void addBeforeNotify(BeforeNotify beforeNotify) {
        this.beforeNotify.add(beforeNotify);
    }

    public class LockableValue<T> {
        private T value;
        private boolean locked = false;

        LockableValue() {
        }

        LockableValue(T initial) {
            this.value = initial;
        }

        public void set(T value) {
            if (!this.locked) {
                this.value = value;
            }
        }

        public void setLocked(T value) {
            this.value = value;
            this.locked = true;
        }

        public T get(T value) {
            this.set(value);
            return this.get();
        }

        public T get() {
            return this.value;
        }
    }
}

