/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.blur;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.aniways.R;
import com.aniways.blur.ContextualBubbleView;
import com.aniways.data.AniwaysPrivateConfig;

public class ContextualBubbleFrameLayout
extends FrameLayout {
    private ContextualBubbleView mBubbleView;
    private TextView mPoweredBy;
    private TextView mCreditBalance;
    private int mPointerHeight;
    private boolean arrowDown;

    public ContextualBubbleFrameLayout(Context context) {
        super(context);
    }

    public ContextualBubbleFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        this.mCreditBalance = (TextView)this.findViewById(R.id.aniways_quickaction_credits_balance);
        this.mBubbleView = (ContextualBubbleView)this.findViewById(R.id.aniways_contextual_popup_blured_linear_layout);
        this.mPointerHeight = this.mBubbleView.pointerHeight;
        if (this.mPoweredBy != null) {
            ContextualBubbleFrameLayout.addMargins((View)this.mPoweredBy, 0, 0, 0, this.mPointerHeight);
        }
        this.arrowDown = true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mPoweredBy != null) {
            if (AniwaysPrivateConfig.getInstance().removePoweredByAniways) {
                if (this.mPoweredBy.getVisibility() != 8) {
                    this.mPoweredBy.setVisibility(8);
                }
                return;
            }
            if (this.mPoweredBy.getVisibility() == 0) {
                return;
            }
            this.mPoweredBy.measure(-2, -2);
            int poweredByWidthWithMode = this.mPoweredBy.getMeasuredWidth();
            int poweredByWidth = View.MeasureSpec.getSize((int)poweredByWidthWithMode);
            if (poweredByWidth + this.mBubbleView.getPaddingLeft() + this.mBubbleView.getPaddingRight() + 10 < this.mBubbleView.getWidth()) {
                this.mPoweredBy.setVisibility(0);
            }
        }
    }

    public void setArrowDown(float center) {
        this.mBubbleView.setArrowDown(center);
        if (!this.arrowDown) {
            if (this.mPoweredBy != null) {
                ContextualBubbleFrameLayout.addMargins((View)this.mPoweredBy, 0, 0, 0, this.mPointerHeight);
            }
            if (this.mCreditBalance != null) {
                ContextualBubbleFrameLayout.addMargins((View)this.mCreditBalance, 0, -this.mPointerHeight, 0, 0);
            }
        }
        this.arrowDown = true;
    }

    public void setArrowUp(float center) {
        this.mBubbleView.setArrowUp(center);
        if (this.arrowDown) {
            if (this.mPoweredBy != null) {
                ContextualBubbleFrameLayout.addMargins((View)this.mPoweredBy, 0, 0, 0, -this.mPointerHeight);
            }
            if (this.mCreditBalance != null) {
                ContextualBubbleFrameLayout.addMargins((View)this.mCreditBalance, 0, this.mPointerHeight, 0, 0);
            }
        }
        this.arrowDown = false;
    }

    private static void addMargins(View v, int l, int t, int r, int b) {
        if (v.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
            p.setMargins(p.leftMargin + l, p.topMargin + t, p.rightMargin + r, p.bottomMargin + b);
            v.requestLayout();
        }
    }
}

