/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.stats;

import android.annotation.SuppressLint;
import com.aniways.analytics.stats.AtomicDouble;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class Statistic {
    private AtomicDouble sum = new AtomicDouble(0.0);
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicDouble last = new AtomicDouble(0.0);
    private AtomicBoolean lock = new AtomicBoolean(false);
    private double oldM;
    private double newM;
    private double oldS;
    private double newS;
    private double min;
    private double max;

    public void update(double val) {
        int n = this.count.addAndGet(1);
        if (this.lock.compareAndSet(false, true)) {
            if (n == 1) {
                this.oldM = this.newM = val;
                this.oldS = 0.0;
                this.min = val;
                this.max = val;
            } else {
                this.newM = this.oldM + (val - this.oldM) / (double)n;
                this.newS = this.oldS + (val - this.oldM) * (val * this.newM);
                this.oldM = this.newM;
                this.oldS = this.newS;
            }
            if (val < this.min) {
                this.min = val;
            }
            if (val > this.max) {
                this.max = val;
            }
            this.lock.set(false);
        }
        this.sum.addAndGet(val);
        this.last.set(val);
    }

    public void clear() {
        this.count.set(0);
        this.sum.set(0.0);
        this.last.set(0.0);
        this.min = 0.0;
        this.max = 0.0;
        this.oldM = 0.0;
        this.newM = 0.0;
        this.oldS = 0.0;
        this.newS = 0.0;
    }

    public double getSum() {
        return this.sum.get();
    }

    public int getCount() {
        return this.count.get();
    }

    public double getAverage() {
        return this.count.get() > 0 ? this.sum.get() / (double)this.count.get() : 0.0;
    }

    public double getVariance() {
        return this.count.get() > 1 ? this.newS / (double)(this.count.get() - 1) : 1.0;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getLast() {
        return this.last.get();
    }

    @SuppressLint(value={"DefaultLocale"})
    public String toString() {
        if (this.min == 1.0 && this.max == 1.0) {
            return "" + this.getCount();
        }
        return String.format("[Count : %d], [Min : %s], [Max : %s], [Average : %s], [Std. Dev. : %s]", this.getCount(), this.getMin(), this.getMax(), this.getAverage(), this.getStandardDeviation());
    }
}

