/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.request.azure;

import android.os.Build;
import android.text.TextUtils;
import com.aniways.analytics.request.azure.BlobQueueFullCanonicalizer;
import com.aniways.analytics.request.azure.Canonicalizer;
import com.aniways.analytics.request.azure.Credentials;
import com.aniways.analytics.request.azure.StorageKey;
import com.aniways.analytics.request.azure.Utility;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Installation;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;

public final class AzureRequest {
    private static String userAgent;

    public static void addAzureHeaders(HttpURLConnection connection, long contentLength, String date) throws InvalidKeyException {
        connection.setRequestProperty("Accept", "application/xml");
        connection.setRequestProperty("Accept-Charset", "UTF-8");
        connection.setRequestProperty("Accept-Encoding", "");
        connection.setRequestProperty("x-ms-blob-type", "BlockBlob");
        String installId = Installation.id();
        connection.setRequestProperty("x-ms-client-request-id", installId == null ? "unknown" : installId);
        connection.setRequestProperty("x-ms-version", "2014-02-14");
        connection.setRequestProperty("User-Agent", AzureRequest.getUserAgent());
        Credentials creds = new Credentials(AniwaysPrivateConfig.getInstance().azureAnalyticsStorageAccountName, AniwaysPrivateConfig.getInstance().azureAnalyticsKey);
        AzureRequest.signRequestForBlobAndQueue(connection, creds, contentLength, date);
    }

    private static String getUserAgent() {
        if (userAgent == null) {
            String userAgentComment = String.format(Utility.LOCALE_US, "(Android %s; %s; %s)", Build.VERSION.RELEASE, Build.BRAND, Build.MODEL);
            userAgent = String.format("%s/%s %s", "Azure-Storage", "0.1.0", userAgentComment);
        }
        return userAgent;
    }

    private static void signRequestForBlobAndQueue(HttpURLConnection request, Credentials credentials, Long contentLength, String date) throws InvalidKeyException {
        request.setRequestProperty("x-ms-date", TextUtils.isEmpty((CharSequence)date) ? Utility.getGMTTime() : date);
        BlobQueueFullCanonicalizer canonicalizer = BlobQueueFullCanonicalizer.insatnce;
        String stringToSign = ((Canonicalizer)canonicalizer).canonicalize(request, credentials.accountName, contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.key, stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", credentials.accountName, computedBase64Signature));
    }
}

